/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job.savepoints;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.runtime.rest.messages.RestResponseMarshallingTestBase;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointInfo;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.util.SerializedThrowable;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class SavepointInfoMarshallingTest
extends RestResponseMarshallingTestBase<SavepointInfo> {
    private final SavepointInfo savepointInfo;

    @Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({new SavepointInfo("/tmp", null)}, {new SavepointInfo(null, new SerializedThrowable((Throwable)new RuntimeException("expected")))});
    }

    public SavepointInfoMarshallingTest(SavepointInfo savepointInfo) {
        this.savepointInfo = savepointInfo;
    }

    @Override
    protected Class<SavepointInfo> getTestResponseClass() {
        return SavepointInfo.class;
    }

    @Override
    protected SavepointInfo getTestResponseInstance() throws Exception {
        return this.savepointInfo;
    }

    @Override
    protected void assertOriginalEqualsToUnmarshalled(SavepointInfo expected, SavepointInfo actual) {
        Assertions.assertThat((String)actual.getLocation()).isEqualTo(expected.getLocation());
        if (expected.getFailureCause() != null) {
            Assertions.assertThat((Throwable)actual.getFailureCause()).isNotNull();
            Assertions.assertThat((String)actual.getFailureCause().deserializeError(ClassLoader.getSystemClassLoader()).getMessage()).isEqualTo(expected.getFailureCause().deserializeError(ClassLoader.getSystemClassLoader()).getMessage());
        }
    }
}

