/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.savepoints;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.dispatcher.UnknownOperationKeyException;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.async.AsynchronousOperationResult;
import org.apache.flink.runtime.rest.handler.async.OperationResult;
import org.apache.flink.runtime.rest.handler.async.TriggerResponse;
import org.apache.flink.runtime.rest.handler.job.AsynchronousJobOperationKey;
import org.apache.flink.runtime.rest.handler.job.savepoints.SavepointHandlers;
import org.apache.flink.runtime.rest.handler.job.savepoints.SavepointTestUtilities;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.TriggerId;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointInfo;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointStatusMessageParameters;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointTriggerMessageParameters;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointTriggerRequestBody;
import org.apache.flink.runtime.rest.messages.queue.QueueStatus;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.TriFunction;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SavepointHandlersTest {
    private static final Duration TIMEOUT = Duration.ofSeconds(10L);
    private static final JobID JOB_ID = new JobID();
    private static final String COMPLETED_SAVEPOINT_EXTERNAL_POINTER = "/tmp/savepoint-0d2fb9-8d5e0106041a";
    private static final String DEFAULT_REQUESTED_SAVEPOINT_TARGET_DIRECTORY = "/tmp";
    private SavepointHandlers.SavepointTriggerHandler savepointTriggerHandler;
    private SavepointHandlers.SavepointStatusHandler savepointStatusHandler;
    private GatewayRetriever<RestfulGateway> leaderRetriever;

    SavepointHandlersTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        SavepointHandlers savepointHandlers;
        this.leaderRetriever = () -> CompletableFuture.completedFuture(null);
        SavepointHandlers savepointHandlers2 = savepointHandlers = new SavepointHandlers(null);
        Objects.requireNonNull(savepointHandlers2);
        this.savepointTriggerHandler = new SavepointHandlers.SavepointTriggerHandler(savepointHandlers2, this.leaderRetriever, TIMEOUT, Collections.emptyMap());
        this.savepointStatusHandler = new SavepointHandlers.SavepointStatusHandler(this.leaderRetriever, TIMEOUT, Collections.emptyMap());
    }

    @Test
    void testSavepointCompletedSuccessfully() throws Exception {
        OperationResult successfulResult = OperationResult.success((Serializable)((Object)COMPLETED_SAVEPOINT_EXTERNAL_POINTER));
        AtomicReference<AsynchronousJobOperationKey> keyReference = new AtomicReference<AsynchronousJobOperationKey>();
        TestingRestfulGateway testingRestfulGateway = ((TestingRestfulGateway.Builder)((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setTriggerSavepointFunction((TriFunction)SavepointTestUtilities.setReferenceToOperationKey(keyReference))).setGetSavepointStatusFunction((Function)SavepointTestUtilities.getResultIfKeyMatches((OperationResult<String>)successfulResult, keyReference))).build();
        TriggerId triggerId = ((TriggerResponse)this.savepointTriggerHandler.handleRequest(SavepointHandlersTest.triggerSavepointRequest(), (RestfulGateway)testingRestfulGateway).get()).getTriggerId();
        AsynchronousOperationResult savepointResponseBody = (AsynchronousOperationResult)this.savepointStatusHandler.handleRequest(SavepointHandlersTest.savepointStatusRequest(triggerId), (RestfulGateway)testingRestfulGateway).get();
        Assertions.assertThat((Comparable)savepointResponseBody.queueStatus().getId()).isEqualTo((Object)QueueStatus.Id.COMPLETED);
        Assertions.assertThat((Object)((SavepointInfo)savepointResponseBody.resource())).isNotNull();
        Assertions.assertThat((String)((SavepointInfo)savepointResponseBody.resource()).getLocation()).isEqualTo(COMPLETED_SAVEPOINT_EXTERNAL_POINTER);
    }

    @Test
    void testTriggerSavepointWithDefaultDirectory() throws Exception {
        SavepointHandlers savepointHandlers;
        CompletableFuture targetDirectoryFuture = new CompletableFuture();
        TestingRestfulGateway testingRestfulGateway = ((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setTriggerSavepointFunction((operationKey, targetDirectory, formatType) -> {
            targetDirectoryFuture.complete(targetDirectory);
            return CompletableFuture.completedFuture(Acknowledge.get());
        })).build();
        String defaultSavepointDir = "/other/dir";
        SavepointHandlers savepointHandlers2 = savepointHandlers = new SavepointHandlers("/other/dir");
        Objects.requireNonNull(savepointHandlers2);
        SavepointHandlers.SavepointTriggerHandler savepointTriggerHandler = new SavepointHandlers.SavepointTriggerHandler(savepointHandlers2, this.leaderRetriever, TIMEOUT, Collections.emptyMap());
        savepointTriggerHandler.handleRequest(SavepointHandlersTest.triggerSavepointRequestWithDefaultDirectory(), (RestfulGateway)testingRestfulGateway).get();
        Assertions.assertThat((String)((String)targetDirectoryFuture.get())).isEqualTo("/other/dir");
    }

    @Test
    void testTriggerSavepointNoDirectory() throws Exception {
        TestingRestfulGateway testingRestfulGateway = ((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setTriggerSavepointFunction((operationKey, directory, formatType) -> CompletableFuture.completedFuture(Acknowledge.get()))).build();
        try {
            this.savepointTriggerHandler.handleRequest(SavepointHandlersTest.triggerSavepointRequestWithDefaultDirectory(), (RestfulGateway)testingRestfulGateway).get();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (RestHandlerException rhe) {
            Assertions.assertThat((String)rhe.getMessage()).isEqualTo("Config key [execution.checkpointing.savepoint-dir] is not set. Property [target-directory] must be provided.");
            Assertions.assertThat((Comparable)rhe.getHttpResponseStatus()).isEqualTo((Object)HttpResponseStatus.BAD_REQUEST);
        }
    }

    @Test
    void testSavepointCompletedWithException() throws Exception {
        OperationResult failedResult = OperationResult.failure((Throwable)new RuntimeException("expected"));
        AtomicReference<AsynchronousJobOperationKey> keyReference = new AtomicReference<AsynchronousJobOperationKey>();
        TestingRestfulGateway testingRestfulGateway = ((TestingRestfulGateway.Builder)((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setTriggerSavepointFunction((TriFunction)SavepointTestUtilities.setReferenceToOperationKey(keyReference))).setGetSavepointStatusFunction((Function)SavepointTestUtilities.getResultIfKeyMatches((OperationResult<String>)failedResult, keyReference))).build();
        TriggerId triggerId = ((TriggerResponse)this.savepointTriggerHandler.handleRequest(SavepointHandlersTest.triggerSavepointRequest(), (RestfulGateway)testingRestfulGateway).get()).getTriggerId();
        AsynchronousOperationResult savepointResponseBody = (AsynchronousOperationResult)this.savepointStatusHandler.handleRequest(SavepointHandlersTest.savepointStatusRequest(triggerId), (RestfulGateway)testingRestfulGateway).get();
        Assertions.assertThat((Comparable)savepointResponseBody.queueStatus().getId()).isEqualTo((Object)QueueStatus.Id.COMPLETED);
        Assertions.assertThat((Object)((SavepointInfo)savepointResponseBody.resource())).isNotNull();
        Assertions.assertThat((Throwable)((SavepointInfo)savepointResponseBody.resource()).getFailureCause()).isNotNull();
        Throwable savepointError = ((SavepointInfo)savepointResponseBody.resource()).getFailureCause().deserializeError(ClassLoader.getSystemClassLoader());
        Assertions.assertThat((String)savepointError.getMessage()).isEqualTo("expected");
        Assertions.assertThat((Throwable)savepointError).isInstanceOf(RuntimeException.class);
    }

    @Test
    void testProvidedTriggerId() throws Exception {
        OperationResult successfulResult = OperationResult.success((Serializable)((Object)COMPLETED_SAVEPOINT_EXTERNAL_POINTER));
        AtomicReference<AsynchronousJobOperationKey> keyReference = new AtomicReference<AsynchronousJobOperationKey>();
        TestingRestfulGateway testingRestfulGateway = ((TestingRestfulGateway.Builder)((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setTriggerSavepointFunction((TriFunction)SavepointTestUtilities.setReferenceToOperationKey(keyReference))).setGetSavepointStatusFunction((Function)SavepointTestUtilities.getResultIfKeyMatches((OperationResult<String>)successfulResult, keyReference))).build();
        TriggerId providedTriggerId = new TriggerId();
        TriggerId returnedTriggerId = ((TriggerResponse)this.savepointTriggerHandler.handleRequest(SavepointHandlersTest.triggerSavepointRequest(DEFAULT_REQUESTED_SAVEPOINT_TARGET_DIRECTORY, SavepointFormatType.CANONICAL, providedTriggerId), (RestfulGateway)testingRestfulGateway).get()).getTriggerId();
        Assertions.assertThat((Comparable)returnedTriggerId).isEqualTo((Object)providedTriggerId);
        AsynchronousOperationResult savepointResponseBody = (AsynchronousOperationResult)this.savepointStatusHandler.handleRequest(SavepointHandlersTest.savepointStatusRequest(providedTriggerId), (RestfulGateway)testingRestfulGateway).get();
        Assertions.assertThat((Comparable)savepointResponseBody.queueStatus().getId()).isEqualTo((Object)QueueStatus.Id.COMPLETED);
        Assertions.assertThat((Object)((SavepointInfo)savepointResponseBody.resource())).isNotNull();
        Assertions.assertThat((String)((SavepointInfo)savepointResponseBody.resource()).getLocation()).isEqualTo(COMPLETED_SAVEPOINT_EXTERNAL_POINTER);
    }

    @Test
    void testQueryStatusOfUnknownOperationReturnsError() throws HandlerRequestException, RestHandlerException {
        TestingRestfulGateway testingRestfulGateway = ((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setGetSavepointStatusFunction(key -> FutureUtils.completedExceptionally((Throwable)new UnknownOperationKeyException(key)))).build();
        CompletableFuture statusFuture = this.savepointStatusHandler.handleRequest(SavepointHandlersTest.savepointStatusRequest(new TriggerId()), (RestfulGateway)testingRestfulGateway);
        FlinkAssertions.assertThatFuture((CompletableFuture)statusFuture).eventuallyFailsWith(ExecutionException.class).withCauseInstanceOf(RestHandlerException.class).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Comparable)((RestHandlerException)e.getCause()).getHttpResponseStatus()).isEqualTo((Object)HttpResponseStatus.NOT_FOUND)});
    }

    private static HandlerRequest<SavepointTriggerRequestBody> triggerSavepointRequest() throws HandlerRequestException {
        return SavepointHandlersTest.triggerSavepointRequest(DEFAULT_REQUESTED_SAVEPOINT_TARGET_DIRECTORY, null, null);
    }

    private static HandlerRequest<SavepointTriggerRequestBody> triggerSavepointRequestWithDefaultDirectory() throws HandlerRequestException {
        return SavepointHandlersTest.triggerSavepointRequest(null, null, null);
    }

    private static HandlerRequest<SavepointTriggerRequestBody> triggerSavepointRequest(@Nullable String targetDirectory, @Nullable SavepointFormatType formatType, @Nullable TriggerId triggerId) throws HandlerRequestException {
        return HandlerRequest.resolveParametersAndCreate((RequestBody)new SavepointTriggerRequestBody(targetDirectory, Boolean.valueOf(false), formatType, triggerId), (MessageParameters)new SavepointTriggerMessageParameters(), Collections.singletonMap("jobid", JOB_ID.toString()), Collections.emptyMap(), Collections.emptyList());
    }

    private static HandlerRequest<EmptyRequestBody> savepointStatusRequest(TriggerId triggerId) throws HandlerRequestException {
        HashMap<String, String> pathParameters = new HashMap<String, String>();
        pathParameters.put("jobid", JOB_ID.toString());
        pathParameters.put("triggerid", triggerId.toString());
        return HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new SavepointStatusMessageParameters(), pathParameters, Collections.emptyMap(), Collections.emptyList());
    }
}

