/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.stream.Stream;
import org.apache.flink.runtime.rest.handler.job.metrics.DoubleAccumulator;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class DoubleAccumulatorTest {
    @ParameterizedTest
    @MethodSource(value={"dataSkewTests"})
    public void testDataSkew(double n1, double n2, double n3, double expectedSkew) {
        DoubleAccumulator.DoubleDataSkew dataSkew = DoubleAccumulator.DoubleDataSkewFactory.get().get(n1);
        dataSkew.add(n2);
        dataSkew.add(n3);
        AssertionsForClassTypes.assertThat((double)dataSkew.getValue()).isCloseTo(expectedSkew, AssertionsForClassTypes.within((Double)0.5));
    }

    @Test
    public void testDataSkewOnEmptyList() {
        DoubleAccumulator.DoubleDataSkew dataSkew = new DoubleAccumulator.DoubleDataSkew();
        AssertionsForClassTypes.assertThat((double)dataSkew.getValue()).isEqualTo(0.0);
    }

    @Test
    public void testDataSkewOnSingleValueList() {
        DoubleAccumulator.DoubleDataSkew dataSkew = DoubleAccumulator.DoubleDataSkewFactory.get().get(123.0);
        AssertionsForClassTypes.assertThat((double)dataSkew.getValue()).isEqualTo(0.0);
    }

    private static Stream<Arguments> dataSkewTests() {
        return Stream.of(Arguments.of((Object[])new Object[]{23.0, 3.0, 10.0, 61.0}), Arguments.of((Object[])new Object[]{300.0, 0.0, 0.0, 100.0}), Arguments.of((Object[])new Object[]{0.0, 0.0, 0.0, 0.0}), Arguments.of((Object[])new Object[]{50.0, 51.0, 52.0, 1.0}));
    }
}

