/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils;

import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.operators.testutils.DriverTestBase;
import org.apache.flink.util.ExceptionUtils;
import org.assertj.core.api.Assertions;

public class TaskCancelThread
extends Thread {
    private final DriverTestBase<?> cancelDriver;
    private final AbstractInvokable cancelTask;
    private final Thread interruptedThread;
    private final int cancelTimeout;

    public TaskCancelThread(int cancelTimeout, Thread interruptedThread, DriverTestBase<?> canceledTask) {
        this.cancelTimeout = cancelTimeout;
        this.interruptedThread = interruptedThread;
        this.cancelDriver = canceledTask;
        this.cancelTask = null;
    }

    public TaskCancelThread(int cancelTimeout, Thread interruptedThread, AbstractInvokable canceledTask) {
        this.cancelTimeout = cancelTimeout;
        this.interruptedThread = interruptedThread;
        this.cancelDriver = null;
        this.cancelTask = canceledTask;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(this.cancelTimeout * 1000);
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"CancelThread interruped while waiting for cancel timeout");
        }
        try {
            if (this.cancelDriver != null) {
                this.cancelDriver.cancel();
            }
            if (this.cancelTask != null) {
                this.cancelTask.cancel();
            }
            this.interruptedThread.interrupt();
        }
        catch (Exception e) {
            Assertions.fail((String)("Canceling task failed: " + ExceptionUtils.stringifyException((Throwable)e)));
        }
    }
}

