/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.curator.test.TestingServer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedLeaderService;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.leaderelection.DefaultLeaderElectionService;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderelection.StandaloneLeaderElection;
import org.apache.flink.runtime.leaderelection.ZooKeeperLeaderElectionDriverFactory;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.testutils.ZooKeeperTestUtils;
import org.apache.flink.runtime.util.TestingFatalErrorHandlerExtension;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;

@ExtendWith(value={ParameterizedTestExtension.class})
public class LeaderElectionTest {
    @RegisterExtension
    private static final TestExecutorExtension<ScheduledExecutorService> EXECUTOR_RESOURCE = TestingUtils.defaultExecutorExtension();
    @RegisterExtension
    private final TestingFatalErrorHandlerExtension testingFatalErrorHandlerResource = new TestingFatalErrorHandlerExtension();
    @Parameter
    public ServiceClass serviceClass;

    @Parameters(name="Leader election: {0}")
    public static Collection<ServiceClass> parameters() {
        return Arrays.asList(new ZooKeeperServiceClass(), new EmbeddedServiceClass(), new StandaloneServiceClass());
    }

    @BeforeEach
    void setup() throws Exception {
        this.serviceClass.setup(this.testingFatalErrorHandlerResource.getTestingFatalErrorHandler());
    }

    @AfterEach
    void teardown() throws Exception {
        this.serviceClass.teardown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    void testHasLeadershipAsync() throws Exception {
        ManualLeaderContender manualLeaderContender = new ManualLeaderContender();
        try {
            LeaderElection leaderElection = this.serviceClass.createLeaderElection();
            leaderElection.startLeaderElection((LeaderContender)manualLeaderContender);
            UUID leaderSessionId = manualLeaderContender.waitForLeaderSessionId();
            FlinkAssertions.assertThatFuture((CompletableFuture)leaderElection.hasLeadershipAsync(leaderSessionId)).eventuallySucceeds().isEqualTo((Object)true);
            FlinkAssertions.assertThatFuture((CompletableFuture)leaderElection.hasLeadershipAsync(UUID.randomUUID())).eventuallySucceeds().isEqualTo((Object)false);
            FlinkAssertions.assertThatFuture((CompletableFuture)leaderElection.confirmLeadershipAsync(leaderSessionId, "foobar")).eventuallySucceeds();
            FlinkAssertions.assertThatFuture((CompletableFuture)leaderElection.hasLeadershipAsync(leaderSessionId)).eventuallySucceeds().isEqualTo((Object)true);
            leaderElection.close();
            FlinkAssertions.assertThatFuture((CompletableFuture)leaderElection.hasLeadershipAsync(leaderSessionId)).eventuallySucceeds().isEqualTo((Object)false);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)manualLeaderContender.waitForLeaderSessionId()).as("The leadership has been revoked from the contender.", new Object[0])).isEqualTo((Object)ManualLeaderContender.NULL_LEADER_SESSION_ID);
        }
        finally {
            manualLeaderContender.rethrowError();
        }
    }

    private static final class StandaloneServiceClass
    implements ServiceClass {
        private StandaloneServiceClass() {
        }

        @Override
        public void setup(FatalErrorHandler fatalErrorHandler) {
        }

        @Override
        public void teardown() {
        }

        @Override
        public LeaderElection createLeaderElection() {
            return new StandaloneLeaderElection(UUID.randomUUID());
        }
    }

    private static final class EmbeddedServiceClass
    implements ServiceClass {
        private EmbeddedLeaderService embeddedLeaderService;

        private EmbeddedServiceClass() {
        }

        @Override
        public void setup(FatalErrorHandler fatalErrorHandler) {
            this.embeddedLeaderService = new EmbeddedLeaderService((Executor)EXECUTOR_RESOURCE.getExecutor());
        }

        @Override
        public void teardown() {
            if (this.embeddedLeaderService != null) {
                this.embeddedLeaderService.shutdown();
                this.embeddedLeaderService = null;
            }
        }

        @Override
        public LeaderElection createLeaderElection() {
            return this.embeddedLeaderService.createLeaderElectionService("embedded_leader_election");
        }
    }

    private static final class ZooKeeperServiceClass
    implements ServiceClass {
        private TestingServer testingServer;
        private CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper;
        private DefaultLeaderElectionService leaderElectionService;

        private ZooKeeperServiceClass() {
        }

        @Override
        public void setup(FatalErrorHandler fatalErrorHandler) throws Exception {
            try {
                this.testingServer = ZooKeeperTestUtils.createAndStartZookeeperTestingServer();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not start ZooKeeper testing cluster.", e);
            }
            Configuration configuration = new Configuration();
            configuration.set(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, (Object)this.testingServer.getConnectString());
            configuration.set(HighAvailabilityOptions.HA_MODE, (Object)"zookeeper");
            this.curatorFrameworkWrapper = ZooKeeperUtils.startCuratorFramework((Configuration)configuration, (FatalErrorHandler)fatalErrorHandler);
            ZooKeeperLeaderElectionDriverFactory driverFactory = new ZooKeeperLeaderElectionDriverFactory(this.curatorFrameworkWrapper.asCuratorFramework());
            this.leaderElectionService = new DefaultLeaderElectionService((LeaderElectionDriverFactory)driverFactory);
        }

        @Override
        public void teardown() throws Exception {
            if (this.leaderElectionService != null) {
                this.leaderElectionService.close();
            }
            if (this.curatorFrameworkWrapper != null) {
                this.curatorFrameworkWrapper.close();
                this.curatorFrameworkWrapper = null;
            }
            if (this.testingServer != null) {
                this.testingServer.close();
                this.testingServer = null;
            }
        }

        @Override
        public LeaderElection createLeaderElection() {
            return this.leaderElectionService.createLeaderElection("random-component-id");
        }
    }

    private static interface ServiceClass {
        public void setup(FatalErrorHandler var1) throws Exception;

        public void teardown() throws Exception;

        public LeaderElection createLeaderElection() throws Exception;
    }

    private static final class ManualLeaderContender
    implements LeaderContender {
        private static final UUID NULL_LEADER_SESSION_ID = new UUID(0L, 0L);
        private final ArrayBlockingQueue<UUID> leaderSessionIds = new ArrayBlockingQueue(10);
        private volatile Exception exception;

        private ManualLeaderContender() {
        }

        public void grantLeadership(UUID leaderSessionID) {
            this.leaderSessionIds.offer(leaderSessionID);
        }

        public void revokeLeadership() {
            this.leaderSessionIds.offer(NULL_LEADER_SESSION_ID);
        }

        public void handleError(Exception exception) {
            this.exception = exception;
        }

        void rethrowError() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
        }

        UUID waitForLeaderSessionId() throws InterruptedException {
            return this.leaderSessionIds.take();
        }
    }
}

