/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.jsonplan;

import java.util.List;
import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public class StreamGraphJsonSchema {
    public static final String FIELD_NAME_NODES = "nodes";
    @JsonProperty(value="nodes")
    private final List<JsonStreamNodeSchema> nodes;

    @JsonCreator
    public StreamGraphJsonSchema(@JsonProperty(value="nodes") List<JsonStreamNodeSchema> nodes) {
        this.nodes = nodes;
    }

    @JsonIgnore
    public List<JsonStreamNodeSchema> getNodes() {
        return this.nodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamGraphJsonSchema that = (StreamGraphJsonSchema)o;
        return Objects.equals(this.nodes, that.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.nodes);
    }

    public static class JsonStreamEdgeSchema {
        public static final String FIELD_NAME_EDGE_INPUT_NUM = "num";
        public static final String FIELD_NAME_EDGE_ID = "id";
        public static final String FIELD_NAME_EDGE_SHIP_STRATEGY = "ship_strategy";
        public static final String FIELD_NAME_EDGE_EXCHANGE = "exchange";
        @JsonProperty(value="num")
        private final Integer num;
        @JsonProperty(value="id")
        private final String id;
        @JsonProperty(value="ship_strategy")
        private final String shipStrategy;
        @JsonProperty(value="exchange")
        private final String exchange;

        @JsonCreator
        public JsonStreamEdgeSchema(@JsonProperty(value="num") Integer num, @JsonProperty(value="id") String id, @JsonProperty(value="ship_strategy") String shipStrategy, @JsonProperty(value="exchange") String exchange) {
            this.num = num;
            this.id = id;
            this.shipStrategy = shipStrategy;
            this.exchange = exchange;
        }

        @JsonIgnore
        public Integer getNum() {
            return this.num;
        }

        @JsonIgnore
        public String getId() {
            return this.id;
        }

        @JsonIgnore
        public String getShipStrategy() {
            return this.shipStrategy;
        }

        @JsonIgnore
        public String getExchange() {
            return this.exchange;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonStreamEdgeSchema that = (JsonStreamEdgeSchema)o;
            return Objects.equals(this.num, that.num) && Objects.equals(this.id, that.id) && Objects.equals(this.shipStrategy, that.shipStrategy) && Objects.equals(this.exchange, that.exchange);
        }

        public int hashCode() {
            return Objects.hash(this.num, this.id, this.shipStrategy, this.exchange);
        }
    }

    public static class JsonStreamNodeSchema {
        public static final String FIELD_NAME_NODE_ID = "id";
        public static final String FIELD_NAME_NODE_PARALLELISM = "parallelism";
        public static final String FIELD_NAME_NODE_OPERATOR = "operator";
        public static final String FIELD_NAME_NODE_DESCRIPTION = "description";
        public static final String FIELD_NAME_NODE_JOB_VERTEX_ID = "job_vertex_id";
        public static final String FIELD_NAME_NODE_INPUTS = "inputs";
        @JsonProperty(value="id")
        private final String id;
        @JsonProperty(value="parallelism")
        private final Integer parallelism;
        @JsonProperty(value="operator")
        private final String operator;
        @JsonProperty(value="description")
        private final String description;
        @JsonProperty(value="job_vertex_id")
        private final String jobVertexId;
        @JsonProperty(value="inputs")
        private final List<JsonStreamEdgeSchema> inputs;

        @JsonCreator
        public JsonStreamNodeSchema(@JsonProperty(value="id") String id, @JsonProperty(value="parallelism") Integer parallelism, @JsonProperty(value="operator") String operator, @JsonProperty(value="description") String description, @JsonProperty(value="job_vertex_id") String jobVertexId, @JsonProperty(value="inputs") List<JsonStreamEdgeSchema> inputs) {
            this.id = id;
            this.parallelism = parallelism;
            this.operator = operator;
            this.description = description;
            this.jobVertexId = jobVertexId;
            this.inputs = inputs;
        }

        @JsonIgnore
        public String getId() {
            return this.id;
        }

        @JsonIgnore
        public Integer getParallelism() {
            return this.parallelism;
        }

        @JsonIgnore
        public String getOperator() {
            return this.operator;
        }

        @JsonIgnore
        public String getDescription() {
            return this.description;
        }

        @JsonIgnore
        public String getJobVertexId() {
            return this.jobVertexId;
        }

        @JsonIgnore
        public List<JsonStreamEdgeSchema> getInputs() {
            return this.inputs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonStreamNodeSchema that = (JsonStreamNodeSchema)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.parallelism, that.parallelism) && Objects.equals(this.operator, that.operator) && Objects.equals(this.description, that.description) && Objects.equals(this.jobVertexId, that.jobVertexId) && Objects.equals(this.inputs, that.inputs);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.parallelism, this.operator, this.description, this.jobVertexId, this.inputs);
        }
    }
}

