/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileDataIndexRegionHelper;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileDataIndexSpilledRegionManager;

public class TestingFileDataIndexSpilledRegionManager<T extends FileDataIndexRegionHelper.Region>
implements FileDataIndexSpilledRegionManager<T> {
    private final List<TreeMap<Integer, T>> regions = new ArrayList<TreeMap<Integer, T>>();
    private final BiConsumer<Integer, T> cacheRegionConsumer;
    private int findRegionInvoked = 0;

    public TestingFileDataIndexSpilledRegionManager(int numSubpartitions, BiConsumer<Integer, T> cacheRegionConsumer) {
        this.cacheRegionConsumer = cacheRegionConsumer;
        for (int i = 0; i < numSubpartitions; ++i) {
            this.regions.add(new TreeMap());
        }
    }

    @Nullable
    public T getRegion(int subpartition, int bufferIndex) {
        return (T)((FileDataIndexRegionHelper.Region)this.regions.get(subpartition).get(bufferIndex));
    }

    public int getSpilledRegionSize(int subpartition) {
        return this.regions.get(subpartition).size();
    }

    public int getFindRegionInvoked() {
        return this.findRegionInvoked;
    }

    public void appendOrOverwriteRegion(int subpartition, T region) {
        this.regions.get(subpartition).put(region.getFirstBufferIndex(), region);
    }

    public long findRegion(int subpartition, int bufferIndex, boolean loadToCache) {
        ++this.findRegionInvoked;
        FileDataIndexRegionHelper.Region region = (FileDataIndexRegionHelper.Region)this.regions.get(subpartition).get(bufferIndex);
        if (region == null) {
            return -1L;
        }
        if (loadToCache) {
            this.cacheRegionConsumer.accept(subpartition, (Integer)region);
        }
        return 1L;
    }

    public void close() throws IOException {
    }

    public static class Factory<T extends FileDataIndexRegionHelper.Region>
    implements FileDataIndexSpilledRegionManager.Factory<T> {
        public TestingFileDataIndexSpilledRegionManager<T> lastSpilledRegionManager;

        public TestingFileDataIndexSpilledRegionManager<T> getLastSpilledRegionManager() {
            return this.lastSpilledRegionManager;
        }

        public FileDataIndexSpilledRegionManager<T> create(int numSubpartitions, Path indexFilePath, BiConsumer<Integer, T> cacheRegionConsumer) {
            TestingFileDataIndexSpilledRegionManager<T> testingFileDataIndexSpilledRegionManager = new TestingFileDataIndexSpilledRegionManager<T>(numSubpartitions, cacheRegionConsumer);
            this.lastSpilledRegionManager = testingFileDataIndexSpilledRegionManager;
            return testingFileDataIndexSpilledRegionManager;
        }
    }
}

