/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.lang.reflect.Field;
import java.net.InetAddress;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.TaskEventPublisher;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.netty.NettyConnectionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.shaded.netty4.io.netty.bootstrap.Bootstrap;
import org.apache.flink.shaded.netty4.io.netty.bootstrap.ServerBootstrap;
import org.apache.flink.shaded.netty4.io.netty.channel.EventLoopGroup;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class NettyConnectionManagerTest {
    NettyConnectionManagerTest() {
    }

    @Test
    void testMatchingNumberOfArenasAndThreadsAsDefault() throws Exception {
        int numberOfSlots = 2;
        NettyConfig config = new NettyConfig(InetAddress.getLocalHost(), 0, 1024, numberOfSlots, new Configuration());
        NettyConnectionManager connectionManager = this.createNettyConnectionManager(config);
        connectionManager.start();
        ((ObjectAssert)Assertions.assertThat((Object)connectionManager).withFailMessage("connectionManager is null due to fail to get a free port", new Object[0])).isNotNull();
        Assertions.assertThat((int)connectionManager.getBufferPool().getNumberOfArenas()).isEqualTo(numberOfSlots);
        Bootstrap boostrap = connectionManager.getClient().getBootstrap();
        EventLoopGroup group = boostrap.config().group();
        Field f = group.getClass().getSuperclass().getSuperclass().getDeclaredField("children");
        f.setAccessible(true);
        Object[] eventExecutors = (Object[])f.get(group);
        Assertions.assertThat((Object[])eventExecutors).hasSize(numberOfSlots);
        ServerBootstrap bootstrap = connectionManager.getServer().getBootstrap();
        group = bootstrap.config().group();
        f = group.getClass().getSuperclass().getSuperclass().getDeclaredField("children");
        f.setAccessible(true);
        eventExecutors = (Object[])f.get(group);
        Assertions.assertThat((Object[])eventExecutors).hasSize(numberOfSlots);
        bootstrap = connectionManager.getServer().getBootstrap();
        group = bootstrap.childGroup();
        f = group.getClass().getSuperclass().getSuperclass().getDeclaredField("children");
        f.setAccessible(true);
        eventExecutors = (Object[])f.get(group);
        Assertions.assertThat((Object[])eventExecutors).hasSize(numberOfSlots);
    }

    private NettyConnectionManager createNettyConnectionManager(NettyConfig config) {
        return new NettyConnectionManager((ResultPartitionProvider)new ResultPartitionManager(), (TaskEventPublisher)new TaskEventDispatcher(), config, true);
    }
}

