/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk;

import java.io.EOFException;
import java.util.ArrayList;
import org.apache.flink.runtime.io.disk.FileChannelOutputView;
import org.apache.flink.runtime.io.disk.SeekableFileChannelInputView;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SeekableFileChannelInputViewTest {
    SeekableFileChannelInputViewTest() {
    }

    @Test
    void testSeek() throws Exception {
        int PAGE_SIZE = 16384;
        int NUM_RECORDS = 120000;
        try (IOManagerAsync ioManager = new IOManagerAsync();){
            int i;
            MemoryManager memMan = MemoryManagerBuilder.newBuilder().setMemorySize(65536L).setPageSize(16384).build();
            ArrayList memory = new ArrayList();
            memMan.allocatePages((Object)new DummyInvokable(), memory, 4);
            FileIOChannel.ID channel = ioManager.createChannel();
            BlockChannelWriter writer = ioManager.createBlockChannelWriter(channel);
            FileChannelOutputView out = new FileChannelOutputView(writer, memMan, memory, memMan.getPageSize());
            for (int i2 = 0; i2 < 120000; i2 += 4) {
                out.writeInt(i2);
            }
            out.close();
            Assertions.assertThat((boolean)memMan.verifyEmpty()).isTrue();
            memMan.allocatePages((Object)new DummyInvokable(), memory, 4);
            SeekableFileChannelInputView in = new SeekableFileChannelInputView((IOManager)ioManager, channel, memMan, memory, out.getBytesInLatestSegment());
            for (i = 0; i < 120000; i += 4) {
                Assertions.assertThat((int)in.readInt()).isEqualTo(i);
            }
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((SeekableFileChannelInputView)in).readInt()).withFailMessage("should throw EOF exception", new Object[0])).isInstanceOf(EOFException.class);
            in.seek((long)i);
            for (i = 36864; i < 120000; i += 4) {
                Assertions.assertThat((int)in.readInt()).isEqualTo(i);
            }
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((SeekableFileChannelInputView)in).readInt()).withFailMessage("should throw EOF exception", new Object[0])).isInstanceOf(EOFException.class);
            in.seek((long)i);
            for (i = 119996; i < 120000; i += 4) {
                Assertions.assertThat((int)in.readInt()).isEqualTo(i);
            }
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((SeekableFileChannelInputView)in).readInt()).withFailMessage("should throw EOF exception", new Object[0])).isInstanceOf(EOFException.class);
            in.seek((long)i);
            for (i = 0; i < 120000; i += 4) {
                Assertions.assertThat((int)in.readInt()).isEqualTo(i);
            }
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((SeekableFileChannelInputView)in).readInt()).withFailMessage("should throw EOF exception", new Object[0])).isInstanceOf(EOFException.class);
            in.seek((long)i);
            for (i = 16384; i < 120000; i += 4) {
                Assertions.assertThat((int)in.readInt()).isEqualTo(i);
            }
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((SeekableFileChannelInputView)in).readInt()).withFailMessage("should throw EOF exception", new Object[0])).isInstanceOf(EOFException.class);
            in.seek((long)i);
            for (i = 49152; i < 120000; i += 4) {
                Assertions.assertThat((int)in.readInt()).isEqualTo(i);
            }
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((SeekableFileChannelInputView)in).readInt()).withFailMessage("should throw EOF exception", new Object[0])).isInstanceOf(EOFException.class);
            i = 120000;
            in.seek((long)i);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((SeekableFileChannelInputView)in).readInt()).withFailMessage("should throw EOF exception", new Object[0])).isInstanceOf(EOFException.class);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> in.seek(-10L)).withFailMessage("should throw an exception", new Object[0])).isInstanceOf(IllegalArgumentException.class);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> in.seek(120001L)).withFailMessage("should throw an exception", new Object[0])).isInstanceOf(IllegalArgumentException.class);
        }
    }
}

