/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.partitionrelease;

import java.util.Collections;
import org.apache.flink.runtime.executiongraph.failover.partitionrelease.ConsumerRegionGroupExecutionView;
import org.apache.flink.runtime.executiongraph.failover.partitionrelease.ConsumerRegionGroupExecutionViewMaintainer;
import org.apache.flink.runtime.scheduler.strategy.SchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingPipelinedRegion;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ConsumerRegionGroupExecutionViewMaintainerTest {
    private TestingSchedulingPipelinedRegion producerRegion;
    private TestingSchedulingPipelinedRegion consumerRegion;
    private ConsumerRegionGroupExecutionView consumerRegionGroupExecutionView;
    private ConsumerRegionGroupExecutionViewMaintainer consumerRegionGroupExecutionViewMaintainer;

    ConsumerRegionGroupExecutionViewMaintainerTest() {
    }

    @BeforeEach
    void setup() {
        this.createProducerAndConsumer();
        this.createConsumerRegionGroupExecutionViewMaintainer();
    }

    @Test
    void testRegionFinished() throws Exception {
        this.consumerRegionGroupExecutionViewMaintainer.regionFinished((SchedulingPipelinedRegion)this.consumerRegion);
        Assertions.assertThat((boolean)this.consumerRegionGroupExecutionView.isFinished()).isTrue();
    }

    @Test
    void testRegionUnfinished() throws Exception {
        this.consumerRegionGroupExecutionViewMaintainer.regionFinished((SchedulingPipelinedRegion)this.consumerRegion);
        this.consumerRegionGroupExecutionViewMaintainer.regionUnfinished((SchedulingPipelinedRegion)this.consumerRegion);
        Assertions.assertThat((boolean)this.consumerRegionGroupExecutionView.isFinished()).isFalse();
    }

    @Test
    void testRegionFinishedMultipleTimes() throws Exception {
        this.consumerRegionGroupExecutionViewMaintainer.regionFinished((SchedulingPipelinedRegion)this.consumerRegion);
        this.consumerRegionGroupExecutionViewMaintainer.regionFinished((SchedulingPipelinedRegion)this.consumerRegion);
        Assertions.assertThat((boolean)this.consumerRegionGroupExecutionView.isFinished()).isTrue();
    }

    @Test
    void testRegionUnfinishedMultipleTimes() throws Exception {
        this.consumerRegionGroupExecutionViewMaintainer.regionUnfinished((SchedulingPipelinedRegion)this.consumerRegion);
        this.consumerRegionGroupExecutionViewMaintainer.regionUnfinished((SchedulingPipelinedRegion)this.consumerRegion);
        Assertions.assertThat((boolean)this.consumerRegionGroupExecutionView.isFinished()).isFalse();
        this.consumerRegionGroupExecutionViewMaintainer.regionFinished((SchedulingPipelinedRegion)this.consumerRegion);
        Assertions.assertThat((boolean)this.consumerRegionGroupExecutionView.isFinished()).isTrue();
    }

    @Test
    void testFinishWrongRegion() {
        this.consumerRegionGroupExecutionViewMaintainer.regionFinished((SchedulingPipelinedRegion)this.producerRegion);
        Assertions.assertThat((boolean)this.consumerRegionGroupExecutionView.isFinished()).isFalse();
    }

    @Test
    void testUnfinishedWrongRegion() {
        this.consumerRegionGroupExecutionViewMaintainer.regionUnfinished((SchedulingPipelinedRegion)this.producerRegion);
        Assertions.assertThat((boolean)this.consumerRegionGroupExecutionView.isFinished()).isFalse();
    }

    private void createProducerAndConsumer() {
        TestingSchedulingExecutionVertex producer = TestingSchedulingExecutionVertex.newBuilder().build();
        TestingSchedulingExecutionVertex consumer = TestingSchedulingExecutionVertex.newBuilder().build();
        this.producerRegion = new TestingSchedulingPipelinedRegion(Collections.singleton(producer));
        this.consumerRegion = new TestingSchedulingPipelinedRegion(Collections.singleton(consumer));
    }

    private void createConsumerRegionGroupExecutionViewMaintainer() {
        this.consumerRegionGroupExecutionView = new ConsumerRegionGroupExecutionView();
        this.consumerRegionGroupExecutionView.add((SchedulingPipelinedRegion)this.consumerRegion);
        this.consumerRegionGroupExecutionViewMaintainer = new ConsumerRegionGroupExecutionViewMaintainer();
        this.consumerRegionGroupExecutionViewMaintainer.notifyNewRegionGroupExecutionViews(Collections.singletonList(this.consumerRegionGroupExecutionView));
    }
}

