/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint.component;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.entrypoint.component.AbstractUserClassPathJobGraphRetriever;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.FileUtilsTest;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.FunctionUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class AbstractUserClassPathJobGraphRetrieverTest
extends TestLogger {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testGetUserClassPath() throws IOException {
        File testJobDir = this.temporaryFolder.newFolder("_test_job");
        Collection testFiles = FileUtilsTest.prepareTestFiles((Path)testJobDir.toPath());
        Path currentWorkingDirectory = FileUtils.getCurrentWorkingDirectory();
        TestJobGraphRetriever testJobGraphRetriever = new TestJobGraphRetriever(testJobDir);
        Assert.assertThat((Object)testJobGraphRetriever.getUserClassPaths(), (Matcher)Matchers.containsInAnyOrder((Object[])testFiles.stream().map(file -> FileUtils.relativizePath((Path)currentWorkingDirectory, (Path)file)).map(FunctionUtils.uncheckedFunction(FileUtils::toURL)).toArray()));
    }

    @Test
    public void testGetUserClassPathReturnEmptyListIfJobDirIsNull() throws IOException {
        TestJobGraphRetriever testJobGraphRetriever = new TestJobGraphRetriever(null);
        Assert.assertTrue((boolean)testJobGraphRetriever.getUserClassPaths().isEmpty());
    }

    private static class TestJobGraphRetriever
    extends AbstractUserClassPathJobGraphRetriever {
        TestJobGraphRetriever(File jobDir) throws IOException {
            super(jobDir);
        }

        public JobGraph retrieveJobGraph(Configuration configuration) {
            throw new UnsupportedOperationException("This method should not be called.");
        }
    }
}

