/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.ExceptionUtils;

public class MockChannelStateWriter
implements ChannelStateWriter {
    private volatile ChannelStateWriter.ChannelStateWriteResult channelStateWriteResult = ChannelStateWriter.ChannelStateWriteResult.EMPTY;
    private volatile long startedCheckpointId = -1L;
    private final boolean autoComplete;

    public MockChannelStateWriter() {
        this(true);
    }

    public MockChannelStateWriter(boolean autoComplete) {
        this.autoComplete = autoComplete;
    }

    public void start(long checkpointId, CheckpointOptions checkpointOptions) {
        if (checkpointId == this.startedCheckpointId) {
            throw new IllegalStateException("Already started " + checkpointId);
        }
        if (checkpointId < this.startedCheckpointId) {
            throw new IllegalArgumentException("Expected a larger checkpoint id than " + this.startedCheckpointId + " but got " + checkpointId);
        }
        this.startedCheckpointId = checkpointId;
        this.channelStateWriteResult = new ChannelStateWriter.ChannelStateWriteResult();
    }

    public void addInputData(long checkpointId, InputChannelInfo info, int startSeqNum, CloseableIterator<Buffer> iterator) {
        this.checkCheckpointId(checkpointId);
        try {
            iterator.close();
        }
        catch (Exception e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public void addOutputData(long checkpointId, ResultSubpartitionInfo info, int startSeqNum, Buffer ... data) {
        this.checkCheckpointId(checkpointId);
        for (Buffer buffer : data) {
            buffer.recycleBuffer();
        }
    }

    public void addOutputDataFuture(long checkpointId, ResultSubpartitionInfo info, int startSeqNum, CompletableFuture<List<Buffer>> data) throws IllegalArgumentException {
        this.checkCheckpointId(checkpointId);
        try {
            for (Buffer buffer : data.get()) {
                buffer.recycleBuffer();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void finishInput(long checkpointId) {
        this.checkCheckpointId(checkpointId);
        if (this.autoComplete) {
            this.completeInput();
        }
    }

    public void completeInput() {
        this.channelStateWriteResult.getInputChannelStateHandles().complete(null);
    }

    public void finishOutput(long checkpointId) {
        this.checkCheckpointId(checkpointId);
        if (this.autoComplete) {
            this.completeOutput();
        }
    }

    public void completeOutput() {
        this.channelStateWriteResult.getResultSubpartitionStateHandles().complete(null);
    }

    protected void checkCheckpointId(long checkpointId) {
        if (checkpointId != this.startedCheckpointId) {
            throw new IllegalStateException("Need to have recently called #start with " + checkpointId + " but currently started checkpoint id is " + this.startedCheckpointId);
        }
    }

    public ChannelStateWriter.ChannelStateWriteResult getAndRemoveWriteResult(long checkpointId) {
        return this.channelStateWriteResult;
    }

    public void abort(long checkpointId, Throwable cause, boolean cleanup) {
        this.checkCheckpointId(checkpointId);
        this.channelStateWriteResult.getInputChannelStateHandles().cancel(false);
        this.channelStateWriteResult.getResultSubpartitionStateHandles().cancel(false);
    }

    public void close() {
        this.channelStateWriteResult.getInputChannelStateHandles().cancel(false);
        this.channelStateWriteResult.getResultSubpartitionStateHandles().cancel(false);
    }
}

