/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.blob.BlobCacheSizeTracker;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.PermanentBlobCache;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.TestingFailingBlobServer;
import org.apache.flink.runtime.blob.TransientBlobCache;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.blob.VoidBlobStore;

class TestingBlobUtils {
    private TestingBlobUtils() {
        throw new UnsupportedOperationException(String.format("Cannot instantiate %s.", TestingBlobUtils.class.getSimpleName()));
    }

    @Nonnull
    static TransientBlobKey writeTransientBlob(Path storageDirectory, JobID jobId, byte[] fileContent) throws IOException {
        return (TransientBlobKey)TestingBlobUtils.writeBlob(storageDirectory, jobId, fileContent, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Nonnull
    static PermanentBlobKey writePermanentBlob(Path storageDirectory, JobID jobId, byte[] fileContent) throws IOException {
        return (PermanentBlobKey)TestingBlobUtils.writeBlob(storageDirectory, jobId, fileContent, BlobKey.BlobType.PERMANENT_BLOB);
    }

    @Nonnull
    static BlobKey writeBlob(Path storageDirectory, JobID jobId, byte[] fileContent, BlobKey.BlobType blobType) throws IOException {
        BlobKey blobKey = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])BlobUtils.createMessageDigest().digest(fileContent));
        File storageLocation = new File(BlobUtils.getStorageLocationPath((String)storageDirectory.toString(), (JobID)jobId, (BlobKey)blobKey));
        FileUtils.createParentDirectories((File)storageLocation);
        FileUtils.writeByteArrayToFile((File)storageLocation, (byte[])fileContent);
        return blobKey;
    }

    @Nonnull
    static BlobServer createServer(Path tempDir) throws IOException {
        return TestingBlobUtils.createServer(tempDir, new Configuration(), (BlobStore)new VoidBlobStore());
    }

    @Nonnull
    static BlobServer createServer(Path tempDir, Configuration config) throws IOException {
        return TestingBlobUtils.createServer(tempDir, config, (BlobStore)new VoidBlobStore());
    }

    @Nonnull
    static BlobServer createServer(Path tempDir, Configuration config, BlobStore serverStore) throws IOException {
        return new BlobServer(config, TestingBlobUtils.getServerDir(tempDir), serverStore);
    }

    @Nonnull
    static PermanentBlobCache createPermanentCache(Path tempDir, BlobServer server) throws IOException {
        return TestingBlobUtils.createPermanentCache(tempDir, new Configuration(), TestingBlobUtils.getServerAddress(server));
    }

    @Nonnull
    static PermanentBlobCache createPermanentCache(Path tempDir, Configuration config, BlobServer server) throws IOException {
        return TestingBlobUtils.createPermanentCache(tempDir, config, TestingBlobUtils.getServerAddress(server));
    }

    @Nonnull
    static PermanentBlobCache createPermanentCache(Path tempDir, Configuration config, BlobServer server, BlobCacheSizeTracker tracker) throws IOException {
        return TestingBlobUtils.createPermanentCache(tempDir, config, TestingBlobUtils.getServerAddress(server), tracker);
    }

    @Nonnull
    static PermanentBlobCache createPermanentCache(Path tempDir, Configuration config, InetSocketAddress serverAddress) throws IOException {
        return TestingBlobUtils.createPermanentCache(tempDir, config, serverAddress, null);
    }

    @Nonnull
    static TransientBlobCache createTransientCache(Path tempDir, BlobServer server) throws IOException {
        return new TransientBlobCache(new Configuration(), TestingBlobUtils.getCacheDir(tempDir), TestingBlobUtils.getServerAddress(server));
    }

    @Nonnull
    static PermanentBlobCache createPermanentCache(Path tempDir, Configuration config, InetSocketAddress serverAddress, BlobCacheSizeTracker tracker) throws IOException {
        if (tracker == null) {
            return new PermanentBlobCache(config, TestingBlobUtils.getCacheDir(tempDir), (BlobView)new VoidBlobStore(), serverAddress);
        }
        return new PermanentBlobCache(config, TestingBlobUtils.getCacheDir(tempDir), (BlobView)new VoidBlobStore(), serverAddress, tracker);
    }

    @Nonnull
    static Tuple2<BlobServer, BlobCacheService> createServerAndCache(Path tempDir) throws IOException {
        return TestingBlobUtils.createServerAndCache(tempDir, new Configuration(), (BlobStore)new VoidBlobStore(), (BlobStore)new VoidBlobStore());
    }

    @Nonnull
    static Tuple2<BlobServer, BlobCacheService> createServerAndCache(Path tempDir, Configuration config) throws IOException {
        return TestingBlobUtils.createServerAndCache(tempDir, config, (BlobStore)new VoidBlobStore(), (BlobStore)new VoidBlobStore());
    }

    @Nonnull
    static Tuple2<BlobServer, BlobCacheService> createServerAndCache(Path tempDir, BlobStore serverStore, BlobStore cacheStore) throws IOException {
        return TestingBlobUtils.createServerAndCache(tempDir, new Configuration(), serverStore, cacheStore);
    }

    @Nonnull
    static Tuple2<BlobServer, BlobCacheService> createServerAndCache(Path tempDir, Configuration config, BlobStore serverStore, BlobStore cacheStore) throws IOException {
        return TestingBlobUtils.createServerAndCache(tempDir, config, config, serverStore, cacheStore);
    }

    @Nonnull
    static Tuple2<BlobServer, BlobCacheService> createServerAndCache(Path tempDir, Configuration serverConfig, Configuration cacheConfig, BlobStore serverStore, BlobStore cacheStore) throws IOException {
        BlobServer server = TestingBlobUtils.createServer(tempDir, serverConfig, serverStore);
        BlobCacheService cache = new BlobCacheService(cacheConfig, TestingBlobUtils.getCacheDir(tempDir), (BlobView)cacheStore, new InetSocketAddress("localhost", server.getPort()));
        return Tuple2.of((Object)server, (Object)cache);
    }

    @Nonnull
    static Tuple2<BlobServer, BlobCacheService> createFailingServerAndCache(Path tempDir, BlobStore serverStore, int numAccept, int numFailures) throws IOException {
        Configuration config = new Configuration();
        TestingFailingBlobServer server = new TestingFailingBlobServer(config, TestingBlobUtils.getServerDir(tempDir), serverStore, numAccept, numFailures);
        BlobCacheService cache = new BlobCacheService(config, TestingBlobUtils.getCacheDir(tempDir), (BlobView)new VoidBlobStore(), new InetSocketAddress("localhost", server.getPort()));
        return Tuple2.of((Object)((Object)server), (Object)cache);
    }

    private static InetSocketAddress getServerAddress(BlobServer server) {
        return new InetSocketAddress("localhost", server.getPort());
    }

    private static File getServerDir(Path tempDir) {
        return tempDir.resolve("server").toFile();
    }

    private static File getCacheDir(Path tempDir) {
        return tempDir.resolve("cache").toFile();
    }
}

