/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.accumulators;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.IntCounter;
import org.apache.flink.api.common.accumulators.SimpleAccumulator;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.OptionalFailure;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StringifiedAccumulatorResultTest {
    StringifiedAccumulatorResultTest() {
    }

    @Test
    void testSerialization() throws IOException {
        String name = "a";
        String type = "b";
        String value = "c";
        StringifiedAccumulatorResult original = new StringifiedAccumulatorResult("a", "b", "c");
        Assertions.assertThat((String)original.getName()).isEqualTo("a");
        Assertions.assertThat((String)original.getType()).isEqualTo("b");
        Assertions.assertThat((String)original.getValue()).isEqualTo("c");
        StringifiedAccumulatorResult copy = (StringifiedAccumulatorResult)CommonTestUtils.createCopySerializable((Serializable)original);
        Assertions.assertThat((String)copy.getName()).isEqualTo("a");
        Assertions.assertThat((String)copy.getType()).isEqualTo("b");
        Assertions.assertThat((String)copy.getValue()).isEqualTo("c");
    }

    @Test
    void stringifyingResultsShouldIncorporateAccumulatorLocalValueDirectly() {
        String name = "a";
        int targetValue = 314159;
        IntCounter acc = new IntCounter();
        acc.add(314159);
        HashMap<String, OptionalFailure> accumulatorMap = new HashMap<String, OptionalFailure>();
        accumulatorMap.put("a", OptionalFailure.of((Object)acc));
        Object[] results = StringifiedAccumulatorResult.stringifyAccumulatorResults(accumulatorMap);
        Assertions.assertThat((Object[])results).hasSize(1);
        Object firstResult = results[0];
        Assertions.assertThat((String)firstResult.getName()).isEqualTo("a");
        Assertions.assertThat((String)firstResult.getType()).isEqualTo("IntCounter");
        Assertions.assertThat((String)firstResult.getValue()).isEqualTo(Integer.toString(314159));
    }

    @Test
    void stringifyingResultsShouldReportNullLocalValueAsNonnullValueString() {
        String name = "a";
        NullBearingAccumulator acc = new NullBearingAccumulator();
        HashMap<String, OptionalFailure> accumulatorMap = new HashMap<String, OptionalFailure>();
        accumulatorMap.put("a", OptionalFailure.of((Object)acc));
        Object[] results = StringifiedAccumulatorResult.stringifyAccumulatorResults(accumulatorMap);
        Assertions.assertThat((Object[])results).hasSize(1);
        Object firstResult = results[0];
        Assertions.assertThat((String)firstResult.getName()).isEqualTo("a");
        Assertions.assertThat((String)firstResult.getType()).isEqualTo("NullBearingAccumulator");
        Assertions.assertThat((String)firstResult.getValue()).isEqualTo("null");
    }

    @Test
    void stringifyingResultsShouldReportNullAccumulatorWithNonnullValueAndTypeString() {
        String name = "a";
        HashMap<String, Object> accumulatorMap = new HashMap<String, Object>();
        accumulatorMap.put("a", null);
        Object[] results = StringifiedAccumulatorResult.stringifyAccumulatorResults(accumulatorMap);
        Assertions.assertThat((Object[])results).hasSize(1);
        Object firstResult = results[0];
        Assertions.assertThat((String)firstResult.getName()).isEqualTo("a");
        Assertions.assertThat((String)firstResult.getType()).isEqualTo("null");
        Assertions.assertThat((String)firstResult.getValue()).isEqualTo("null");
    }

    @Test
    void stringifyingFailureResults() {
        String name = "a";
        HashMap<String, OptionalFailure> accumulatorMap = new HashMap<String, OptionalFailure>();
        accumulatorMap.put("a", OptionalFailure.ofFailure((Throwable)new FlinkRuntimeException("Test")));
        Object[] results = StringifiedAccumulatorResult.stringifyAccumulatorResults(accumulatorMap);
        Assertions.assertThat((Object[])results).hasSize(1);
        Object firstResult = results[0];
        Assertions.assertThat((String)firstResult.getName()).isEqualTo("a");
        Assertions.assertThat((String)firstResult.getType()).isEqualTo("null");
        Assertions.assertThat((String)firstResult.getValue()).startsWith((CharSequence)"org.apache.flink.util.FlinkRuntimeException: Test");
    }

    private static class NullBearingAccumulator
    implements SimpleAccumulator<Serializable> {
        private NullBearingAccumulator() {
        }

        public void add(Serializable value) {
            throw new UnsupportedOperationException();
        }

        public Serializable getLocalValue() {
            return null;
        }

        public void resetLocal() {
            throw new UnsupportedOperationException();
        }

        public void merge(Accumulator<Serializable, Serializable> other) {
            throw new UnsupportedOperationException();
        }

        public Accumulator<Serializable, Serializable> clone() {
            return new NullBearingAccumulator();
        }
    }
}

