/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.time.Duration;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.exceptions.SlotAllocationException;
import org.apache.flink.runtime.taskexecutor.slot.SlotActions;
import org.apache.flink.runtime.taskexecutor.slot.SlotNotActiveException;
import org.apache.flink.runtime.taskexecutor.slot.SlotNotFoundException;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlot;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotPayload;
import org.apache.flink.runtime.taskexecutor.slot.TimeoutListener;
import org.apache.flink.util.AutoCloseableAsync;

public interface TaskSlotTable<T extends TaskSlotPayload>
extends TimeoutListener<AllocationID>,
AutoCloseableAsync {
    public void start(SlotActions var1, ComponentMainThreadExecutor var2);

    public Set<AllocationID> getAllocationIdsPerJob(JobID var1);

    public Set<AllocationID> getActiveTaskSlotAllocationIds();

    public Set<AllocationID> getActiveTaskSlotAllocationIdsPerJob(JobID var1);

    public SlotReport createSlotReport(ResourceID var1);

    @VisibleForTesting
    public void allocateSlot(int var1, JobID var2, AllocationID var3, Duration var4) throws SlotAllocationException;

    public void allocateSlot(int var1, JobID var2, AllocationID var3, ResourceProfile var4, Duration var5) throws SlotAllocationException;

    public boolean markSlotActive(AllocationID var1) throws SlotNotFoundException;

    public boolean markSlotInactive(AllocationID var1, Duration var2) throws SlotNotFoundException;

    default public int freeSlot(AllocationID allocationId) throws SlotNotFoundException {
        return this.freeSlot(allocationId, new Exception("The task slot of this task is being freed."));
    }

    public int freeSlot(AllocationID var1, Throwable var2) throws SlotNotFoundException;

    public boolean isValidTimeout(AllocationID var1, UUID var2);

    public boolean isAllocated(int var1, JobID var2, AllocationID var3);

    public boolean tryMarkSlotActive(JobID var1, AllocationID var2);

    public boolean isSlotFree(int var1);

    public boolean hasAllocatedSlots(JobID var1);

    public Iterator<TaskSlot<T>> getAllocatedSlots(JobID var1);

    @Nullable
    public JobID getOwningJob(AllocationID var1);

    public boolean addTask(T var1) throws SlotNotFoundException, SlotNotActiveException;

    public T removeTask(ExecutionAttemptID var1);

    public T getTask(ExecutionAttemptID var1);

    public Iterator<T> getTasks(JobID var1);

    public AllocationID getCurrentAllocation(int var1);

    public MemoryManager getTaskMemoryManager(AllocationID var1) throws SlotNotFoundException;
}

