/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.io.IOException;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.apache.flink.runtime.state.metrics.AbstractMetricsTrackState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.SizeTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.StateMetricBase;
import org.apache.flink.util.function.ThrowingRunnable;

class MetricsTrackingValueState<K, N, T>
extends AbstractMetricsTrackState<K, N, T, InternalValueState<K, N, T>, ValueStateMetrics>
implements InternalValueState<K, N, T> {
    public MetricsTrackingValueState(String stateName, InternalValueState<K, N, T> original, KeyedStateBackend<K> keyedStateBackend, LatencyTrackingStateConfig latencyTrackingStateConfig, SizeTrackingStateConfig sizeTrackingStateConfig) {
        super(original, keyedStateBackend, latencyTrackingStateConfig.isEnabled() ? new ValueStateMetrics(stateName, latencyTrackingStateConfig.getMetricGroup(), latencyTrackingStateConfig.getSampleInterval(), latencyTrackingStateConfig.getHistorySize(), latencyTrackingStateConfig.isStateNameAsVariable()) : null, sizeTrackingStateConfig.isEnabled() ? new ValueStateMetrics(stateName, sizeTrackingStateConfig.getMetricGroup(), sizeTrackingStateConfig.getSampleInterval(), sizeTrackingStateConfig.getHistorySize(), sizeTrackingStateConfig.isStateNameAsVariable()) : null);
    }

    public T value() throws IOException {
        Object result = this.latencyTrackingStateMetric != null && ((ValueStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnGet() ? this.trackLatencyWithIOException(() -> ((InternalValueState)this.original).value(), "valueStateGetLatency") : ((InternalValueState)this.original).value();
        if (this.sizeTrackingStateMetric != null && ((ValueStateMetrics)this.sizeTrackingStateMetric).trackMetricsOnGet()) {
            ((ValueStateMetrics)this.sizeTrackingStateMetric).updateMetrics("valueStateGetKeySize", super.sizeOfKey());
            ((ValueStateMetrics)this.sizeTrackingStateMetric).updateMetrics("valueStateGetValueSize", super.sizeOfValue(result));
        }
        return (T)result;
    }

    public void update(T value) throws IOException {
        if (this.sizeTrackingStateMetric != null && ((ValueStateMetrics)this.sizeTrackingStateMetric).trackMetricsOnUpdate()) {
            ((ValueStateMetrics)this.sizeTrackingStateMetric).updateMetrics("valueStateUpdateKeySize", super.sizeOfKey());
            ((ValueStateMetrics)this.sizeTrackingStateMetric).updateMetrics("valueStateUpdateValueSize", super.sizeOfValue(value));
        }
        if (this.latencyTrackingStateMetric != null && ((ValueStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnUpdate()) {
            this.trackLatencyWithIOException((ThrowingRunnable<IOException>)((ThrowingRunnable)() -> ((InternalValueState)this.original).update(value)), "valueStateUpdateLatency");
        } else {
            ((InternalValueState)this.original).update(value);
        }
    }

    static class ValueStateMetrics
    extends StateMetricBase {
        private static final String VALUE_STATE_GET_LATENCY = "valueStateGetLatency";
        private static final String VALUE_STATE_UPDATE_LATENCY = "valueStateUpdateLatency";
        private static final String VALUE_STATE_UPDATE_KEY_SIZE = "valueStateUpdateKeySize";
        private static final String VALUE_STATE_UPDATE_VALUE_SIZE = "valueStateUpdateValueSize";
        private static final String VALUE_STATE_GET_KEY_SIZE = "valueStateGetKeySize";
        private static final String VALUE_STATE_GET_VALUE_SIZE = "valueStateGetValueSize";
        private int getCount = 0;
        private int updateCount = 0;

        private ValueStateMetrics(String stateName, MetricGroup metricGroup, int sampleInterval, int historySize, boolean stateNameAsVariable) {
            super(stateName, metricGroup, sampleInterval, historySize, stateNameAsVariable);
        }

        int getGetCount() {
            return this.getCount;
        }

        int getUpdateCount() {
            return this.updateCount;
        }

        private boolean trackMetricsOnGet() {
            this.getCount = this.loopUpdateCounter(this.getCount);
            return this.getCount == 1;
        }

        private boolean trackMetricsOnUpdate() {
            this.updateCount = this.loopUpdateCounter(this.updateCount);
            return this.updateCount == 1;
        }
    }
}

