/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.aggregators.AggregatorWithName;
import org.apache.flink.api.common.aggregators.ConvergenceCriterion;
import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.chaining.ChainedDriver;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.util.CorruptConfigurationException;
import org.apache.flink.runtime.operators.util.LocalStrategy;
import org.apache.flink.types.Value;
import org.apache.flink.util.InstantiationUtil;

public class TaskConfig
implements Serializable {
    private static final long serialVersionUID = -2498884325640066272L;
    private static final String TASK_NAME = "taskname";
    private static final String STUB_OBJECT = "udf";
    private static final String STUB_PARAM_PREFIX = "udf.param.";
    private static final String DRIVER_CLASS = "driver.class";
    private static final String DRIVER_STRATEGY = "driver.strategy";
    private static final String DRIVER_COMPARATOR_FACTORY_PREFIX = "driver.comp.";
    private static final String DRIVER_COMPARATOR_PARAMETERS_PREFIX = "driver.comp.params.";
    private static final String DRIVER_PAIR_COMPARATOR_FACTORY = "driver.paircomp";
    private static final String NUM_INPUTS = "in.num";
    private static final String NUM_BROADCAST_INPUTS = "in.bc.num";
    private static final String INPUT_GROUP_SIZE_PREFIX = "in.groupsize.";
    private static final String BROADCAST_INPUT_GROUP_SIZE_PREFIX = "in.bc.groupsize.";
    private static final String INPUT_TYPE_SERIALIZER_FACTORY_PREFIX = "in.serializer.";
    private static final String BROADCAST_INPUT_TYPE_SERIALIZER_FACTORY_PREFIX = "in.bc.serializer.";
    private static final String INPUT_TYPE_SERIALIZER_PARAMETERS_PREFIX = "in.serializer.param.";
    private static final String BROADCAST_INPUT_TYPE_SERIALIZER_PARAMETERS_PREFIX = "in.bc.serializer.param.";
    private static final String INPUT_LOCAL_STRATEGY_PREFIX = "in.strategy.";
    private static final String INPUT_STRATEGY_COMPARATOR_FACTORY_PREFIX = "in.comparator.";
    private static final String INPUT_STRATEGY_COMPARATOR_PARAMETERS_PREFIX = "in.comparator.param.";
    private static final String INPUT_DAM_PREFIX = "in.dam.";
    private static final String INPUT_REPLAYABLE_PREFIX = "in.dam.replay.";
    private static final String INPUT_DAM_MEMORY_PREFIX = "in.dam.mem.";
    private static final String BROADCAST_INPUT_NAME_PREFIX = "in.broadcast.name.";
    private static final String OUTPUTS_NUM = "out.num";
    private static final String OUTPUT_TYPE_SERIALIZER_FACTORY = "out.serializer";
    private static final String OUTPUT_TYPE_SERIALIZER_PARAMETERS_PREFIX = "out.serializer.param.";
    private static final String OUTPUT_SHIP_STRATEGY_PREFIX = "out.shipstrategy.";
    private static final String OUTPUT_TYPE_COMPARATOR_FACTORY_PREFIX = "out.comp.";
    private static final String OUTPUT_TYPE_COMPARATOR_PARAMETERS_PREFIX = "out.comp.param.";
    private static final String OUTPUT_DATA_DISTRIBUTION_CLASS = "out.distribution.class";
    private static final String OUTPUT_DATA_DISTRIBUTION_PREFIX = "out.distribution.";
    private static final String OUTPUT_PARTITIONER = "out.partitioner.";
    private static final String CHAINING_NUM_STUBS = "chaining.num";
    private static final String CHAINING_TASKCONFIG_PREFIX = "chaining.taskconfig.";
    private static final String CHAINING_TASK_PREFIX = "chaining.task.";
    private static final String CHAINING_TASKNAME_PREFIX = "chaining.taskname.";
    private static final String MEMORY_DRIVER = "memory.driver";
    private static final String MEMORY_INPUT_PREFIX = "memory.input.";
    private static final String FILEHANDLES_DRIVER = "filehandles.driver";
    private static final String FILEHANDLES_INPUT_PREFIX = "filehandles.input.";
    private static final String SORT_SPILLING_THRESHOLD_DRIVER = "sort-spill-threshold.driver";
    private static final String SORT_SPILLING_THRESHOLD_INPUT_PREFIX = "sort-spill-threshold.input.";
    private static final String USE_LARGE_RECORD_HANDLER = "sort-spill.large-record-handler";
    private static final boolean USE_LARGE_RECORD_HANDLER_DEFAULT = false;
    private static final String NUMBER_OF_ITERATIONS = "iterative.num-iterations";
    private static final String NUMBER_OF_EOS_EVENTS_PREFIX = "iterative.num-eos-events.";
    private static final String NUMBER_OF_EOS_EVENTS_BROADCAST_PREFIX = "iterative.num-eos-events.bc.";
    private static final String ITERATION_HEAD_ID = "iterative.head.id";
    private static final String ITERATION_WORKSET_MARKER = "iterative.is-workset";
    private static final String ITERATION_HEAD_INDEX_OF_PARTIAL_SOLUTION = "iterative.head.ps-input-index";
    private static final String ITERATION_HEAD_INDEX_OF_SOLUTIONSET = "iterative.head.ss-input-index";
    private static final String ITERATION_HEAD_BACKCHANNEL_MEMORY = "iterative.head.backchannel-memory";
    private static final String ITERATION_HEAD_SOLUTION_SET_MEMORY = "iterative.head.solutionset-memory";
    private static final String ITERATION_HEAD_FINAL_OUT_CONFIG_PREFIX = "iterative.head.out.";
    private static final String ITERATION_HEAD_SYNC_OUT_INDEX = "iterative.head.sync-index.";
    private static final String ITERATION_CONVERGENCE_CRITERION = "iterative.terminationCriterion";
    private static final String ITERATION_CONVERGENCE_CRITERION_AGG_NAME = "iterative.terminationCriterion.agg.name";
    private static final String ITERATION_IMPLICIT_CONVERGENCE_CRITERION = "iterative.implicit.terminationCriterion";
    private static final String ITERATION_IMPLICIT_CONVERGENCE_CRITERION_AGG_NAME = "iterative.implicit.terminationCriterion.agg.name";
    private static final String ITERATION_NUM_AGGREGATORS = "iterative.num-aggs";
    private static final String ITERATION_AGGREGATOR_NAME_PREFIX = "iterative.agg.name.";
    private static final String ITERATION_AGGREGATOR_PREFIX = "iterative.agg.data.";
    private static final String ITERATION_SOLUTION_SET_SERIALIZER = "iterative.ss-serializer";
    private static final String ITERATION_SOLUTION_SET_SERIALIZER_PARAMETERS = "iterative.ss-serializer.params";
    private static final String ITERATION_SOLUTION_SET_COMPARATOR = "iterative.ss-comparator";
    private static final String ITERATION_SOLUTION_SET_COMPARATOR_PARAMETERS = "iterative.ss-comparator.params";
    private static final String ITERATION_SOLUTION_SET_UPDATE = "iterative.ss-update";
    private static final String ITERATION_SOLUTION_SET_UPDATE_SKIP_REPROBE = "iterative.ss-update-fast";
    private static final String ITERATION_SOLUTION_SET_UPDATE_WAIT = "iterative.ss-wait";
    private static final String ITERATION_WORKSET_UPDATE = "iterative.ws-update";
    private static final String SOLUTION_SET_OBJECTS = "itertive.ss.obj";
    private static final char SEPARATOR = '.';
    protected final Configuration config;

    public TaskConfig(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setTaskName(String name) {
        if (name != null) {
            this.config.setString(TASK_NAME, name);
        }
    }

    public String getTaskName() {
        return this.config.getString(TASK_NAME, null);
    }

    public boolean hasStubWrapper() {
        return this.config.containsKey(STUB_OBJECT);
    }

    public void setStubWrapper(UserCodeWrapper<?> wrapper) {
        try {
            InstantiationUtil.writeObjectToConfig(wrapper, (Configuration)this.config, (String)STUB_OBJECT);
        }
        catch (IOException e) {
            throw new CorruptConfigurationException("Could not write the user code wrapper " + wrapper.getClass() + " : " + e, e);
        }
    }

    public <T> UserCodeWrapper<T> getStubWrapper(ClassLoader cl) {
        try {
            return (UserCodeWrapper)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)STUB_OBJECT, (ClassLoader)cl);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new CorruptConfigurationException("Could not read the user code wrapper: " + e.getMessage(), e);
        }
    }

    public void setStubParameters(Configuration parameters) {
        this.config.addAll(parameters, STUB_PARAM_PREFIX);
    }

    public Configuration getStubParameters() {
        return new DelegatingConfiguration(this.config, STUB_PARAM_PREFIX);
    }

    public void setStubParameter(String key, String value) {
        this.config.setString(STUB_PARAM_PREFIX + key, value);
    }

    public String getStubParameter(String key, String defaultValue) {
        return this.config.getString(STUB_PARAM_PREFIX + key, defaultValue);
    }

    public void setDriver(Class<? extends Driver> driver) {
        this.config.setString(DRIVER_CLASS, driver.getName());
    }

    public <S extends Function, OT> Class<? extends Driver<S, OT>> getDriver() {
        String className = this.config.getString(DRIVER_CLASS, null);
        if (className == null) {
            throw new CorruptConfigurationException("The pact driver class is missing.");
        }
        try {
            Class<Driver> pdClazz = Driver.class;
            return Class.forName(className).asSubclass(pdClazz);
        }
        catch (ClassNotFoundException cnfex) {
            throw new CorruptConfigurationException("The given driver class cannot be found.");
        }
        catch (ClassCastException ccex) {
            throw new CorruptConfigurationException("The given driver class does not implement the pact driver interface.");
        }
    }

    public void setDriverStrategy(DriverStrategy strategy) {
        this.config.set(ConfigurationUtils.getIntConfigOption((String)DRIVER_STRATEGY), (Object)strategy.ordinal());
    }

    public DriverStrategy getDriverStrategy() {
        int ls = (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)DRIVER_STRATEGY), (Object)-1);
        if (ls == -1) {
            return DriverStrategy.NONE;
        }
        if (ls < 0 || ls >= DriverStrategy.values().length) {
            throw new CorruptConfigurationException("Illegal driver strategy in configuration: " + ls);
        }
        return DriverStrategy.values()[ls];
    }

    public void setDriverComparator(TypeComparatorFactory<?> factory, int inputNum) {
        this.setTypeComparatorFactory(factory, DRIVER_COMPARATOR_FACTORY_PREFIX + inputNum, DRIVER_COMPARATOR_PARAMETERS_PREFIX + inputNum + ".");
    }

    public <T> TypeComparatorFactory<T> getDriverComparator(int inputNum, ClassLoader cl) {
        return this.getTypeComparatorFactory(DRIVER_COMPARATOR_FACTORY_PREFIX + inputNum, DRIVER_COMPARATOR_PARAMETERS_PREFIX + inputNum + ".", cl);
    }

    public void setDriverPairComparator(TypePairComparatorFactory<?, ?> factory) {
        Class<?> clazz = factory.getClass();
        InstantiationUtil.checkForInstantiation(clazz);
        this.config.setString(DRIVER_PAIR_COMPARATOR_FACTORY, clazz.getName());
    }

    public <T1, T2> TypePairComparatorFactory<T1, T2> getPairComparatorFactory(ClassLoader cl) {
        String className = this.config.getString(DRIVER_PAIR_COMPARATOR_FACTORY, null);
        if (className == null) {
            return null;
        }
        Class<TypePairComparatorFactory> superClass = TypePairComparatorFactory.class;
        try {
            Class<TypePairComparatorFactory> clazz = Class.forName(className, true, cl).asSubclass(superClass);
            return (TypePairComparatorFactory)InstantiationUtil.instantiate(clazz, superClass);
        }
        catch (ClassNotFoundException cnfex) {
            throw new RuntimeException("The class '" + className + "', noted in the configuration as pair comparator factory, could not be found. It is not part of the user code's class loader resources.");
        }
        catch (ClassCastException ccex) {
            throw new CorruptConfigurationException("The class noted in the configuration as the pair comparator factory is no subclass of TypePairComparatorFactory.");
        }
    }

    public void setInputLocalStrategy(int inputNum, LocalStrategy strategy) {
        this.config.set(ConfigurationUtils.getIntConfigOption((String)(INPUT_LOCAL_STRATEGY_PREFIX + inputNum)), (Object)strategy.ordinal());
    }

    public LocalStrategy getInputLocalStrategy(int inputNum) {
        int ls = (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)(INPUT_LOCAL_STRATEGY_PREFIX + inputNum)), (Object)-1);
        if (ls == -1) {
            return LocalStrategy.NONE;
        }
        if (ls < 0 || ls >= LocalStrategy.values().length) {
            throw new CorruptConfigurationException("Illegal local strategy in configuration: " + ls);
        }
        return LocalStrategy.values()[ls];
    }

    public void setInputSerializer(TypeSerializerFactory<?> factory, int inputNum) {
        this.setTypeSerializerFactory(factory, INPUT_TYPE_SERIALIZER_FACTORY_PREFIX + inputNum, INPUT_TYPE_SERIALIZER_PARAMETERS_PREFIX + inputNum + ".");
    }

    public void setBroadcastInputSerializer(TypeSerializerFactory<?> factory, int inputNum) {
        this.setTypeSerializerFactory(factory, BROADCAST_INPUT_TYPE_SERIALIZER_FACTORY_PREFIX + inputNum, BROADCAST_INPUT_TYPE_SERIALIZER_PARAMETERS_PREFIX + inputNum + ".");
    }

    public <T> TypeSerializerFactory<T> getInputSerializer(int inputNum, ClassLoader cl) {
        return this.getTypeSerializerFactory(INPUT_TYPE_SERIALIZER_FACTORY_PREFIX + inputNum, INPUT_TYPE_SERIALIZER_PARAMETERS_PREFIX + inputNum + ".", cl);
    }

    public <T> TypeSerializerFactory<T> getBroadcastInputSerializer(int inputNum, ClassLoader cl) {
        return this.getTypeSerializerFactory(BROADCAST_INPUT_TYPE_SERIALIZER_FACTORY_PREFIX + inputNum, BROADCAST_INPUT_TYPE_SERIALIZER_PARAMETERS_PREFIX + inputNum + ".", cl);
    }

    public void setInputComparator(TypeComparatorFactory<?> factory, int inputNum) {
        this.setTypeComparatorFactory(factory, INPUT_STRATEGY_COMPARATOR_FACTORY_PREFIX + inputNum, INPUT_STRATEGY_COMPARATOR_PARAMETERS_PREFIX + inputNum + ".");
    }

    public <T> TypeComparatorFactory<T> getInputComparator(int inputNum, ClassLoader cl) {
        return this.getTypeComparatorFactory(INPUT_STRATEGY_COMPARATOR_FACTORY_PREFIX + inputNum, INPUT_STRATEGY_COMPARATOR_PARAMETERS_PREFIX + inputNum + ".", cl);
    }

    public int getNumInputs() {
        return (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)NUM_INPUTS), (Object)0);
    }

    public int getNumBroadcastInputs() {
        return (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)NUM_BROADCAST_INPUTS), (Object)0);
    }

    public int getGroupSize(int groupIndex) {
        return (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)(INPUT_GROUP_SIZE_PREFIX + groupIndex)), (Object)-1);
    }

    public int getBroadcastGroupSize(int groupIndex) {
        return (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)(BROADCAST_INPUT_GROUP_SIZE_PREFIX + groupIndex)), (Object)-1);
    }

    public void addInputToGroup(int groupIndex) {
        String grp = INPUT_GROUP_SIZE_PREFIX + groupIndex;
        this.config.set(ConfigurationUtils.getIntConfigOption((String)grp), (Object)((Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)grp), (Object)0) + 1));
        this.config.set(ConfigurationUtils.getIntConfigOption((String)NUM_INPUTS), (Object)((Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)NUM_INPUTS), (Object)0) + 1));
    }

    public void addBroadcastInputToGroup(int groupIndex) {
        String grp = BROADCAST_INPUT_GROUP_SIZE_PREFIX + groupIndex;
        if (!this.config.containsKey(grp)) {
            this.config.set(ConfigurationUtils.getIntConfigOption((String)NUM_BROADCAST_INPUTS), (Object)((Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)NUM_BROADCAST_INPUTS), (Object)0) + 1));
        }
        this.config.set(ConfigurationUtils.getIntConfigOption((String)grp), (Object)((Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)grp), (Object)0) + 1));
    }

    public void setInputAsynchronouslyMaterialized(int inputNum, boolean temp) {
        this.config.set(ConfigurationUtils.getBooleanConfigOption((String)(INPUT_DAM_PREFIX + inputNum)), (Object)temp);
    }

    public boolean isInputAsynchronouslyMaterialized(int inputNum) {
        return (Boolean)this.config.get(ConfigurationUtils.getBooleanConfigOption((String)(INPUT_DAM_PREFIX + inputNum)), (Object)false);
    }

    public void setInputCached(int inputNum, boolean persistent) {
        this.config.set(ConfigurationUtils.getBooleanConfigOption((String)(INPUT_REPLAYABLE_PREFIX + inputNum)), (Object)persistent);
    }

    public boolean isInputCached(int inputNum) {
        return (Boolean)this.config.get(ConfigurationUtils.getBooleanConfigOption((String)(INPUT_REPLAYABLE_PREFIX + inputNum)), (Object)false);
    }

    public void setRelativeInputMaterializationMemory(int inputNum, double relativeMemory) {
        this.config.set(ConfigurationUtils.getDoubleConfigOption((String)(INPUT_DAM_MEMORY_PREFIX + inputNum)), (Object)relativeMemory);
    }

    public double getRelativeInputMaterializationMemory(int inputNum) {
        return (Double)this.config.get(ConfigurationUtils.getDoubleConfigOption((String)(INPUT_DAM_MEMORY_PREFIX + inputNum)), (Object)0.0);
    }

    public void setBroadcastInputName(String name, int groupIndex) {
        this.config.setString(BROADCAST_INPUT_NAME_PREFIX + groupIndex, name);
    }

    public String getBroadcastInputName(int groupIndex) {
        return this.config.getString(BROADCAST_INPUT_NAME_PREFIX + groupIndex, String.format("broadcastVar%04d", groupIndex));
    }

    public void addOutputShipStrategy(ShipStrategyType strategy) {
        int outputCnt = (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)OUTPUTS_NUM), (Object)0);
        this.config.set(ConfigurationUtils.getIntConfigOption((String)(OUTPUT_SHIP_STRATEGY_PREFIX + outputCnt)), (Object)strategy.ordinal());
        this.config.set(ConfigurationUtils.getIntConfigOption((String)OUTPUTS_NUM), (Object)(outputCnt + 1));
    }

    public int getNumOutputs() {
        return (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)OUTPUTS_NUM), (Object)0);
    }

    public ShipStrategyType getOutputShipStrategy(int outputNum) {
        int outputCnt = (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)OUTPUTS_NUM), (Object)-1);
        if (outputCnt < 1) {
            throw new CorruptConfigurationException("No output ship strategies are specified in the configuration.");
        }
        if (outputNum < 0 || outputNum >= outputCnt) {
            throw new IllegalArgumentException("Invalid index for output shipping strategy.");
        }
        int strategy = (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)(OUTPUT_SHIP_STRATEGY_PREFIX + outputNum)), (Object)-1);
        if (strategy == -1) {
            throw new CorruptConfigurationException("No output shipping strategy in configuration for output " + outputNum);
        }
        if (strategy < 0 || strategy >= ShipStrategyType.values().length) {
            throw new CorruptConfigurationException("Illegal output shipping strategy in configuration for output " + outputNum + ": " + strategy);
        }
        return ShipStrategyType.values()[strategy];
    }

    public void setOutputSerializer(TypeSerializerFactory<?> factory) {
        this.setTypeSerializerFactory(factory, OUTPUT_TYPE_SERIALIZER_FACTORY, OUTPUT_TYPE_SERIALIZER_PARAMETERS_PREFIX);
    }

    public <T> TypeSerializerFactory<T> getOutputSerializer(ClassLoader cl) {
        return this.getTypeSerializerFactory(OUTPUT_TYPE_SERIALIZER_FACTORY, OUTPUT_TYPE_SERIALIZER_PARAMETERS_PREFIX, cl);
    }

    public void setOutputComparator(TypeComparatorFactory<?> factory, int outputNum) {
        this.setTypeComparatorFactory(factory, OUTPUT_TYPE_COMPARATOR_FACTORY_PREFIX + outputNum, OUTPUT_TYPE_COMPARATOR_PARAMETERS_PREFIX + outputNum + ".");
    }

    public <T> TypeComparatorFactory<T> getOutputComparator(int outputNum, ClassLoader cl) {
        return this.getTypeComparatorFactory(OUTPUT_TYPE_COMPARATOR_FACTORY_PREFIX + outputNum, OUTPUT_TYPE_COMPARATOR_PARAMETERS_PREFIX + outputNum + ".", cl);
    }

    public void setOutputDataDistribution(DataDistribution distribution, int outputNum) {
        this.config.setString(OUTPUT_DATA_DISTRIBUTION_CLASS, distribution.getClass().getName());
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper((OutputStream)baos);){
            distribution.write((DataOutputView)out);
            this.config.setBytes(OUTPUT_DATA_DISTRIBUTION_PREFIX + outputNum, baos.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Error serializing the DataDistribution: " + e.getMessage(), e);
        }
    }

    public DataDistribution getOutputDataDistribution(int outputNum, ClassLoader cl) throws ClassNotFoundException {
        Class<DataDistribution> clazz;
        String className = this.config.getString(OUTPUT_DATA_DISTRIBUTION_CLASS, null);
        if (className == null) {
            return null;
        }
        try {
            clazz = Class.forName(className, true, cl).asSubclass(DataDistribution.class);
        }
        catch (ClassCastException ccex) {
            throw new CorruptConfigurationException("The class noted in the configuration as the data distribution is no subclass of DataDistribution.");
        }
        DataDistribution distribution = (DataDistribution)InstantiationUtil.instantiate(clazz, DataDistribution.class);
        byte[] stateEncoded = this.config.getBytes(OUTPUT_DATA_DISTRIBUTION_PREFIX + outputNum, null);
        if (stateEncoded == null) {
            throw new CorruptConfigurationException("The configuration contained the data distribution type, but no serialized state.");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(stateEncoded);
        DataInputViewStreamWrapper in = new DataInputViewStreamWrapper((InputStream)bais);
        try {
            distribution.read((DataInputView)in);
            return distribution;
        }
        catch (Exception ex) {
            throw new RuntimeException("The deserialization of the encoded data distribution state caused an error" + (String)(ex.getMessage() == null ? "." : ": " + ex.getMessage()), ex);
        }
    }

    public void setOutputPartitioner(Partitioner<?> partitioner, int outputNum) {
        try {
            InstantiationUtil.writeObjectToConfig(partitioner, (Configuration)this.config, (String)(OUTPUT_PARTITIONER + outputNum));
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not serialize custom partitioner.", t);
        }
    }

    public Partitioner<?> getOutputPartitioner(int outputNum, ClassLoader cl) throws ClassNotFoundException {
        try {
            return (Partitioner)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)(OUTPUT_PARTITIONER + outputNum), (ClassLoader)cl);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not deserialize custom partitioner.", t);
        }
    }

    public void setRelativeMemoryDriver(double relativeMemorySize) {
        this.config.set(ConfigurationUtils.getDoubleConfigOption((String)MEMORY_DRIVER), (Object)relativeMemorySize);
    }

    public double getRelativeMemoryDriver() {
        return (Double)this.config.get(ConfigurationUtils.getDoubleConfigOption((String)MEMORY_DRIVER), (Object)0.0);
    }

    public void setRelativeMemoryInput(int inputNum, double relativeMemorySize) {
        this.config.set(ConfigurationUtils.getDoubleConfigOption((String)(MEMORY_INPUT_PREFIX + inputNum)), (Object)relativeMemorySize);
    }

    public double getRelativeMemoryInput(int inputNum) {
        return (Double)this.config.get(ConfigurationUtils.getDoubleConfigOption((String)(MEMORY_INPUT_PREFIX + inputNum)), (Object)0.0);
    }

    public void setFilehandlesDriver(int filehandles) {
        if (filehandles < 2) {
            throw new IllegalArgumentException();
        }
        this.config.set(ConfigurationUtils.getIntConfigOption((String)FILEHANDLES_DRIVER), (Object)filehandles);
    }

    public int getFilehandlesDriver() {
        return (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)FILEHANDLES_DRIVER), (Object)-1);
    }

    public void setFilehandlesInput(int inputNum, int filehandles) {
        if (filehandles < 2) {
            throw new IllegalArgumentException();
        }
        this.config.set(ConfigurationUtils.getIntConfigOption((String)(FILEHANDLES_INPUT_PREFIX + inputNum)), (Object)filehandles);
    }

    public int getFilehandlesInput(int inputNum) {
        return (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)(FILEHANDLES_INPUT_PREFIX + inputNum)), (Object)-1);
    }

    public void setSpillingThresholdDriver(float threshold) {
        if (threshold < 0.0f || threshold > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.config.set(ConfigurationUtils.getFloatConfigOption((String)SORT_SPILLING_THRESHOLD_DRIVER), (Object)Float.valueOf(threshold));
    }

    public float getSpillingThresholdDriver() {
        return ((Float)this.config.get(ConfigurationUtils.getFloatConfigOption((String)SORT_SPILLING_THRESHOLD_DRIVER), (Object)Float.valueOf(0.7f))).floatValue();
    }

    public void setSpillingThresholdInput(int inputNum, float threshold) {
        if (threshold < 0.0f || threshold > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.config.set(ConfigurationUtils.getFloatConfigOption((String)(SORT_SPILLING_THRESHOLD_INPUT_PREFIX + inputNum)), (Object)Float.valueOf(threshold));
    }

    public float getSpillingThresholdInput(int inputNum) {
        return ((Float)this.config.get(ConfigurationUtils.getFloatConfigOption((String)(SORT_SPILLING_THRESHOLD_INPUT_PREFIX + inputNum)), (Object)Float.valueOf(0.7f))).floatValue();
    }

    public void setUseLargeRecordHandler(boolean useLargeRecordHandler) {
        this.config.set(ConfigurationUtils.getBooleanConfigOption((String)USE_LARGE_RECORD_HANDLER), (Object)useLargeRecordHandler);
    }

    public boolean getUseLargeRecordHandler() {
        return (Boolean)this.config.get(ConfigurationUtils.getBooleanConfigOption((String)USE_LARGE_RECORD_HANDLER), (Object)false);
    }

    public int getNumberOfChainedStubs() {
        return (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)CHAINING_NUM_STUBS), (Object)0);
    }

    public void addChainedTask(Class<? extends ChainedDriver> chainedTaskClass, TaskConfig conf, String taskName) {
        int numChainedYet = (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)CHAINING_NUM_STUBS), (Object)0);
        this.config.setString(CHAINING_TASK_PREFIX + numChainedYet, chainedTaskClass.getName());
        this.config.addAll(conf.config, CHAINING_TASKCONFIG_PREFIX + numChainedYet + ".");
        this.config.setString(CHAINING_TASKNAME_PREFIX + numChainedYet, taskName);
        this.config.set(ConfigurationUtils.getIntConfigOption((String)CHAINING_NUM_STUBS), (Object)(++numChainedYet));
    }

    public TaskConfig getChainedStubConfig(int chainPos) {
        return new TaskConfig((Configuration)new DelegatingConfiguration(this.config, CHAINING_TASKCONFIG_PREFIX + chainPos + "."));
    }

    public Class<? extends ChainedDriver<?, ?>> getChainedTask(int chainPos) {
        String className = this.config.getString(CHAINING_TASK_PREFIX + chainPos, null);
        if (className == null) {
            throw new IllegalStateException("Chained Task Class missing");
        }
        Class<ChainedDriver> clazz = ChainedDriver.class;
        try {
            return Class.forName(className).asSubclass(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getChainedTaskName(int chainPos) {
        return this.config.getString(CHAINING_TASKNAME_PREFIX + chainPos, null);
    }

    public void setNumberOfIterations(int numberOfIterations) {
        if (numberOfIterations <= 0) {
            throw new IllegalArgumentException();
        }
        this.config.set(ConfigurationUtils.getIntConfigOption((String)NUMBER_OF_ITERATIONS), (Object)numberOfIterations);
    }

    public int getNumberOfIterations() {
        int numberOfIterations = (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)NUMBER_OF_ITERATIONS), (Object)0);
        if (numberOfIterations <= 0) {
            throw new IllegalArgumentException();
        }
        return numberOfIterations;
    }

    public void setIterationHeadPartialSolutionOrWorksetInputIndex(int inputIndex) {
        if (inputIndex < 0) {
            throw new IllegalArgumentException();
        }
        this.config.set(ConfigurationUtils.getIntConfigOption((String)ITERATION_HEAD_INDEX_OF_PARTIAL_SOLUTION), (Object)inputIndex);
    }

    public int getIterationHeadPartialSolutionOrWorksetInputIndex() {
        int index = (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)ITERATION_HEAD_INDEX_OF_PARTIAL_SOLUTION), (Object)-1);
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        return index;
    }

    public void setIterationHeadSolutionSetInputIndex(int inputIndex) {
        if (inputIndex < 0) {
            throw new IllegalArgumentException();
        }
        this.config.set(ConfigurationUtils.getIntConfigOption((String)ITERATION_HEAD_INDEX_OF_SOLUTIONSET), (Object)inputIndex);
    }

    public int getIterationHeadSolutionSetInputIndex() {
        int index = (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)ITERATION_HEAD_INDEX_OF_SOLUTIONSET), (Object)-1);
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        return index;
    }

    public void setRelativeBackChannelMemory(double relativeMemory) {
        if (relativeMemory < 0.0) {
            throw new IllegalArgumentException();
        }
        this.config.set(ConfigurationUtils.getDoubleConfigOption((String)ITERATION_HEAD_BACKCHANNEL_MEMORY), (Object)relativeMemory);
    }

    public double getRelativeBackChannelMemory() {
        double relativeBackChannelMemory = (Double)this.config.get(ConfigurationUtils.getDoubleConfigOption((String)ITERATION_HEAD_BACKCHANNEL_MEMORY), (Object)0.0);
        if (relativeBackChannelMemory <= 0.0) {
            throw new IllegalArgumentException();
        }
        return relativeBackChannelMemory;
    }

    public void setRelativeSolutionSetMemory(double relativeMemory) {
        if (relativeMemory < 0.0) {
            throw new IllegalArgumentException();
        }
        this.config.set(ConfigurationUtils.getDoubleConfigOption((String)ITERATION_HEAD_SOLUTION_SET_MEMORY), (Object)relativeMemory);
    }

    public double getRelativeSolutionSetMemory() {
        double backChannelMemory = (Double)this.config.get(ConfigurationUtils.getDoubleConfigOption((String)ITERATION_HEAD_SOLUTION_SET_MEMORY), (Object)0.0);
        if (backChannelMemory <= 0.0) {
            throw new IllegalArgumentException();
        }
        return backChannelMemory;
    }

    public boolean isIterativeInputGate(int inputGateIndex) {
        return this.getNumberOfEventsUntilInterruptInIterativeGate(inputGateIndex) > 0;
    }

    public void setGateIterativeWithNumberOfEventsUntilInterrupt(int inputGateIndex, int numEvents) {
        if (inputGateIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (numEvents <= 0) {
            throw new IllegalArgumentException();
        }
        this.config.set(ConfigurationUtils.getIntConfigOption((String)(NUMBER_OF_EOS_EVENTS_PREFIX + inputGateIndex)), (Object)numEvents);
    }

    public int getNumberOfEventsUntilInterruptInIterativeGate(int inputGateIndex) {
        if (inputGateIndex < 0) {
            throw new IllegalArgumentException();
        }
        return (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)(NUMBER_OF_EOS_EVENTS_PREFIX + inputGateIndex)), (Object)0);
    }

    public void setBroadcastGateIterativeWithNumberOfEventsUntilInterrupt(int bcGateIndex, int numEvents) {
        if (bcGateIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (numEvents <= 0) {
            throw new IllegalArgumentException();
        }
        this.config.set(ConfigurationUtils.getIntConfigOption((String)(NUMBER_OF_EOS_EVENTS_BROADCAST_PREFIX + bcGateIndex)), (Object)numEvents);
    }

    public int getNumberOfEventsUntilInterruptInIterativeBroadcastGate(int bcGateIndex) {
        if (bcGateIndex < 0) {
            throw new IllegalArgumentException();
        }
        return (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)(NUMBER_OF_EOS_EVENTS_BROADCAST_PREFIX + bcGateIndex)), (Object)0);
    }

    public void setIterationId(int id) {
        if (id < 0) {
            throw new IllegalArgumentException();
        }
        this.config.set(ConfigurationUtils.getIntConfigOption((String)ITERATION_HEAD_ID), (Object)id);
    }

    public int getIterationId() {
        int id = (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)ITERATION_HEAD_ID), (Object)-1);
        if (id == -1) {
            throw new CorruptConfigurationException("Iteration head ID is missing.");
        }
        return id;
    }

    public void setIsWorksetIteration() {
        this.config.set(ConfigurationUtils.getBooleanConfigOption((String)ITERATION_WORKSET_MARKER), (Object)true);
    }

    public boolean getIsWorksetIteration() {
        return (Boolean)this.config.get(ConfigurationUtils.getBooleanConfigOption((String)ITERATION_WORKSET_MARKER), (Object)false);
    }

    public void setIterationHeadIndexOfSyncOutput(int outputIndex) {
        if (outputIndex < 0) {
            throw new IllegalArgumentException();
        }
        this.config.set(ConfigurationUtils.getIntConfigOption((String)ITERATION_HEAD_SYNC_OUT_INDEX), (Object)outputIndex);
    }

    public int getIterationHeadIndexOfSyncOutput() {
        int outputIndex = (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)ITERATION_HEAD_SYNC_OUT_INDEX), (Object)-1);
        if (outputIndex < 0) {
            throw new IllegalArgumentException();
        }
        return outputIndex;
    }

    public void setIterationHeadFinalOutputConfig(TaskConfig conf) {
        this.config.addAll(conf.config, ITERATION_HEAD_FINAL_OUT_CONFIG_PREFIX);
    }

    public TaskConfig getIterationHeadFinalOutputConfig() {
        return new TaskConfig((Configuration)new DelegatingConfiguration(this.config, ITERATION_HEAD_FINAL_OUT_CONFIG_PREFIX));
    }

    public void setSolutionSetSerializer(TypeSerializerFactory<?> factory) {
        this.setTypeSerializerFactory(factory, ITERATION_SOLUTION_SET_SERIALIZER, ITERATION_SOLUTION_SET_SERIALIZER_PARAMETERS);
    }

    public <T> TypeSerializerFactory<T> getSolutionSetSerializer(ClassLoader cl) {
        return this.getTypeSerializerFactory(ITERATION_SOLUTION_SET_SERIALIZER, ITERATION_SOLUTION_SET_SERIALIZER_PARAMETERS, cl);
    }

    public void setSolutionSetComparator(TypeComparatorFactory<?> factory) {
        this.setTypeComparatorFactory(factory, ITERATION_SOLUTION_SET_COMPARATOR, ITERATION_SOLUTION_SET_COMPARATOR_PARAMETERS);
    }

    public <T> TypeComparatorFactory<T> getSolutionSetComparator(ClassLoader cl) {
        return this.getTypeComparatorFactory(ITERATION_SOLUTION_SET_COMPARATOR, ITERATION_SOLUTION_SET_COMPARATOR_PARAMETERS, cl);
    }

    public void addIterationAggregator(String name, Aggregator<?> aggregator) {
        int num = (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)ITERATION_NUM_AGGREGATORS), (Object)0);
        this.config.setString(ITERATION_AGGREGATOR_NAME_PREFIX + num, name);
        try {
            InstantiationUtil.writeObjectToConfig(aggregator, (Configuration)this.config, (String)(ITERATION_AGGREGATOR_PREFIX + num));
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing the aggregator object to the task configuration.");
        }
        this.config.set(ConfigurationUtils.getIntConfigOption((String)ITERATION_NUM_AGGREGATORS), (Object)(num + 1));
    }

    public void addIterationAggregators(Collection<AggregatorWithName<?>> aggregators) {
        int num = (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)ITERATION_NUM_AGGREGATORS), (Object)0);
        for (AggregatorWithName<?> awn : aggregators) {
            this.config.setString(ITERATION_AGGREGATOR_NAME_PREFIX + num, awn.getName());
            try {
                InstantiationUtil.writeObjectToConfig((Object)awn.getAggregator(), (Configuration)this.config, (String)(ITERATION_AGGREGATOR_PREFIX + num));
            }
            catch (IOException e) {
                throw new RuntimeException("Error while writing the aggregator object to the task configuration.");
            }
            ++num;
        }
        this.config.set(ConfigurationUtils.getIntConfigOption((String)ITERATION_NUM_AGGREGATORS), (Object)num);
    }

    public Collection<AggregatorWithName<?>> getIterationAggregators(ClassLoader cl) {
        int numAggs = (Integer)this.config.get(ConfigurationUtils.getIntConfigOption((String)ITERATION_NUM_AGGREGATORS), (Object)0);
        if (numAggs == 0) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(numAggs);
        for (int i = 0; i < numAggs; ++i) {
            Aggregator aggObj;
            try {
                aggObj = (Aggregator)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)(ITERATION_AGGREGATOR_PREFIX + i), (ClassLoader)cl);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while reading the aggregator object from the task configuration.");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Error while reading the aggregator object from the task configuration. Aggregator class not found.");
            }
            if (aggObj == null) {
                throw new RuntimeException("Missing config entry for aggregator.");
            }
            String name = this.config.getString(ITERATION_AGGREGATOR_NAME_PREFIX + i, null);
            if (name == null) {
                throw new RuntimeException("Missing config entry for aggregator.");
            }
            list.add(new AggregatorWithName(name, aggObj));
        }
        return list;
    }

    public void setConvergenceCriterion(String aggregatorName, ConvergenceCriterion<?> convCriterion) {
        try {
            InstantiationUtil.writeObjectToConfig(convCriterion, (Configuration)this.config, (String)ITERATION_CONVERGENCE_CRITERION);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing the convergence criterion object to the task configuration.");
        }
        this.config.setString(ITERATION_CONVERGENCE_CRITERION_AGG_NAME, aggregatorName);
    }

    public void setImplicitConvergenceCriterion(String aggregatorName, ConvergenceCriterion<?> convCriterion) {
        try {
            InstantiationUtil.writeObjectToConfig(convCriterion, (Configuration)this.config, (String)ITERATION_IMPLICIT_CONVERGENCE_CRITERION);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing the implicit convergence criterion object to the task configuration.");
        }
        this.config.setString(ITERATION_IMPLICIT_CONVERGENCE_CRITERION_AGG_NAME, aggregatorName);
    }

    public <T extends Value> ConvergenceCriterion<T> getConvergenceCriterion(ClassLoader cl) {
        ConvergenceCriterion convCriterionObj;
        try {
            convCriterionObj = (ConvergenceCriterion)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)ITERATION_CONVERGENCE_CRITERION, (ClassLoader)cl);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading the convergence criterion object from the task configuration.");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error while reading the convergence criterion object from the task configuration. ConvergenceCriterion class not found.");
        }
        if (convCriterionObj == null) {
            throw new NullPointerException();
        }
        return convCriterionObj;
    }

    public boolean usesConvergenceCriterion() {
        return this.config.getBytes(ITERATION_CONVERGENCE_CRITERION, null) != null;
    }

    public String getConvergenceCriterionAggregatorName() {
        return this.config.getString(ITERATION_CONVERGENCE_CRITERION_AGG_NAME, null);
    }

    public <T extends Value> ConvergenceCriterion<T> getImplicitConvergenceCriterion(ClassLoader cl) {
        ConvergenceCriterion convCriterionObj;
        try {
            convCriterionObj = (ConvergenceCriterion)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)ITERATION_IMPLICIT_CONVERGENCE_CRITERION, (ClassLoader)cl);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading the default convergence criterion object from the task configuration.");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error while reading the default convergence criterion object from the task configuration. ConvergenceCriterion class not found.");
        }
        if (convCriterionObj == null) {
            throw new NullPointerException();
        }
        return convCriterionObj;
    }

    public boolean usesImplicitConvergenceCriterion() {
        return this.config.getBytes(ITERATION_IMPLICIT_CONVERGENCE_CRITERION, null) != null;
    }

    public String getImplicitConvergenceCriterionAggregatorName() {
        return this.config.getString(ITERATION_IMPLICIT_CONVERGENCE_CRITERION_AGG_NAME, null);
    }

    public void setIsSolutionSetUpdate() {
        this.config.set(ConfigurationUtils.getBooleanConfigOption((String)ITERATION_SOLUTION_SET_UPDATE), (Object)true);
    }

    public boolean getIsSolutionSetUpdate() {
        return (Boolean)this.config.get(ConfigurationUtils.getBooleanConfigOption((String)ITERATION_SOLUTION_SET_UPDATE), (Object)false);
    }

    public void setIsSolutionSetUpdateWithoutReprobe() {
        this.config.set(ConfigurationUtils.getBooleanConfigOption((String)ITERATION_SOLUTION_SET_UPDATE_SKIP_REPROBE), (Object)true);
    }

    public void setWaitForSolutionSetUpdate() {
        this.config.set(ConfigurationUtils.getBooleanConfigOption((String)ITERATION_SOLUTION_SET_UPDATE_WAIT), (Object)true);
    }

    public boolean getWaitForSolutionSetUpdate() {
        return (Boolean)this.config.get(ConfigurationUtils.getBooleanConfigOption((String)ITERATION_SOLUTION_SET_UPDATE_WAIT), (Object)false);
    }

    public void setIsWorksetUpdate() {
        this.config.set(ConfigurationUtils.getBooleanConfigOption((String)ITERATION_WORKSET_UPDATE), (Object)true);
    }

    public boolean getIsWorksetUpdate() {
        return (Boolean)this.config.get(ConfigurationUtils.getBooleanConfigOption((String)ITERATION_WORKSET_UPDATE), (Object)false);
    }

    private void setTypeSerializerFactory(TypeSerializerFactory<?> factory, String classNameKey, String parametersPrefix) {
        InstantiationUtil.checkForInstantiation(factory.getClass());
        this.config.setString(classNameKey, factory.getClass().getName());
        DelegatingConfiguration parameters = new DelegatingConfiguration(this.config, parametersPrefix);
        factory.writeParametersToConfig((Configuration)parameters);
    }

    private <T> TypeSerializerFactory<T> getTypeSerializerFactory(String classNameKey, String parametersPrefix, ClassLoader cl) {
        TypeSerializerFactory factory;
        String className = this.config.getString(classNameKey, null);
        if (className == null) {
            return null;
        }
        Class<TypeSerializerFactory> superClass = TypeSerializerFactory.class;
        try {
            Class<TypeSerializerFactory> clazz = Class.forName(className, true, cl).asSubclass(superClass);
            factory = (TypeSerializerFactory)InstantiationUtil.instantiate(clazz, superClass);
        }
        catch (ClassNotFoundException cnfex) {
            throw new RuntimeException("The class '" + className + "', noted in the configuration as serializer factory, could not be found. It is not part of the user code's class loader resources.");
        }
        catch (ClassCastException ccex) {
            throw new CorruptConfigurationException("The class noted in the configuration as the serializer factory is no subclass of TypeSerializerFactory.");
        }
        DelegatingConfiguration parameters = new DelegatingConfiguration(this.config, parametersPrefix);
        try {
            factory.readParametersFromConfig((Configuration)parameters, cl);
        }
        catch (ClassNotFoundException cnfex) {
            throw new RuntimeException("The type serializer factory could not load its parameters from the configuration due to missing classes.", cnfex);
        }
        return factory;
    }

    private void setTypeComparatorFactory(TypeComparatorFactory<?> factory, String classNameKey, String parametersPrefix) {
        InstantiationUtil.checkForInstantiation(factory.getClass());
        this.config.setString(classNameKey, factory.getClass().getName());
        DelegatingConfiguration parameters = new DelegatingConfiguration(this.config, parametersPrefix);
        factory.writeParametersToConfig((Configuration)parameters);
    }

    private <T> TypeComparatorFactory<T> getTypeComparatorFactory(String classNameKey, String parametersPrefix, ClassLoader cl) {
        TypeComparatorFactory factory;
        String className = this.config.getString(classNameKey, null);
        if (className == null) {
            return null;
        }
        Class<TypeComparatorFactory> superClass = TypeComparatorFactory.class;
        try {
            Class<TypeComparatorFactory> clazz = Class.forName(className, true, cl).asSubclass(superClass);
            factory = (TypeComparatorFactory)InstantiationUtil.instantiate(clazz, superClass);
        }
        catch (ClassNotFoundException cnfex) {
            throw new RuntimeException("The class '" + className + "', noted in the configuration as comparator factory, could not be found. It is not part of the user code's class loader resources.");
        }
        catch (ClassCastException ccex) {
            throw new CorruptConfigurationException("The class noted in the configuration as the comparator factory is no subclass of TypeComparatorFactory.");
        }
        DelegatingConfiguration parameters = new DelegatingConfiguration(this.config, parametersPrefix);
        try {
            factory.readParametersFromConfig((Configuration)parameters, cl);
        }
        catch (ClassNotFoundException cnfex) {
            throw new RuntimeException("The type serializer factory could not load its parameters from the configuration due to missing classes.", cnfex);
        }
        return factory;
    }

    public void setSolutionSetUnmanaged(boolean unmanaged) {
        this.config.set(ConfigurationUtils.getBooleanConfigOption((String)SOLUTION_SET_OBJECTS), (Object)unmanaged);
    }

    public boolean isSolutionSetUnmanaged() {
        return (Boolean)this.config.get(ConfigurationUtils.getBooleanConfigOption((String)SOLUTION_SET_OBJECTS), (Object)false);
    }
}

