/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.util;

import java.time.Duration;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.metrics.util.SystemResourcesCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.VirtualMemory;

public class SystemResourcesMetricsInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(SystemResourcesMetricsInitializer.class);

    public static void instantiateSystemMetrics(MetricGroup metricGroup, Duration probeInterval) {
        try {
            MetricGroup system = metricGroup.addGroup("System");
            SystemResourcesCounter systemResourcesCounter = new SystemResourcesCounter(probeInterval);
            systemResourcesCounter.start();
            SystemInfo systemInfo = new SystemInfo();
            HardwareAbstractionLayer hardwareAbstractionLayer = systemInfo.getHardware();
            SystemResourcesMetricsInitializer.instantiateMemoryMetrics(system.addGroup("Memory"), hardwareAbstractionLayer.getMemory());
            SystemResourcesMetricsInitializer.instantiateSwapMetrics(system.addGroup("Swap"), hardwareAbstractionLayer.getMemory());
            SystemResourcesMetricsInitializer.instantiateCPUMetrics(system.addGroup("CPU"), systemResourcesCounter);
            SystemResourcesMetricsInitializer.instantiateNetworkMetrics(system.addGroup("Network"), systemResourcesCounter);
        }
        catch (NoClassDefFoundError ex) {
            LOG.warn("Failed to initialize system resource metrics because of missing class definitions. Did you forget to explicitly add the oshi-core optional dependency?", (Throwable)ex);
        }
    }

    private static void instantiateMemoryMetrics(MetricGroup metrics, GlobalMemory memory) {
        metrics.gauge("Available", () -> ((GlobalMemory)memory).getAvailable());
        metrics.gauge("Total", () -> ((GlobalMemory)memory).getTotal());
    }

    private static void instantiateSwapMetrics(MetricGroup metrics, GlobalMemory memory) {
        metrics.gauge("Used", () -> ((VirtualMemory)memory.getVirtualMemory()).getSwapUsed());
        metrics.gauge("Total", () -> ((VirtualMemory)memory.getVirtualMemory()).getSwapTotal());
    }

    private static void instantiateCPUMetrics(MetricGroup metrics, SystemResourcesCounter usageCounter) {
        metrics.gauge("Usage", usageCounter::getCpuUsage);
        metrics.gauge("Idle", usageCounter::getCpuIdle);
        metrics.gauge("Sys", usageCounter::getCpuSys);
        metrics.gauge("User", usageCounter::getCpuUser);
        metrics.gauge("IOWait", usageCounter::getIOWait);
        metrics.gauge("Nice", usageCounter::getCpuNice);
        metrics.gauge("Irq", usageCounter::getCpuIrq);
        metrics.gauge("SoftIrq", usageCounter::getCpuSoftIrq);
        metrics.gauge("Steal", usageCounter::getCpuSteal);
        metrics.gauge("Load1min", usageCounter::getCpuLoad1);
        metrics.gauge("Load5min", usageCounter::getCpuLoad5);
        metrics.gauge("Load15min", usageCounter::getCpuLoad15);
        int i = 0;
        while (i < usageCounter.getProcessorsCount()) {
            int processor = i++;
            metrics.gauge(String.format("UsageCPU%d", processor), () -> usageCounter.getCpuUsagePerProcessor(processor));
        }
    }

    private static void instantiateNetworkMetrics(MetricGroup metrics, SystemResourcesCounter usageCounter) {
        int i = 0;
        while (i < usageCounter.getNetworkInterfaceNames().length) {
            MetricGroup interfaceGroup = metrics.addGroup(usageCounter.getNetworkInterfaceNames()[i]);
            int interfaceNo = i++;
            interfaceGroup.gauge("ReceiveRate", () -> usageCounter.getReceiveRatePerInterface(interfaceNo));
            interfaceGroup.gauge("SendRate", () -> usageCounter.getSendRatePerInterface(interfaceNo));
        }
    }
}

