/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetricsBuilder;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.testutils.MockInputSplitProvider;
import org.apache.flink.runtime.state.DoneFuture;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.state.TestTaskStateManager;
import org.apache.flink.runtime.testutils.ExceptionallyDoneFuture;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.streaming.runtime.tasks.AsyncCheckpointRunnable;
import org.apache.flink.streaming.runtime.tasks.StreamMockEnvironment;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AsyncCheckpointRunnableTest {
    AsyncCheckpointRunnableTest() {
    }

    @Test
    void testReportIncompleteStats() {
        long checkpointId = 1000L;
        TestEnvironment env = new TestEnvironment();
        new AsyncCheckpointRunnable(new HashMap(), new CheckpointMetaData(checkpointId, 1L), new CheckpointMetricsBuilder(), 0L, "Task Name", r -> {}, (Environment)env, (msg, ex) -> {}, false, false, () -> true).close();
        Assertions.assertThat((long)((TestTaskStateManager)env.getTaskStateManager()).getReportedCheckpointId()).isEqualTo(checkpointId);
    }

    @Test
    void testDeclineWithAsyncCheckpointExceptionWhenRunning() {
        this.testAsyncCheckpointException(true);
    }

    @Test
    void testDeclineWithAsyncCheckpointExceptionWhenNotRunning() {
        this.testAsyncCheckpointException(false);
    }

    private void testAsyncCheckpointException(boolean isTaskRunning) {
        HashMap<OperatorID, OperatorSnapshotFutures> snapshotsInProgress = new HashMap<OperatorID, OperatorSnapshotFutures>();
        snapshotsInProgress.put(new OperatorID(), new OperatorSnapshotFutures(ExceptionallyDoneFuture.of(new RuntimeException("Async Checkpoint Exception")), (RunnableFuture)DoneFuture.of((Object)SnapshotResult.empty()), (RunnableFuture)DoneFuture.of((Object)SnapshotResult.empty()), (RunnableFuture)DoneFuture.of((Object)SnapshotResult.empty()), (Future)DoneFuture.of((Object)SnapshotResult.empty()), (Future)DoneFuture.of((Object)SnapshotResult.empty())));
        TestEnvironment environment = new TestEnvironment();
        AsyncCheckpointRunnable runnable = this.createAsyncRunnable(snapshotsInProgress, environment, false, isTaskRunning);
        runnable.run();
        if (isTaskRunning) {
            Assertions.assertThat((Comparable)environment.getCause().getCheckpointFailureReason()).isSameAs((Object)CheckpointFailureReason.CHECKPOINT_ASYNC_EXCEPTION);
        } else {
            Assertions.assertThat((Throwable)environment.getCause()).isNull();
        }
    }

    @Test
    void testDeclineAsyncCheckpoint() {
        CheckpointFailureReason originalReason = CheckpointFailureReason.CHECKPOINT_DECLINED_INPUT_END_OF_STREAM;
        HashMap<OperatorID, OperatorSnapshotFutures> snapshotsInProgress = new HashMap<OperatorID, OperatorSnapshotFutures>();
        snapshotsInProgress.put(new OperatorID(), new OperatorSnapshotFutures((RunnableFuture)DoneFuture.of((Object)SnapshotResult.empty()), (RunnableFuture)DoneFuture.of((Object)SnapshotResult.empty()), (RunnableFuture)DoneFuture.of((Object)SnapshotResult.empty()), (RunnableFuture)DoneFuture.of((Object)SnapshotResult.empty()), ExceptionallyDoneFuture.of((Throwable)new CheckpointException(originalReason)), (Future)DoneFuture.of((Object)SnapshotResult.empty())));
        TestEnvironment environment = new TestEnvironment();
        AsyncCheckpointRunnable runnable = this.createAsyncRunnable(snapshotsInProgress, environment, false, true);
        runnable.run();
        Assertions.assertThat((Comparable)environment.getCause().getCheckpointFailureReason()).isSameAs((Object)originalReason);
    }

    @Test
    void testReportFinishedOnRestoreTaskSnapshots() {
        TestEnvironment environment = new TestEnvironment();
        AsyncCheckpointRunnable asyncCheckpointRunnable = this.createAsyncRunnable(new HashMap<OperatorID, OperatorSnapshotFutures>(), environment, true, true);
        asyncCheckpointRunnable.run();
        TestTaskStateManager testTaskStateManager = (TestTaskStateManager)environment.getTaskStateManager();
        Assertions.assertThat((long)testTaskStateManager.getReportedCheckpointId()).isEqualTo(asyncCheckpointRunnable.getCheckpointId());
        Assertions.assertThat((Object)testTaskStateManager.getLastJobManagerTaskStateSnapshot()).isEqualTo((Object)TaskStateSnapshot.FINISHED_ON_RESTORE);
        Assertions.assertThat((Object)testTaskStateManager.getLastTaskManagerTaskStateSnapshot()).isEqualTo((Object)TaskStateSnapshot.FINISHED_ON_RESTORE);
        Assertions.assertThat((CompletableFuture)asyncCheckpointRunnable.getFinishedFuture()).isDone();
    }

    private AsyncCheckpointRunnable createAsyncRunnable(Map<OperatorID, OperatorSnapshotFutures> snapshotsInProgress, TestEnvironment environment, boolean isTaskDeployedAsFinished, boolean isTaskRunning) {
        return new AsyncCheckpointRunnable(snapshotsInProgress, new CheckpointMetaData(1L, 1L), new CheckpointMetricsBuilder().setBytesProcessedDuringAlignment(0L).setAlignmentDurationNanos(0L), 1L, "Task Name", r -> {}, (Environment)environment, (msg, ex) -> {}, isTaskDeployedAsFinished, false, () -> isTaskRunning);
    }

    private static class TestEnvironment
    extends StreamMockEnvironment {
        CheckpointException cause = null;

        TestEnvironment() {
            this(new Configuration(), new Configuration(), new ExecutionConfig(), 1L, new MockInputSplitProvider(), 1, new TestTaskStateManager());
        }

        TestEnvironment(Configuration jobConfig, Configuration taskConfig, ExecutionConfig executionConfig, long memorySize, MockInputSplitProvider inputSplitProvider, int bufferSize, TaskStateManager taskStateManager) {
            super(jobConfig, taskConfig, executionConfig, memorySize, inputSplitProvider, bufferSize, taskStateManager);
        }

        @Override
        public void declineCheckpoint(long checkpointId, CheckpointException checkpointException) {
            this.cause = checkpointException;
        }

        CheckpointException getCause() {
            return this.cause;
        }
    }
}

