/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.partitioner;

import java.io.IOException;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.InstantiationUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

abstract class StreamPartitionerTest {
    final StreamPartitioner<Tuple> streamPartitioner = this.createPartitioner();
    final StreamRecord<Tuple> streamRecord = new StreamRecord(null);
    final SerializationDelegate<StreamRecord<Tuple>> serializationDelegate = new SerializationDelegate(null);

    StreamPartitionerTest() {
    }

    abstract StreamPartitioner<Tuple> createPartitioner();

    @BeforeEach
    void setup() {
        this.serializationDelegate.setInstance(this.streamRecord);
    }

    void assertSelectedChannel(int expectedChannel) {
        int actualResult = this.streamPartitioner.selectChannel(this.serializationDelegate);
        Assertions.assertThat((int)actualResult).isEqualTo(expectedChannel);
    }

    void assertSelectedChannelWithSetup(int expectedChannel, int numberOfChannels) {
        this.streamPartitioner.setup(numberOfChannels);
        this.assertSelectedChannel(expectedChannel);
    }

    @Test
    void testSerializable() throws IOException, ClassNotFoundException {
        StreamPartitioner clone = (StreamPartitioner)InstantiationUtil.clone(this.streamPartitioner);
        Assertions.assertThat((Object)clone).isEqualTo(this.streamPartitioner);
    }
}

