/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.history;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HistoryServerOptions;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.webmonitor.history.HistoryServerUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

class HistoryServerUtilsTest {
    private static final String HOSTNAME = "foobar";
    private static final int PORT = 1234;

    HistoryServerUtilsTest() {
    }

    @Test
    void testIsSSLEnabledDefault() {
        Configuration configuration = new Configuration();
        Assertions.assertThat((boolean)HistoryServerUtils.isSSLEnabled((Configuration)configuration)).isFalse();
    }

    @Test
    void testIsSSLEnabledWithoutRestSSL() {
        Configuration configuration = new Configuration();
        configuration.set(HistoryServerOptions.HISTORY_SERVER_WEB_SSL_ENABLED, (Object)true);
        Assertions.assertThat((boolean)HistoryServerUtils.isSSLEnabled((Configuration)configuration)).isFalse();
    }

    @Test
    void testIsSSLEnabledOnlyRestSSL() {
        Configuration configuration = new Configuration();
        configuration.set(SecurityOptions.SSL_REST_ENABLED, (Object)true);
        Assertions.assertThat((boolean)HistoryServerUtils.isSSLEnabled((Configuration)configuration)).isFalse();
    }

    @Test
    void testIsSSLEnabled() {
        Configuration configuration = new Configuration();
        this.enableSSL(configuration);
        Assertions.assertThat((boolean)HistoryServerUtils.isSSLEnabled((Configuration)configuration)).isTrue();
    }

    private void enableSSL(Configuration configuration) {
        configuration.set(HistoryServerOptions.HISTORY_SERVER_WEB_SSL_ENABLED, (Object)true);
        configuration.set(SecurityOptions.SSL_REST_ENABLED, (Object)true);
    }

    @Test
    void testGetHistoryServerURL() throws MalformedURLException {
        Configuration configuration = this.createDefaultConfiguration();
        Optional historyServerURL = HistoryServerUtils.getHistoryServerURL((Configuration)configuration);
        ((OptionalAssert)Assertions.assertThat((Optional)historyServerURL).isPresent()).hasValue((Object)new URL("http", HOSTNAME, 1234, ""));
    }

    @Test
    void testGetHistoryServerURLWithSSL() throws MalformedURLException {
        Configuration configuration = this.createDefaultConfiguration();
        this.enableSSL(configuration);
        Optional historyServerURL = HistoryServerUtils.getHistoryServerURL((Configuration)configuration);
        ((OptionalAssert)Assertions.assertThat((Optional)historyServerURL).isPresent()).hasValue((Object)new URL("https", HOSTNAME, 1234, ""));
    }

    @Test
    void testGetHistoryServerURLWithoutHS() {
        Configuration configuration = new Configuration();
        Assertions.assertThat((Optional)HistoryServerUtils.getHistoryServerURL((Configuration)configuration)).isNotPresent();
    }

    @Nonnull
    private Configuration createDefaultConfiguration() {
        Configuration configuration = new Configuration();
        configuration.set(HistoryServerOptions.HISTORY_SERVER_WEB_ADDRESS, (Object)HOSTNAME);
        configuration.set(HistoryServerOptions.HISTORY_SERVER_WEB_PORT, (Object)1234);
        return configuration;
    }
}

