/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.JobResourceRequirements;
import org.apache.flink.runtime.jobmanager.ExecutionPlanStore;
import org.apache.flink.streaming.api.graph.ExecutionPlan;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.BiConsumerWithException;
import org.apache.flink.util.function.BiFunctionWithException;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.ThrowingConsumer;
import org.apache.flink.util.function.ThrowingRunnable;

public class TestingExecutionPlanStore
implements ExecutionPlanStore {
    private final Map<JobID, ExecutionPlan> storedJobs = new HashMap<JobID, ExecutionPlan>();
    private final ThrowingConsumer<ExecutionPlanStore.ExecutionPlanListener, ? extends Exception> startConsumer;
    private final ThrowingRunnable<? extends Exception> stopRunnable;
    private final FunctionWithException<Collection<JobID>, Collection<JobID>, ? extends Exception> jobIdsFunction;
    private final BiFunctionWithException<JobID, Map<JobID, ExecutionPlan>, ExecutionPlan, ? extends Exception> recoverExecutionPlanFunction;
    private final ThrowingConsumer<ExecutionPlan, ? extends Exception> putExecutionPlanConsumer;
    private final BiConsumerWithException<ExecutionPlan, JobResourceRequirements, ? extends Exception> putJobResourceRequirementsConsumer;
    private final BiFunction<JobID, Executor, CompletableFuture<Void>> globalCleanupFunction;
    private final BiFunction<JobID, Executor, CompletableFuture<Void>> localCleanupFunction;
    private boolean started;

    private TestingExecutionPlanStore(ThrowingConsumer<ExecutionPlanStore.ExecutionPlanListener, ? extends Exception> startConsumer, ThrowingRunnable<? extends Exception> stopRunnable, FunctionWithException<Collection<JobID>, Collection<JobID>, ? extends Exception> jobIdsFunction, BiFunctionWithException<JobID, Map<JobID, ExecutionPlan>, ExecutionPlan, ? extends Exception> recoverExecutionPlanFunction, ThrowingConsumer<ExecutionPlan, ? extends Exception> putExecutionPlanConsumer, BiConsumerWithException<ExecutionPlan, JobResourceRequirements, ? extends Exception> putJobResourceRequirementsConsumer, BiFunction<JobID, Executor, CompletableFuture<Void>> globalCleanupFunction, BiFunction<JobID, Executor, CompletableFuture<Void>> localCleanupFunction, Collection<ExecutionPlan> initialExecutionPlans) {
        this.startConsumer = startConsumer;
        this.stopRunnable = stopRunnable;
        this.jobIdsFunction = jobIdsFunction;
        this.recoverExecutionPlanFunction = recoverExecutionPlanFunction;
        this.putExecutionPlanConsumer = putExecutionPlanConsumer;
        this.putJobResourceRequirementsConsumer = putJobResourceRequirementsConsumer;
        this.globalCleanupFunction = globalCleanupFunction;
        this.localCleanupFunction = localCleanupFunction;
        for (ExecutionPlan initialExecutionPlan : initialExecutionPlans) {
            this.storedJobs.put(initialExecutionPlan.getJobID(), initialExecutionPlan);
        }
    }

    public synchronized void start(@Nullable ExecutionPlanStore.ExecutionPlanListener executionPlanListener) throws Exception {
        this.startConsumer.accept((Object)executionPlanListener);
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        this.stopRunnable.run();
        this.started = false;
    }

    public synchronized ExecutionPlan recoverExecutionPlan(JobID jobId) throws Exception {
        this.verifyIsStarted();
        return (ExecutionPlan)this.recoverExecutionPlanFunction.apply((Object)jobId, this.storedJobs);
    }

    public synchronized void putExecutionPlan(ExecutionPlan executionPlan) throws Exception {
        this.verifyIsStarted();
        this.putExecutionPlanConsumer.accept((Object)executionPlan);
        this.storedJobs.put(executionPlan.getJobID(), executionPlan);
    }

    public void putJobResourceRequirements(JobID jobId, JobResourceRequirements jobResourceRequirements) throws Exception {
        this.verifyIsStarted();
        ExecutionPlan executionPlan = (ExecutionPlan)Preconditions.checkNotNull((Object)this.storedJobs.get(jobId), (String)"Job [%s] not found.", (Object[])new Object[]{jobId});
        this.putJobResourceRequirementsConsumer.accept((Object)executionPlan, (Object)jobResourceRequirements);
    }

    public synchronized CompletableFuture<Void> globalCleanupAsync(JobID jobId, Executor executor) {
        this.verifyIsStarted();
        return this.globalCleanupFunction.apply(jobId, executor).thenRun(() -> this.storedJobs.remove(jobId));
    }

    public synchronized CompletableFuture<Void> localCleanupAsync(JobID jobId, Executor executor) {
        this.verifyIsStarted();
        return this.localCleanupFunction.apply(jobId, executor);
    }

    public synchronized Collection<JobID> getJobIds() throws Exception {
        this.verifyIsStarted();
        return (Collection)this.jobIdsFunction.apply(Collections.unmodifiableSet(new HashSet<JobID>(this.storedJobs.keySet())));
    }

    public synchronized boolean contains(JobID jobId) {
        return this.storedJobs.containsKey(jobId);
    }

    private void verifyIsStarted() {
        Preconditions.checkState((boolean)this.started, (Object)"Not running. Forgot to call start()?");
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ThrowingConsumer<ExecutionPlanStore.ExecutionPlanListener, ? extends Exception> startConsumer = ignored -> {};
        private ThrowingRunnable<? extends Exception> stopRunnable = () -> {};
        private FunctionWithException<Collection<JobID>, Collection<JobID>, ? extends Exception> jobIdsFunction = jobIds -> jobIds;
        private BiFunctionWithException<JobID, Map<JobID, ExecutionPlan>, ExecutionPlan, ? extends Exception> recoverExecutionPlanFunction = (jobId, jobs) -> (ExecutionPlan)jobs.get(jobId);
        private ThrowingConsumer<ExecutionPlan, ? extends Exception> putExecutionPlanConsumer = ignored -> {};
        private BiConsumerWithException<ExecutionPlan, JobResourceRequirements, ? extends Exception> putJobResourceRequirementsConsumer = (graph, requirements) -> {};
        private BiFunction<JobID, Executor, CompletableFuture<Void>> globalCleanupFunction = (ignoredJobId, ignoredExecutor) -> FutureUtils.completedVoidFuture();
        private BiFunction<JobID, Executor, CompletableFuture<Void>> localCleanupFunction = (ignoredJobId, ignoredExecutor) -> FutureUtils.completedVoidFuture();
        private Collection<ExecutionPlan> initialExecutionPlans = Collections.emptyList();
        private boolean startExecutionPlanStore = false;

        private Builder() {
        }

        public Builder setStartConsumer(ThrowingConsumer<ExecutionPlanStore.ExecutionPlanListener, ? extends Exception> startConsumer) {
            this.startConsumer = startConsumer;
            return this;
        }

        public Builder setStopRunnable(ThrowingRunnable<? extends Exception> stopRunnable) {
            this.stopRunnable = stopRunnable;
            return this;
        }

        public Builder setJobIdsFunction(FunctionWithException<Collection<JobID>, Collection<JobID>, ? extends Exception> jobIdsFunction) {
            this.jobIdsFunction = jobIdsFunction;
            return this;
        }

        public Builder setRecoverExecutionPlanFunction(BiFunctionWithException<JobID, Map<JobID, ExecutionPlan>, ExecutionPlan, ? extends Exception> recoverExecutionPlanFunction) {
            this.recoverExecutionPlanFunction = recoverExecutionPlanFunction;
            return this;
        }

        public Builder setPutExecutionPlanConsumer(ThrowingConsumer<ExecutionPlan, ? extends Exception> putExecutionPlanConsumer) {
            this.putExecutionPlanConsumer = putExecutionPlanConsumer;
            return this;
        }

        public Builder setPutJobResourceRequirementsConsumer(BiConsumerWithException<ExecutionPlan, JobResourceRequirements, ? extends Exception> putJobResourceRequirementsConsumer) {
            this.putJobResourceRequirementsConsumer = putJobResourceRequirementsConsumer;
            return this;
        }

        public Builder setGlobalCleanupFunction(BiFunction<JobID, Executor, CompletableFuture<Void>> globalCleanupFunction) {
            this.globalCleanupFunction = globalCleanupFunction;
            return this;
        }

        public Builder setLocalCleanupFunction(BiFunction<JobID, Executor, CompletableFuture<Void>> localCleanupFunction) {
            this.localCleanupFunction = localCleanupFunction;
            return this;
        }

        public Builder setInitialExecutionPlans(Collection<ExecutionPlan> initialExecutionPlans) {
            this.initialExecutionPlans = initialExecutionPlans;
            return this;
        }

        public Builder withAutomaticStart() {
            this.startExecutionPlanStore = true;
            return this;
        }

        public TestingExecutionPlanStore build() {
            TestingExecutionPlanStore executionPlanStore = new TestingExecutionPlanStore(this.startConsumer, this.stopRunnable, this.jobIdsFunction, this.recoverExecutionPlanFunction, this.putExecutionPlanConsumer, this.putJobResourceRequirementsConsumer, this.globalCleanupFunction, this.localCleanupFunction, this.initialExecutionPlans);
            if (this.startExecutionPlanStore) {
                try {
                    executionPlanStore.start(null);
                }
                catch (Exception e) {
                    ExceptionUtils.rethrow((Throwable)e);
                }
            }
            return executionPlanStore;
        }
    }
}

