/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.flink.core.fs.EntropyInjectingFileSystem;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStreamFactory;
import org.apache.flink.runtime.state.filesystem.FsStorageEntropyTest;
import org.apache.flink.runtime.state.filesystem.RelativeFileStateHandle;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class FsCheckpointStreamFactoryTest {
    @TempDir
    private java.nio.file.Path exclusiveStateDir;
    @TempDir
    private java.nio.file.Path sharedStateDir;

    FsCheckpointStreamFactoryTest() {
    }

    @Test
    void testWriteFlushesIfAboveThreshold() throws IOException {
        int fileSizeThreshold = 100;
        FsCheckpointStreamFactory factory = this.createFactory(FileSystem.getLocalFileSystem(), fileSizeThreshold, fileSizeThreshold);
        FsCheckpointStreamFactory.FsCheckpointStateOutputStream stream = factory.createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE);
        stream.write(new byte[fileSizeThreshold]);
        Object[] files = new File(this.exclusiveStateDir.toUri()).listFiles();
        Assertions.assertThat((Object[])files).hasSize(1);
        Object file = files[0];
        Assertions.assertThat((File)file).hasSize((long)fileSizeThreshold);
        stream.write(new byte[fileSizeThreshold - 1]);
        stream.write(127);
        Assertions.assertThat((File)file).hasSize((long)fileSizeThreshold);
    }

    @Test
    void testExclusiveStateHasRelativePathHandles() throws IOException {
        FsCheckpointStreamFactory factory = this.createFactory(FileSystem.getLocalFileSystem(), 0);
        FsCheckpointStreamFactory.FsCheckpointStateOutputStream stream = factory.createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE);
        stream.write(1657);
        StreamStateHandle handle = stream.closeAndGetHandle();
        Assertions.assertThat((Object)handle).isInstanceOf(RelativeFileStateHandle.class);
        FsCheckpointStreamFactoryTest.assertPathsEqual(this.exclusiveStateDir, ((RelativeFileStateHandle)handle).getFilePath().getParent());
    }

    @Test
    void testSharedStateHasAbsolutePathHandles() throws IOException {
        FsCheckpointStreamFactory factory = this.createFactory(FileSystem.getLocalFileSystem(), 0);
        FsCheckpointStreamFactory.FsCheckpointStateOutputStream stream = factory.createCheckpointStateOutputStream(CheckpointedStateScope.SHARED);
        stream.write(0);
        StreamStateHandle handle = stream.closeAndGetHandle();
        Assertions.assertThat((Object)handle).isInstanceOf(FileStateHandle.class);
        Assertions.assertThat((Object)handle).isNotInstanceOf(RelativeFileStateHandle.class);
        FsCheckpointStreamFactoryTest.assertPathsEqual(this.sharedStateDir, ((FileStateHandle)handle).getFilePath().getParent());
    }

    @Test
    void testEntropyMakesExclusiveStateAbsolutePaths() throws IOException {
        FsStorageEntropyTest.TestEntropyAwareFs fs = new FsStorageEntropyTest.TestEntropyAwareFs();
        FsCheckpointStreamFactory factory = this.createFactory(fs, 0);
        FsCheckpointStreamFactory.FsCheckpointStateOutputStream stream = factory.createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE);
        stream.write(0);
        StreamStateHandle handle = stream.closeAndGetHandle();
        Assertions.assertThat((Object)handle).isInstanceOf(FileStateHandle.class);
        Assertions.assertThat((Object)handle).isNotInstanceOf(RelativeFileStateHandle.class);
        FsCheckpointStreamFactoryTest.assertPathsEqual(this.exclusiveStateDir.resolve(fs.generateEntropy()), ((FileStateHandle)handle).getFilePath().getParent());
    }

    @Test
    void testFSWithDisabledEntropyHasRelativePaths() throws IOException {
        FsCheckpointStreamFactory factory = this.createFactory((FileSystem)new DisabledEntropyFS(), 0);
        FsCheckpointStreamFactory.FsCheckpointStateOutputStream stream = factory.createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE);
        stream.write(0);
        StreamStateHandle handle = stream.closeAndGetHandle();
        Assertions.assertThat((Object)handle).isInstanceOf(RelativeFileStateHandle.class);
        FsCheckpointStreamFactoryTest.assertPathsEqual(this.exclusiveStateDir, ((RelativeFileStateHandle)handle).getFilePath().getParent());
    }

    @Test
    void testFlushUnderThreshold() throws IOException {
        this.flushAndVerify(10, 10, true);
    }

    @Test
    void testFlushAboveThreshold() throws IOException {
        this.flushAndVerify(10, 11, false);
    }

    private void flushAndVerify(int minFileSize, int bytesToFlush, boolean expectEmpty) throws IOException {
        FsCheckpointStreamFactory.FsCheckpointStateOutputStream stream = this.createFactory(new FsStorageEntropyTest.TestEntropyAwareFs(), minFileSize).createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE);
        stream.write(new byte[bytesToFlush], 0, bytesToFlush);
        stream.flush();
        Assertions.assertThat((Object[])new File(this.exclusiveStateDir.toUri()).listFiles()).hasSize(expectEmpty ? 0 : 1);
    }

    private static void assertPathsEqual(java.nio.file.Path expected, Path actual) {
        Path reNormalizedExpected = new Path(new Path(expected.toUri()).toString());
        Assertions.assertThat((Object)actual).isEqualTo((Object)reNormalizedExpected);
    }

    private FsCheckpointStreamFactory createFactory(FileSystem fs, int fileSizeThreshold) {
        return this.createFactory(fs, fileSizeThreshold, 4096);
    }

    private FsCheckpointStreamFactory createFactory(FsStorageEntropyTest.TestEntropyAwareFs fs, int fileSizeThreshold) {
        java.nio.file.Path exclusiveStateDirWithEntropy = this.exclusiveStateDir.resolve(Objects.requireNonNull(fs.getEntropyInjectionKey()));
        return new FsCheckpointStreamFactory((FileSystem)fs, new Path(exclusiveStateDirWithEntropy.toUri()), new Path(this.sharedStateDir.toUri()), fileSizeThreshold, 4096);
    }

    private FsCheckpointStreamFactory createFactory(FileSystem fs, int fileSizeThreshold, int bufferSize) {
        return new FsCheckpointStreamFactory(fs, new Path(this.exclusiveStateDir.toUri()), new Path(this.sharedStateDir.toUri()), fileSizeThreshold, bufferSize);
    }

    private static final class DisabledEntropyFS
    extends LocalFileSystem
    implements EntropyInjectingFileSystem {
        private DisabledEntropyFS() {
        }

        public String getEntropyInjectionKey() {
            return null;
        }

        public String generateEntropy() {
            return null;
        }
    }
}

