/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.testutils.ScheduledTask;
import org.apache.flink.runtime.scheduler.adaptive.DefaultStateTransitionManager;
import org.apache.flink.runtime.scheduler.adaptive.StateTransitionManager;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultStateTransitionManagerTest {
    DefaultStateTransitionManagerTest() {
    }

    @Test
    void testTriggerWithoutChangeEventNoopInCooldownPhase() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext().withDesiredResources();
        DefaultStateTransitionManager testInstance = ctx.createTestInstanceInCooldownPhase();
        DefaultStateTransitionManagerTest.triggerWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Cooldown.class);
    }

    @Test
    void testTriggerWithoutChangeEventNoopInIdlingPhase() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext().withDesiredResources();
        DefaultStateTransitionManager testInstance = ctx.createTestInstanceThatPassedCooldownPhase();
        DefaultStateTransitionManagerTest.triggerWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Idling.class);
    }

    @Test
    void testTriggerWithoutChangeEventNoopInTransitioningPhase() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext().withDesiredResources();
        DefaultStateTransitionManager testInstance = ctx.createTestInstanceInTransitioningPhase();
        DefaultStateTransitionManagerTest.triggerWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Transitioning.class);
    }

    @Test
    void testStateTransitionRightAfterCooldown() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext().withDesiredResources();
        DefaultStateTransitionManager testInstance = ctx.createTestInstanceInCooldownPhase();
        DefaultStateTransitionManagerTest.changeWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Cooldown.class);
        DefaultStateTransitionManagerTest.triggerWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Cooldown.class);
        ctx.transitionToInclusiveCooldownEnd();
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Cooldown.class);
        testInstance.onTrigger();
        ctx.passTime(Duration.ofMillis(1L));
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Stabilizing.class);
        testInstance.onTrigger();
        DefaultStateTransitionManagerTest.assertFinalStateTransitionHappened(ctx, testInstance);
    }

    @Test
    void testDesiredChangeInCooldownPhase() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext().withDesiredResources();
        DefaultStateTransitionManager testInstance = ctx.createTestInstanceInCooldownPhase();
        DefaultStateTransitionManagerTest.changeWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Cooldown.class);
        DefaultStateTransitionManagerTest.triggerWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Cooldown.class);
        ctx.transitionOutOfCooldownPhase();
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Stabilizing.class);
        testInstance.onTrigger();
        DefaultStateTransitionManagerTest.assertFinalStateTransitionHappened(ctx, testInstance);
    }

    @Test
    void testDesiredChangeInIdlingPhase() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext().withDesiredResources();
        DefaultStateTransitionManager testInstance = ctx.createTestInstanceThatPassedCooldownPhase();
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Idling.class);
        testInstance.onChange();
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Stabilizing.class);
        testInstance.onTrigger();
        DefaultStateTransitionManagerTest.assertFinalStateTransitionHappened(ctx, testInstance);
    }

    @Test
    void testDesiredChangeInStabilizedPhase() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext().withSufficientResources();
        DefaultStateTransitionManager testInstance = ctx.createTestInstanceInStabilizedPhase();
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Stabilized.class);
        DefaultStateTransitionManagerTest.withDesiredChange(ctx, testInstance);
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Stabilized.class);
        testInstance.onTrigger();
        DefaultStateTransitionManagerTest.assertFinalStateTransitionHappened(ctx, testInstance);
    }

    @Test
    void testDesiredResourcesInStabilizingPhaseAfterMaxTriggerDelay() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext().withSufficientResources().withMaxTriggerDelay(Duration.ofSeconds(10L));
        DefaultStateTransitionManager testInstance = ctx.createTestInstance(manager -> {
            manager.onChange();
            ctx.transitionOutOfCooldownPhase();
        });
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Stabilizing.class);
        ctx.passMaxDelayTriggerTimeout();
        DefaultStateTransitionManagerTest.withDesiredChange(ctx, testInstance);
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Stabilizing.class);
        ctx.passMaxDelayTriggerTimeout();
        DefaultStateTransitionManagerTest.assertFinalStateTransitionHappened(ctx, testInstance);
    }

    @Test
    void testNoResourcesChangeInCooldownPhase() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext();
        DefaultStateTransitionManager testInstance = ctx.createTestInstanceInCooldownPhase();
        DefaultStateTransitionManagerTest.changeWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Cooldown.class);
        DefaultStateTransitionManagerTest.triggerWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Cooldown.class);
        ctx.transitionOutOfCooldownPhase();
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Idling.class);
    }

    @Test
    void testNoResourcesChangeInIdlingPhase() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext();
        DefaultStateTransitionManager testInstance = ctx.createTestInstanceThatPassedCooldownPhase();
        DefaultStateTransitionManagerTest.changeWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Idling.class);
        DefaultStateTransitionManagerTest.triggerWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Idling.class);
    }

    @Test
    void testSufficientResourcesInStabilizingPhaseAfterMaxTriggerDelay() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext().withSufficientResources().withMaxTriggerDelay(Duration.ofSeconds(10L));
        DefaultStateTransitionManager testInstance = ctx.createTestInstance(manager -> {
            manager.onChange();
            ctx.transitionOutOfCooldownPhase();
        });
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Stabilizing.class);
        ctx.passMaxDelayTriggerTimeout();
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Stabilizing.class);
    }

    @Test
    void testSufficientResourcesInStabilizedPhaseAfterMaxTriggerDelay() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext().withSufficientResources();
        DefaultStateTransitionManager testInstance = ctx.createTestInstanceInStabilizedPhase();
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Stabilized.class);
        ctx.passMaxDelayTriggerTimeout();
        DefaultStateTransitionManagerTest.assertFinalStateTransitionHappened(ctx, testInstance);
    }

    @Test
    void testSufficientChangeInCooldownPhase() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext().withSufficientResources();
        DefaultStateTransitionManager testInstance = ctx.createTestInstanceInCooldownPhase();
        DefaultStateTransitionManagerTest.changeWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Cooldown.class);
        DefaultStateTransitionManagerTest.triggerWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Cooldown.class);
        ctx.transitionOutOfCooldownPhase();
        DefaultStateTransitionManagerTest.triggerWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Stabilizing.class);
        ctx.passResourceStabilizationTimeout();
        testInstance.onTrigger();
        DefaultStateTransitionManagerTest.assertFinalStateTransitionHappened(ctx, testInstance);
    }

    @Test
    void testSufficientChangeInIdlingPhase() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext().withSufficientResources();
        DefaultStateTransitionManager testInstance = ctx.createTestInstanceThatPassedCooldownPhase();
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Idling.class);
        testInstance.onChange();
        DefaultStateTransitionManagerTest.triggerWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Stabilizing.class);
        ctx.passResourceStabilizationTimeout();
        testInstance.onTrigger();
        DefaultStateTransitionManagerTest.assertFinalStateTransitionHappened(ctx, testInstance);
    }

    @Test
    void testSufficientChangeInStabilizedPhase() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext().withSufficientResources();
        DefaultStateTransitionManager testInstance = ctx.createTestInstanceInStabilizedPhase();
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Stabilized.class);
        testInstance.onTrigger();
        DefaultStateTransitionManagerTest.assertFinalStateTransitionHappened(ctx, testInstance);
    }

    @Test
    void testSufficientChangeWithSubsequentDesiredChangeInStabilizingPhase() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext().withSufficientResources();
        DefaultStateTransitionManager testInstance = ctx.createTestInstanceThatPassedCooldownPhase();
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Idling.class);
        testInstance.onChange();
        DefaultStateTransitionManagerTest.triggerWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Stabilizing.class);
        DefaultStateTransitionManagerTest.withDesiredChange(ctx, testInstance);
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Stabilizing.class);
        testInstance.onTrigger();
        DefaultStateTransitionManagerTest.assertFinalStateTransitionHappened(ctx, testInstance);
    }

    @Test
    void testRevokedChangeInStabilizingPhaseWithSubsequentSufficientChangeInStabilizedPhase() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext().withSufficientResources();
        DefaultStateTransitionManager testInstance = ctx.createTestInstanceThatPassedCooldownPhase();
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Idling.class);
        testInstance.onChange();
        DefaultStateTransitionManagerTest.triggerWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Stabilizing.class);
        ctx.withRevokeResources();
        DefaultStateTransitionManagerTest.changeWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Stabilizing.class);
        DefaultStateTransitionManagerTest.triggerWithoutPhaseMove(ctx, testInstance, DefaultStateTransitionManager.Stabilizing.class);
        ctx.passResourceStabilizationTimeout();
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Stabilized.class);
        DefaultStateTransitionManagerTest.withSufficientChange(ctx, testInstance);
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Stabilized.class);
        testInstance.onTrigger();
        DefaultStateTransitionManagerTest.assertFinalStateTransitionHappened(ctx, testInstance);
    }

    @Test
    void testRevokedChangeInStabilizedPhase() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext().withSufficientResources();
        DefaultStateTransitionManager testInstance = ctx.createTestInstanceInStabilizedPhase();
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Stabilized.class);
        ctx.withRevokeResources();
        testInstance.onTrigger();
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, DefaultStateTransitionManager.Idling.class);
    }

    @Test
    void testScheduledTaskBeingIgnoredAfterStateChanged() {
        TestingStateTransitionManagerContext ctx = TestingStateTransitionManagerContext.stableContext();
        DefaultStateTransitionManager testInstance = ctx.createTestInstanceInStabilizedPhase();
        AtomicBoolean callbackCalled = new AtomicBoolean();
        testInstance.scheduleFromNow(() -> callbackCalled.set(true), Duration.ZERO, (DefaultStateTransitionManager.Phase)new TestPhase());
        ctx.triggerOutdatedTasks();
        Assertions.assertThat((AtomicBoolean)callbackCalled).isFalse();
    }

    private static void assertPhaseWithoutStateTransition(TestingStateTransitionManagerContext ctx, DefaultStateTransitionManager testInstance, Class<? extends DefaultStateTransitionManager.Phase> expectedPhase) {
        Assertions.assertThat((boolean)ctx.stateTransitionWasTriggered()).isFalse();
        Assertions.assertThat((Object)testInstance.getPhase()).isInstanceOf(expectedPhase);
    }

    private static void assertFinalStateTransitionHappened(TestingStateTransitionManagerContext ctx, DefaultStateTransitionManager testInstance) {
        Assertions.assertThat((boolean)ctx.stateTransitionWasTriggered()).isTrue();
        Assertions.assertThat((Object)testInstance.getPhase()).isInstanceOf(DefaultStateTransitionManager.Transitioning.class);
    }

    private static void changeWithoutPhaseMove(TestingStateTransitionManagerContext ctx, DefaultStateTransitionManager testInstance, Class<? extends DefaultStateTransitionManager.Phase> expectedPhase) {
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, expectedPhase);
        testInstance.onChange();
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, expectedPhase);
    }

    private static void triggerWithoutPhaseMove(TestingStateTransitionManagerContext ctx, DefaultStateTransitionManager testInstance, Class<? extends DefaultStateTransitionManager.Phase> expectedPhase) {
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, expectedPhase);
        testInstance.onTrigger();
        DefaultStateTransitionManagerTest.assertPhaseWithoutStateTransition(ctx, testInstance, expectedPhase);
    }

    private static void withSufficientChange(TestingStateTransitionManagerContext ctx, DefaultStateTransitionManager testInstance) {
        ctx.withSufficientResources();
        testInstance.onChange();
    }

    private static void withDesiredChange(TestingStateTransitionManagerContext ctx, DefaultStateTransitionManager testInstance) {
        ctx.withDesiredResources();
        testInstance.onChange();
    }

    private static class TestingStateTransitionManagerContext
    implements StateTransitionManager.Context {
        private static final Duration COOLDOWN_TIMEOUT = Duration.ofHours(1L);
        private static final Duration RESOURCE_STABILIZATION_TIMEOUT = Duration.ofHours(2L);
        private static final Duration MAX_TRIGGER_DELAY = RESOURCE_STABILIZATION_TIMEOUT.plus(Duration.ofMinutes(10L));
        private final Duration cooldownTimeout = COOLDOWN_TIMEOUT;
        private final Duration resourceStabilizationTimeout = RESOURCE_STABILIZATION_TIMEOUT;
        private Duration maxTriggerDelay = MAX_TRIGGER_DELAY;
        private boolean hasSufficientResources = false;
        private boolean hasDesiredResources = false;
        private final AtomicBoolean transitionTriggered = new AtomicBoolean();
        private final SortedMap<Instant, List<ScheduledTask<Object>>> scheduledTasks = new TreeMap<Instant, List<ScheduledTask<Object>>>();
        private final Instant initializationTime = Instant.MIN;
        private Duration elapsedTime = Duration.ZERO;
        private final JobID jobId = new JobID();

        public static TestingStateTransitionManagerContext stableContext() {
            return new TestingStateTransitionManagerContext();
        }

        private TestingStateTransitionManagerContext() {
            this.withRevokeResources();
        }

        public TestingStateTransitionManagerContext withMaxTriggerDelay(Duration maxTriggerDelay) {
            this.maxTriggerDelay = maxTriggerDelay;
            return this;
        }

        public TestingStateTransitionManagerContext withRevokeResources() {
            this.hasSufficientResources = false;
            this.hasDesiredResources = false;
            return this;
        }

        public TestingStateTransitionManagerContext withDesiredResources() {
            this.hasSufficientResources = true;
            this.hasDesiredResources = true;
            return this;
        }

        public TestingStateTransitionManagerContext withSufficientResources() {
            this.hasSufficientResources = true;
            this.hasDesiredResources = false;
            return this;
        }

        public boolean hasSufficientResources() {
            return this.hasSufficientResources;
        }

        public boolean hasDesiredResources() {
            return this.hasDesiredResources;
        }

        public void transitionToSubsequentState() {
            this.transitionTriggered.set(true);
        }

        public ScheduledFuture<?> scheduleOperation(Runnable callback, Duration delay) {
            Instant triggerTime = Objects.requireNonNull(this.initializationTime).plus(this.elapsedTime).plus(delay);
            if (!this.scheduledTasks.containsKey(triggerTime)) {
                this.scheduledTasks.put(triggerTime, new ArrayList());
            }
            ScheduledTask scheduledTask = new ScheduledTask(Executors.callable(callback), delay.toMillis());
            ((List)this.scheduledTasks.get(triggerTime)).add(scheduledTask);
            return scheduledTask;
        }

        public JobID getJobId() {
            return this.jobId;
        }

        public DefaultStateTransitionManager createTestInstanceInCooldownPhase() {
            return this.createTestInstance(ignored -> this.transitionIntoCooldownTimeframe());
        }

        public DefaultStateTransitionManager createTestInstanceThatPassedCooldownPhase() {
            return this.createTestInstance(ignored -> this.transitionOutOfCooldownPhase());
        }

        public DefaultStateTransitionManager createTestInstanceInStabilizedPhase() {
            return this.createTestInstance(manager -> {
                manager.onChange();
                this.passResourceStabilizationTimeout();
            });
        }

        public DefaultStateTransitionManager createTestInstanceInTransitioningPhase() {
            return this.createTestInstance(manager -> {
                manager.onChange();
                this.passResourceStabilizationTimeout();
                manager.onTrigger();
                this.clearStateTransition();
            });
        }

        public DefaultStateTransitionManager createTestInstance(Consumer<DefaultStateTransitionManager> callback) {
            DefaultStateTransitionManager testInstance = new DefaultStateTransitionManager(this, () -> Objects.requireNonNull(this.initializationTime).plus(this.elapsedTime), this.cooldownTimeout, this.resourceStabilizationTimeout, this.maxTriggerDelay){

                public void onChange() {
                    super.onChange();
                    this.triggerOutdatedTasks();
                }

                public void onTrigger() {
                    super.onTrigger();
                    this.triggerOutdatedTasks();
                }
            };
            callback.accept(testInstance);
            return testInstance;
        }

        public void transitionIntoCooldownTimeframe() {
            this.setElapsedTime(this.cooldownTimeout.dividedBy(2L));
            this.triggerOutdatedTasks();
        }

        public void transitionOutOfCooldownPhase() {
            this.setElapsedTime(this.cooldownTimeout.plusMillis(1L));
        }

        public void passResourceStabilizationTimeout() {
            this.passTime(this.resourceStabilizationTimeout.plusMillis(1L));
        }

        public void transitionToInclusiveCooldownEnd() {
            this.setElapsedTime(this.cooldownTimeout.minusMillis(1L));
        }

        public void passMaxDelayTriggerTimeout() {
            this.passTime(this.maxTriggerDelay.plusMillis(1L));
        }

        public void passTime(Duration elapsed) {
            this.setElapsedTime(this.elapsedTime.plus(elapsed));
        }

        public void setElapsedTime(Duration elapsedTime) {
            Preconditions.checkState((this.elapsedTime.compareTo(elapsedTime) <= 0 ? 1 : 0) != 0, (Object)"The elapsed time should monotonically increase.");
            this.elapsedTime = elapsedTime;
            this.triggerOutdatedTasks();
        }

        private void triggerOutdatedTasks() {
            Instant timeOfExecution;
            while (!this.scheduledTasks.isEmpty() && !(timeOfExecution = this.scheduledTasks.firstKey()).isAfter(Objects.requireNonNull(this.initializationTime).plus(this.elapsedTime))) {
                ((List)this.scheduledTasks.remove(timeOfExecution)).forEach(ScheduledTask::execute);
            }
        }

        public boolean stateTransitionWasTriggered() {
            return this.transitionTriggered.get();
        }

        public void clearStateTransition() {
            this.transitionTriggered.set(false);
        }
    }

    private static class TestPhase
    extends DefaultStateTransitionManager.Phase {
        private TestPhase() {
            super(Instant::now, null);
        }
    }
}

