/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.io.File;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.runtime.rest.RestServerEndpointConfiguration;
import org.apache.flink.util.ConfigurationException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class RestServerEndpointConfigurationTest {
    private static final String ADDRESS = "123.123.123.123";
    private static final String BIND_ADDRESS = "023.023.023.023";
    private static final String BIND_PORT = "7282";
    private static final int CONTENT_LENGTH = 1234;

    RestServerEndpointConfigurationTest() {
    }

    @Test
    void testBasicMapping(@TempDir File file) throws ConfigurationException {
        Configuration originalConfig = new Configuration();
        originalConfig.set(RestOptions.ADDRESS, (Object)ADDRESS);
        originalConfig.set(RestOptions.BIND_ADDRESS, (Object)BIND_ADDRESS);
        originalConfig.set(RestOptions.BIND_PORT, (Object)BIND_PORT);
        originalConfig.set(RestOptions.SERVER_MAX_CONTENT_LENGTH, (Object)1234);
        originalConfig.set(WebOptions.TMP_DIR, (Object)file.getAbsolutePath());
        RestServerEndpointConfiguration result = RestServerEndpointConfiguration.fromConfiguration((Configuration)originalConfig);
        Assertions.assertThat((String)result.getRestAddress()).isEqualTo(ADDRESS);
        Assertions.assertThat((String)result.getRestBindAddress()).isEqualTo(BIND_ADDRESS);
        Assertions.assertThat((String)result.getRestBindPortRange()).isEqualTo(BIND_PORT);
        Assertions.assertThat((int)result.getMaxContentLength()).isEqualTo(1234);
        Assertions.assertThat((String)result.getUploadDir().toAbsolutePath().toString()).contains(new CharSequence[]{file.getAbsolutePath()});
    }
}

