/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.util;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.operators.util.BitSet;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class BitSetTest {
    private BitSet bitSet;
    int byteSize;
    MemorySegment memorySegment;

    BitSetTest(int byteSize) {
        this.byteSize = byteSize;
        this.memorySegment = MemorySegmentFactory.allocateUnpooledSegment((int)byteSize);
    }

    @BeforeEach
    void init() {
        this.bitSet = new BitSet(this.byteSize);
        this.bitSet.setMemorySegment(this.memorySegment, 0);
        this.bitSet.clear();
    }

    @TestTemplate
    void verifyBitSetSize1() {
        Assertions.assertThatThrownBy(() -> this.bitSet.setMemorySegment(this.memorySegment, 1)).isInstanceOf(IllegalArgumentException.class);
    }

    @TestTemplate
    void verifyBitSetSize2() {
        Assertions.assertThatThrownBy(() -> this.bitSet.setMemorySegment(null, 1)).isInstanceOf(IllegalArgumentException.class);
    }

    @TestTemplate
    void verifyBitSetSize3() {
        Assertions.assertThatThrownBy(() -> this.bitSet.setMemorySegment(this.memorySegment, -1)).isInstanceOf(IllegalArgumentException.class);
    }

    @TestTemplate
    void verifyInputIndex1() {
        Assertions.assertThatThrownBy(() -> this.bitSet.set(8 * this.byteSize)).isInstanceOf(IllegalArgumentException.class);
    }

    @TestTemplate
    void verifyInputIndex2() {
        Assertions.assertThatThrownBy(() -> this.bitSet.set(-1)).isInstanceOf(IllegalArgumentException.class);
    }

    @TestTemplate
    void testSetValues() {
        int i;
        int bitSize = this.bitSet.bitSize();
        Assertions.assertThat((int)bitSize).isEqualTo(8 * this.byteSize);
        for (i = 0; i < bitSize; ++i) {
            Assertions.assertThat((boolean)this.bitSet.get(i)).isFalse();
            if (i % 2 != 0) continue;
            this.bitSet.set(i);
        }
        for (i = 0; i < bitSize; ++i) {
            if (i % 2 == 0) {
                Assertions.assertThat((boolean)this.bitSet.get(i)).isTrue();
                continue;
            }
            Assertions.assertThat((boolean)this.bitSet.get(i)).isFalse();
        }
    }

    @Parameters(name="byte size = {0}")
    private static List<Integer> getByteSize() {
        return Arrays.asList(1000, 1024, 2019);
    }
}

