/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils.types;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.operators.testutils.types.IntList;

public class IntListSerializer
extends TypeSerializer<IntList> {
    private static final long serialVersionUID = 1L;

    public boolean isImmutableType() {
        return false;
    }

    public IntListSerializer duplicate() {
        return this;
    }

    public IntList createInstance() {
        return new IntList();
    }

    public IntList copy(IntList from) {
        return new IntList(from.getKey(), Arrays.copyOf(from.getValue(), from.getValue().length));
    }

    public IntList copy(IntList from, IntList reuse) {
        reuse.setKey(from.getKey());
        reuse.setValue(Arrays.copyOf(from.getValue(), from.getValue().length));
        return reuse;
    }

    public IntList createCopy(IntList from) {
        return new IntList(from.getKey(), from.getValue());
    }

    public void copyTo(IntList from, IntList to) {
        to.setKey(from.getKey());
        to.setValue(from.getValue());
    }

    public int getLength() {
        return -1;
    }

    public void serialize(IntList record, DataOutputView target) throws IOException {
        target.writeInt(record.getKey());
        target.writeInt(record.getValue().length);
        for (int i = 0; i < record.getValue().length; ++i) {
            target.writeInt(record.getValue()[i]);
        }
    }

    public IntList deserialize(DataInputView source) throws IOException {
        return this.deserialize(new IntList(), source);
    }

    public IntList deserialize(IntList record, DataInputView source) throws IOException {
        int key = source.readInt();
        record.setKey(key);
        int size = source.readInt();
        int[] value = new int[size];
        for (int i = 0; i < value.length; ++i) {
            value[i] = source.readInt();
        }
        record.setValue(value);
        return record;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeInt(source.readInt());
        int len = source.readInt();
        target.writeInt(len);
        for (int i = 0; i < len; ++i) {
            target.writeInt(source.readInt());
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof IntListSerializer;
    }

    public int hashCode() {
        return IntListSerializer.class.hashCode();
    }

    public TypeSerializerSnapshot<IntList> snapshotConfiguration() {
        throw new UnsupportedOperationException();
    }
}

