/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageTestUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.PartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFileWriter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class SegmentPartitionFileWriterTest {
    @TempDir
    java.nio.file.Path tempFolder;

    SegmentPartitionFileWriterTest() {
    }

    @Test
    void testWrite() throws IOException {
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
        int numSubpartitions = 5;
        int numSegments = 10;
        int numBuffersPerSegment = 10;
        int bufferSizeBytes = 3;
        Path tieredStorageDir = Path.fromLocalFile((File)this.tempFolder.toFile());
        SegmentPartitionFileWriter partitionFileWriter = new SegmentPartitionFileWriter(tieredStorageDir.getPath(), numSubpartitions);
        List<PartitionFileWriter.SubpartitionBufferContext> subpartitionBuffers = TieredStorageTestUtils.generateBuffersToWrite(numSubpartitions, numSegments, numBuffersPerSegment, bufferSizeBytes);
        partitionFileWriter.write(partitionId, subpartitionBuffers);
        partitionFileWriter.release();
        SegmentPartitionFileWriterTest.checkWrittenSegmentFiles(partitionId, numSubpartitions, numSegments, numBuffersPerSegment, bufferSizeBytes, tieredStorageDir);
    }

    private static void checkWrittenSegmentFiles(TieredStoragePartitionId partitionId, int numSubpartitions, int numSegments, int numBuffersPerSegment, int bufferSizeBytes, Path tieredStorageDir) throws IOException {
        FileSystem fs = tieredStorageDir.getFileSystem();
        Object[] partitionDirs = fs.listStatus(tieredStorageDir);
        Assertions.assertThat((Object[])partitionDirs).hasSize(1);
        Assertions.assertThat((String)partitionDirs[0].getPath().getName()).isEqualTo(TieredStorageIdMappingUtils.convertId((TieredStoragePartitionId)partitionId).toString());
        Object[] subpartitionDirs = fs.listStatus(partitionDirs[0].getPath());
        Assertions.assertThat((Object[])subpartitionDirs).hasSize(numSubpartitions);
        int expectedSegmentFileBytes = (8 + bufferSizeBytes) * numBuffersPerSegment;
        for (int i = 0; i < numSubpartitions; ++i) {
            Path subpartitionDir = subpartitionDirs[i].getPath();
            for (int j = 0; j < numSegments; ++j) {
                Path segmentFile = new Path(subpartitionDir, "seg-" + j);
                byte[] bytesRead = Files.readAllBytes(new File(segmentFile.getPath()).toPath());
                Assertions.assertThat((byte[])bytesRead).hasSize(expectedSegmentFileBytes);
            }
            Path segmentFinishDir = new Path(subpartitionDir, "FINISH");
            Assertions.assertThat((boolean)fs.exists(segmentFinishDir)).isTrue();
            Object[] segmentFinishFiles = fs.listStatus(segmentFinishDir);
            Assertions.assertThat((Object[])segmentFinishFiles).hasSize(1);
            Object segmentFinishFile = segmentFinishFiles[0];
            Assertions.assertThat((String)segmentFinishFile.getPath().getName()).isEqualTo(String.valueOf(numSegments - 1));
        }
    }
}

