/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.CompositeBuffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageTestUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.PartitionFileReader;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.PartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFileIndex;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFileReader;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFileWriter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class ProducerMergedPartitionFileReaderTest {
    private static final int DEFAULT_NUM_SUBPARTITION = 1;
    private static final int DEFAULT_SEGMENT_NUM = 1;
    private static final int DEFAULT_SEGMENT_ID = 0;
    private static final int DEFAULT_BUFFER_NUMBER = 5;
    private static final int DEFAULT_BUFFER_SIZE = 10;
    private static final String DEFAULT_TEST_FILE_NAME = "testFile";
    private static final String DEFAULT_TEST_INDEX_NAME = "testIndex";
    private static final TieredStoragePartitionId DEFAULT_PARTITION_ID = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
    private static final TieredStorageSubpartitionId DEFAULT_SUBPARTITION_ID = new TieredStorageSubpartitionId(0);
    @TempDir
    private Path tempFolder;
    private Path testFilePath;
    private ProducerMergedPartitionFileReader partitionFileReader;

    ProducerMergedPartitionFileReaderTest() {
    }

    @BeforeEach
    void before() throws ExecutionException, InterruptedException {
        Path testIndexPath = new File(this.tempFolder.toFile(), DEFAULT_TEST_INDEX_NAME).toPath();
        ProducerMergedPartitionFileIndex partitionFileIndex = new ProducerMergedPartitionFileIndex(1, testIndexPath, 256, Long.MAX_VALUE);
        this.testFilePath = new File(this.tempFolder.toFile(), DEFAULT_TEST_FILE_NAME).toPath();
        ProducerMergedPartitionFileWriter partitionFileWriter = new ProducerMergedPartitionFileWriter(this.testFilePath, partitionFileIndex);
        List<PartitionFileWriter.SubpartitionBufferContext> subpartitionBuffers = TieredStorageTestUtils.generateBuffersToWrite(1, 1, 5, 10);
        partitionFileWriter.write(DEFAULT_PARTITION_ID, subpartitionBuffers).get();
        this.partitionFileReader = new ProducerMergedPartitionFileReader(this.testFilePath, partitionFileIndex);
    }

    @Test
    void testReadBuffer() throws IOException {
        for (int bufferIndex = 0; bufferIndex < 5; ++bufferIndex) {
            List<Buffer> buffers = this.readBuffer(bufferIndex, DEFAULT_SUBPARTITION_ID);
            Assertions.assertThat(buffers).isNotNull();
            buffers.forEach(Buffer::recycleBuffer);
        }
        MemorySegment memorySegment = MemorySegmentFactory.allocateUnpooledSegment((int)10);
        Assertions.assertThat((Object)this.partitionFileReader.readBuffer(DEFAULT_PARTITION_ID, DEFAULT_SUBPARTITION_ID, 0, 6, memorySegment, FreeingBufferRecycler.INSTANCE, null, null)).isNull();
    }

    @Test
    void testGetPriority() throws IOException {
        ProducerMergedPartitionFileReader.ProducerMergedReadProgress readProgress = null;
        CompositeBuffer partialBuffer = null;
        int bufferIndex = 0;
        while (bufferIndex < 5) {
            PartitionFileReader.ReadBufferResult readBufferResult = this.readBuffer(bufferIndex, DEFAULT_SUBPARTITION_ID, (PartitionFileReader.ReadProgress)readProgress, partialBuffer);
            Assertions.assertThat((Object)readBufferResult).isNotNull();
            Assertions.assertThat((Object)readBufferResult.getReadProgress()).isInstanceOf(ProducerMergedPartitionFileReader.ProducerMergedReadProgress.class);
            readProgress = (ProducerMergedPartitionFileReader.ProducerMergedReadProgress)readBufferResult.getReadProgress();
            for (Buffer buffer : readBufferResult.getReadBuffers()) {
                if (buffer instanceof CompositeBuffer) {
                    partialBuffer = (CompositeBuffer)buffer;
                    if (partialBuffer.missingLength() != 0) continue;
                    ++bufferIndex;
                    partialBuffer.recycleBuffer();
                    partialBuffer = null;
                    continue;
                }
                ++bufferIndex;
                buffer.recycleBuffer();
            }
            long expectedBufferOffset = bufferIndex < 5 ? (readProgress == null ? 0L : readProgress.getCurrentBufferOffset()) : Long.MAX_VALUE;
            Assertions.assertThat((long)this.partitionFileReader.getPriority(DEFAULT_PARTITION_ID, DEFAULT_SUBPARTITION_ID, 0, bufferIndex, (PartitionFileReader.ReadProgress)readProgress)).isEqualTo(expectedBufferOffset);
        }
    }

    @Test
    void testReadProgress() throws IOException {
        long currentFileOffset = 0L;
        ProducerMergedPartitionFileReader.ProducerMergedReadProgress readProgress = null;
        CompositeBuffer partialBuffer = null;
        int bufferIndex = 0;
        while (bufferIndex < 5) {
            PartitionFileReader.ReadBufferResult readBufferResult = this.readBuffer(bufferIndex, DEFAULT_SUBPARTITION_ID, (PartitionFileReader.ReadProgress)readProgress, partialBuffer);
            Assertions.assertThat((Object)readBufferResult).isNotNull();
            Assertions.assertThat((Object)readBufferResult.getReadProgress()).isInstanceOf(ProducerMergedPartitionFileReader.ProducerMergedReadProgress.class);
            readProgress = (ProducerMergedPartitionFileReader.ProducerMergedReadProgress)readBufferResult.getReadProgress();
            for (Buffer buffer : readBufferResult.getReadBuffers()) {
                if (buffer instanceof CompositeBuffer) {
                    partialBuffer = (CompositeBuffer)buffer;
                    if (partialBuffer.missingLength() != 0) continue;
                    ++bufferIndex;
                    currentFileOffset += (long)(partialBuffer.readableBytes() + 8);
                    partialBuffer.recycleBuffer();
                    partialBuffer = null;
                    continue;
                }
                ++bufferIndex;
                currentFileOffset += (long)(buffer.readableBytes() + 8);
                buffer.recycleBuffer();
            }
            Assertions.assertThat((long)readProgress.getCurrentBufferOffset()).isEqualTo(currentFileOffset);
        }
    }

    @Test
    void testRelease() {
        Assertions.assertThat((boolean)this.testFilePath.toFile().exists()).isTrue();
        this.partitionFileReader.release();
        Assertions.assertThat((boolean)this.testFilePath.toFile().exists()).isFalse();
    }

    private List<Buffer> readBuffer(int bufferIndex, TieredStorageSubpartitionId subpartitionId) throws IOException {
        return this.readBuffer(bufferIndex, subpartitionId, null, null).getReadBuffers();
    }

    private PartitionFileReader.ReadBufferResult readBuffer(int bufferIndex, TieredStorageSubpartitionId subpartitionId, PartitionFileReader.ReadProgress readProgress, CompositeBuffer partialBuffer) throws IOException {
        MemorySegment memorySegment = MemorySegmentFactory.allocateUnpooledSegment((int)10);
        return this.partitionFileReader.readBuffer(DEFAULT_PARTITION_ID, subpartitionId, 0, bufferIndex, memorySegment, FreeingBufferRecycler.INSTANCE, readProgress, partialBuffer);
    }
}

