/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.net.BindException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.netty.NettyProtocol;
import org.apache.flink.runtime.io.network.netty.NettyServer;
import org.apache.flink.runtime.io.network.netty.NettyTestUtil;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.PortRange;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class NettyServerTest {
    NettyServerTest() {
    }

    @Test
    void testBindFailureDetection() {
        Exception ex = new BindException();
        Assertions.assertThat((boolean)NettyServer.isBindFailure((Throwable)ex)).isTrue();
        ex = new Exception(new BindException());
        Assertions.assertThat((boolean)NettyServer.isBindFailure((Throwable)ex)).isTrue();
        ex = new Exception();
        Assertions.assertThat((boolean)NettyServer.isBindFailure((Throwable)ex)).isFalse();
        ex = new RuntimeException();
        Assertions.assertThat((boolean)NettyServer.isBindFailure((Throwable)ex)).isFalse();
    }

    @Test
    void testStartMultipleNettyServerSameConfig() throws Exception {
        NetUtils.Port port2;
        NetUtils.Port port1 = NetUtils.getAvailablePort();
        do {
            port2 = NetUtils.getAvailablePort();
        } while (port1.getPort() == port2.getPort());
        NettyConfig config = NettyServerTest.getConfig(port1, port2);
        NettyServer nettyServer1 = new NettyServer(config);
        int listeningPort1 = nettyServer1.init((NettyProtocol)new NettyTestUtil.NoOpProtocol(), new NettyBufferPool(1));
        NettyServer nettyServer2 = new NettyServer(config);
        int listeningPort2 = nettyServer2.init((NettyProtocol)new NettyTestUtil.NoOpProtocol(), new NettyBufferPool(1));
        Assertions.assertThat((int)listeningPort1).isEqualTo(port1.getPort());
        Assertions.assertThat((int)listeningPort2).isEqualTo(port2.getPort());
    }

    private static NettyConfig getConfig(NetUtils.Port ... ports) {
        String portRangeStr = Arrays.stream(ports).map(NetUtils.Port::getPort).map(String::valueOf).collect(Collectors.joining(","));
        return new NettyConfig(InetAddress.getLoopbackAddress(), new PortRange(portRangeStr), 1024, 1, new Configuration());
    }
}

