/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import org.apache.flink.runtime.checkpoint.InflightDataRescalingDescriptorUtil;
import org.apache.flink.runtime.io.network.api.writer.SubtaskStateMapper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SubtaskStateMapperTest {
    SubtaskStateMapperTest() {
    }

    @Test
    void testFirstTaskMappingOnScaleDown() {
        Assertions.assertThat((Object)SubtaskStateMapper.FIRST.getNewToOldSubtasksMapping(3, 2)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 1, 2), InflightDataRescalingDescriptorUtil.to(new int[0])));
    }

    @Test
    void testFirstTaskMappingOnNoScale() {
        Assertions.assertThat((Object)SubtaskStateMapper.FIRST.getNewToOldSubtasksMapping(3, 3)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 1, 2), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0])));
    }

    @Test
    void testFirstTaskMappingOnScaleUp() {
        Assertions.assertThat((Object)SubtaskStateMapper.FIRST.getNewToOldSubtasksMapping(3, 4)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 1, 2), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0])));
    }

    @Test
    void testFullTaskMappingOnScaleDown() {
        Assertions.assertThat((Object)SubtaskStateMapper.FULL.getNewToOldSubtasksMapping(3, 2)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 1, 2), InflightDataRescalingDescriptorUtil.to(0, 1, 2)));
    }

    @Test
    void testFullTaskMappingOnNoScale() {
        Assertions.assertThat((Object)SubtaskStateMapper.FULL.getNewToOldSubtasksMapping(3, 3)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 1, 2), InflightDataRescalingDescriptorUtil.to(0, 1, 2), InflightDataRescalingDescriptorUtil.to(0, 1, 2)));
    }

    @Test
    void testFullTaskMappingOnScaleUp() {
        Assertions.assertThat((Object)SubtaskStateMapper.FULL.getNewToOldSubtasksMapping(3, 4)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 1, 2), InflightDataRescalingDescriptorUtil.to(0, 1, 2), InflightDataRescalingDescriptorUtil.to(0, 1, 2), InflightDataRescalingDescriptorUtil.to(0, 1, 2)));
    }

    @Test
    void testRangeSelectorTaskMappingOnScaleDown() {
        Assertions.assertThat((Object)SubtaskStateMapper.RANGE.getNewToOldSubtasksMapping(3, 2)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 1), InflightDataRescalingDescriptorUtil.to(1, 2)));
        Assertions.assertThat((Object)SubtaskStateMapper.RANGE.getNewToOldSubtasksMapping(10, 2)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 1, 2, 3, 4), InflightDataRescalingDescriptorUtil.to(5, 6, 7, 8, 9)));
        Assertions.assertThat((Object)SubtaskStateMapper.RANGE.getNewToOldSubtasksMapping(10, 1)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(new int[][]{InflightDataRescalingDescriptorUtil.to(0, 1, 2, 3, 4, 5, 6, 7, 8, 9)}));
    }

    @Test
    void testRangeSelectorTaskMappingOnNoScale() {
        Assertions.assertThat((Object)SubtaskStateMapper.RANGE.getNewToOldSubtasksMapping(3, 3)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(1), InflightDataRescalingDescriptorUtil.to(2)));
    }

    @Test
    void testRangeSelectorTaskMappingOnScaleUp() {
        Assertions.assertThat((Object)SubtaskStateMapper.RANGE.getNewToOldSubtasksMapping(3, 4)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(0, 1), InflightDataRescalingDescriptorUtil.to(1, 2), InflightDataRescalingDescriptorUtil.to(2)));
        Assertions.assertThat((Object)SubtaskStateMapper.RANGE.getNewToOldSubtasksMapping(3, 7)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(0, 1), InflightDataRescalingDescriptorUtil.to(1), InflightDataRescalingDescriptorUtil.to(1, 2), InflightDataRescalingDescriptorUtil.to(2), InflightDataRescalingDescriptorUtil.to(2)));
    }

    @Test
    void testRoundRobinTaskMappingOnScaleDown() {
        Assertions.assertThat((Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(10, 4)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 4, 8), InflightDataRescalingDescriptorUtil.to(1, 5, 9), InflightDataRescalingDescriptorUtil.to(2, 6), InflightDataRescalingDescriptorUtil.to(3, 7)));
        Assertions.assertThat((Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(5, 4)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 4), InflightDataRescalingDescriptorUtil.to(1), InflightDataRescalingDescriptorUtil.to(2), InflightDataRescalingDescriptorUtil.to(3)));
        Assertions.assertThat((Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(5, 2)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 2, 4), InflightDataRescalingDescriptorUtil.to(1, 3)));
        Assertions.assertThat((Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(5, 1)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(new int[][]{InflightDataRescalingDescriptorUtil.to(0, 1, 2, 3, 4)}));
    }

    @Test
    void testRoundRobinTaskMappingOnNoScale() {
        Assertions.assertThat((Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(10, 10)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(1), InflightDataRescalingDescriptorUtil.to(2), InflightDataRescalingDescriptorUtil.to(3), InflightDataRescalingDescriptorUtil.to(4), InflightDataRescalingDescriptorUtil.to(5), InflightDataRescalingDescriptorUtil.to(6), InflightDataRescalingDescriptorUtil.to(7), InflightDataRescalingDescriptorUtil.to(8), InflightDataRescalingDescriptorUtil.to(9)));
        Assertions.assertThat((Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(5, 5)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(1), InflightDataRescalingDescriptorUtil.to(2), InflightDataRescalingDescriptorUtil.to(3), InflightDataRescalingDescriptorUtil.to(4)));
        Assertions.assertThat((Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(1, 1)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(new int[][]{InflightDataRescalingDescriptorUtil.to(0)}));
    }

    @Test
    void testRoundRobinTaskMappingOnScaleUp() {
        Assertions.assertThat((Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(4, 10)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(1), InflightDataRescalingDescriptorUtil.to(2), InflightDataRescalingDescriptorUtil.to(3), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0])));
        Assertions.assertThat((Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(4, 5)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(1), InflightDataRescalingDescriptorUtil.to(2), InflightDataRescalingDescriptorUtil.to(3), InflightDataRescalingDescriptorUtil.to(new int[0])));
        Assertions.assertThat((Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(2, 5)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(1), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0])));
        Assertions.assertThat((Object)SubtaskStateMapper.ROUND_ROBIN.getNewToOldSubtasksMapping(1, 5)).isEqualTo((Object)InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0])));
    }
}

