/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.EndOfData;
import org.apache.flink.runtime.io.network.api.StopMode;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.SpillingAdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.api.writer.AbstractCollectingResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.plugable.DeserializationDelegate;
import org.apache.flink.runtime.plugable.NonReusingDeserializationDelegate;
import org.apache.flink.util.Preconditions;

public class RecordOrEventCollectingResultPartitionWriter<T>
extends AbstractCollectingResultPartitionWriter {
    private final Collection<Object> output;
    private final NonReusingDeserializationDelegate<T> delegate;
    private final RecordDeserializer<DeserializationDelegate<T>> deserializer = new SpillingAdaptiveSpanningRecordDeserializer(new String[]{System.getProperty("java.io.tmpdir")});
    private final boolean collectNetworkEvents;

    public RecordOrEventCollectingResultPartitionWriter(Collection<Object> output, TypeSerializer<T> serializer) {
        this(output, serializer, false);
    }

    public RecordOrEventCollectingResultPartitionWriter(Collection<Object> output, TypeSerializer<T> serializer, boolean collectNetworkEvents) {
        this.output = (Collection)Preconditions.checkNotNull(output);
        this.delegate = new NonReusingDeserializationDelegate((TypeSerializer)Preconditions.checkNotNull(serializer));
        this.collectNetworkEvents = collectNetworkEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcastEvent(AbstractEvent event, boolean isPriorityEvent) throws IOException {
        try (BufferConsumer eventBufferConsumer = EventSerializer.toBufferConsumer((AbstractEvent)event, (boolean)isPriorityEvent);){
            Buffer buffer = eventBufferConsumer.build();
            try {
                AbstractEvent deserializedEvent = EventSerializer.fromBuffer((Buffer)buffer, (ClassLoader)this.getClass().getClassLoader());
                this.output.add(deserializedEvent);
            }
            finally {
                buffer.recycleBuffer();
            }
        }
    }

    @Override
    protected void deserializeBuffer(Buffer buffer) throws IOException {
        RecordDeserializer.DeserializationResult result;
        this.deserializer.setNextBuffer(buffer);
        do {
            if (!(result = this.deserializer.getNextRecord(this.delegate)).isFullRecord()) continue;
            this.output.add(this.delegate.getInstance());
        } while (!result.isBufferConsumed());
    }

    @Override
    public void notifyEndOfData(StopMode mode) throws IOException {
        if (this.collectNetworkEvents) {
            this.broadcastEvent((AbstractEvent)new EndOfData(mode), false);
        }
    }
}

