/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.highavailability.ClientHighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.highavailability.TestingClientHAServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;
import org.apache.flink.runtime.rest.util.NoOpFatalErrorHandler;
import org.apache.flink.runtime.rpc.AddressResolution;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.rpc.RpcSystemUtils;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.Executors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HighAvailabilityServicesUtilsTest
extends TestLogger {
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testCreateCustomHAServices() throws Exception {
        Configuration config = new Configuration();
        TestingHighAvailabilityServices haServices = new TestingHighAvailabilityServices();
        TestHAFactory.haServices = haServices;
        Executor executor = Executors.directExecutor();
        config.set(HighAvailabilityOptions.HA_MODE, (Object)TestHAFactory.class.getName());
        HighAvailabilityServices actualHaServices = HighAvailabilityServicesUtils.createAvailableOrEmbeddedServices((Configuration)config, (Executor)executor, (FatalErrorHandler)NoOpFatalErrorHandler.INSTANCE);
        Assert.assertSame((Object)haServices, (Object)actualHaServices);
        actualHaServices = HighAvailabilityServicesUtils.createHighAvailabilityServices((Configuration)config, (Executor)executor, (AddressResolution)AddressResolution.NO_ADDRESS_RESOLUTION, (RpcSystemUtils)RpcSystem.load(), (FatalErrorHandler)NoOpFatalErrorHandler.INSTANCE);
        Assert.assertSame((Object)haServices, (Object)actualHaServices);
    }

    @Test
    public void testCreateCustomClientHAServices() throws Exception {
        Configuration config = new Configuration();
        TestingClientHAServices clientHAServices = TestingClientHAServices.createClientHAServices();
        TestHAFactory.clientHAServices = clientHAServices;
        config.set(HighAvailabilityOptions.HA_MODE, (Object)TestHAFactory.class.getName());
        ClientHighAvailabilityServices actualClientHAServices = HighAvailabilityServicesUtils.createClientHAService((Configuration)config, (FatalErrorHandler)NoOpFatalErrorHandler.INSTANCE);
        Assert.assertSame((Object)clientHAServices, (Object)actualClientHAServices);
    }

    @Test(expected=Exception.class)
    public void testCustomHAServicesFactoryNotDefined() throws Exception {
        Configuration config = new Configuration();
        Executor executor = Executors.directExecutor();
        config.set(HighAvailabilityOptions.HA_MODE, (Object)HighAvailabilityMode.FACTORY_CLASS.name().toLowerCase());
        HighAvailabilityServicesUtils.createAvailableOrEmbeddedServices((Configuration)config, (Executor)executor, (FatalErrorHandler)NoOpFatalErrorHandler.INSTANCE);
    }

    @Test
    public void testGetClusterHighAvailableStoragePath() throws IOException {
        String haStorageRootDirectory = temporaryFolder.newFolder().getAbsolutePath();
        String clusterId = UUID.randomUUID().toString();
        Configuration configuration = new Configuration();
        configuration.set(HighAvailabilityOptions.HA_STORAGE_PATH, (Object)haStorageRootDirectory);
        configuration.set(HighAvailabilityOptions.HA_CLUSTER_ID, (Object)clusterId);
        Path clusterHighAvailableStoragePath = HighAvailabilityServicesUtils.getClusterHighAvailableStoragePath((Configuration)configuration);
        Path expectedPath = new Path(haStorageRootDirectory, clusterId);
        Assert.assertThat((Object)clusterHighAvailableStoragePath, (Matcher)CoreMatchers.is((Object)expectedPath));
    }

    public static class TestHAFactory
    implements HighAvailabilityServicesFactory {
        static HighAvailabilityServices haServices;
        static ClientHighAvailabilityServices clientHAServices;

        public HighAvailabilityServices createHAServices(Configuration configuration, Executor executor) {
            return haServices;
        }

        public ClientHighAvailabilityServices createClientHAServices(Configuration configuration) throws Exception {
            return clientHAServices;
        }
    }
}

