/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.AbstractHaServices;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.jobmanager.ExecutionPlanStore;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.testutils.TestingJobResultStore;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.concurrent.Executors;
import org.apache.flink.util.function.RunnableWithException;
import org.apache.flink.util.function.ThrowingConsumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AbstractHaServicesTest {
    AbstractHaServicesTest() {
    }

    @Test
    void testCloseAndCleanupAllDataDeletesBlobsAfterCleaningUpHAData() throws Exception {
        ArrayDeque<CloseOperations> closeOperations = new ArrayDeque<CloseOperations>(3);
        TestingBlobStoreService testingBlobStoreService = new TestingBlobStoreService(closeOperations);
        TestingHaServices haServices = new TestingHaServices(new Configuration(), Executors.directExecutor(), testingBlobStoreService, closeOperations, () -> closeOperations.offer(CloseOperations.HA_CLEANUP), (ThrowingConsumer<JobID, Exception>)((ThrowingConsumer)ignored -> {}));
        haServices.closeWithOptionalClean(true);
        Assertions.assertThat(closeOperations).contains((Object[])new CloseOperations[]{CloseOperations.HA_CLEANUP, CloseOperations.HA_CLOSE, CloseOperations.BLOB_CLEANUP});
    }

    @Test
    void testCloseAndCleanupAllDataDoesNotDeleteBlobsIfCleaningUpHADataFails() throws Exception {
        ArrayDeque<CloseOperations> closeOperations = new ArrayDeque<CloseOperations>(3);
        TestingBlobStoreService testingBlobStoreService = new TestingBlobStoreService(closeOperations);
        TestingHaServices haServices = new TestingHaServices(new Configuration(), Executors.directExecutor(), testingBlobStoreService, closeOperations, () -> {
            throw new FlinkException("test exception");
        }, (ThrowingConsumer<JobID, Exception>)((ThrowingConsumer)ignored -> {}));
        Assertions.assertThatThrownBy(() -> haServices.closeWithOptionalClean(true)).isInstanceOf(FlinkException.class);
        Assertions.assertThat(closeOperations).contains((Object[])new CloseOperations[]{CloseOperations.HA_CLOSE, CloseOperations.BLOB_CLOSE});
    }

    @Test
    void testCleanupJobData() throws Exception {
        ArrayDeque<CloseOperations> closeOperations = new ArrayDeque<CloseOperations>(3);
        TestingBlobStoreService testingBlobStoreService = new TestingBlobStoreService(closeOperations);
        JobID jobID = new JobID();
        CompletableFuture jobCleanupFuture = new CompletableFuture();
        TestingHaServices haServices = new TestingHaServices(new Configuration(), Executors.directExecutor(), testingBlobStoreService, closeOperations, () -> {}, (ThrowingConsumer<JobID, Exception>)((ThrowingConsumer)jobCleanupFuture::complete));
        haServices.globalCleanupAsync(jobID, Executors.directExecutor()).join();
        JobID jobIDCleaned = (JobID)jobCleanupFuture.get();
        Assertions.assertThat((Comparable)jobIDCleaned).isEqualTo((Object)jobID);
    }

    private static final class TestingHaServices
    extends AbstractHaServices {
        private final Queue<? super CloseOperations> closeOperations;
        private final RunnableWithException internalCleanupRunnable;
        private final ThrowingConsumer<JobID, Exception> internalJobCleanupConsumer;

        private TestingHaServices(Configuration config, Executor ioExecutor, BlobStoreService blobStoreService, Queue<? super CloseOperations> closeOperations, RunnableWithException internalCleanupRunnable, ThrowingConsumer<JobID, Exception> internalJobCleanupConsumer) {
            super(config, listener -> null, ioExecutor, blobStoreService, (JobResultStore)TestingJobResultStore.builder().withMarkResultAsCleanConsumer(ignoredJobId -> {
                throw new AssertionError((Object)"Marking the job as clean shouldn't happen in the HaServices cleanup");
            }).build());
            this.closeOperations = closeOperations;
            this.internalCleanupRunnable = internalCleanupRunnable;
            this.internalJobCleanupConsumer = internalJobCleanupConsumer;
        }

        protected LeaderRetrievalService createLeaderRetrievalService(String leaderName) {
            throw new UnsupportedOperationException("Not supported by this test implementation.");
        }

        protected CheckpointRecoveryFactory createCheckpointRecoveryFactory() {
            throw new UnsupportedOperationException("Not supported by this test implementation.");
        }

        protected ExecutionPlanStore createExecutionPlanStore() throws Exception {
            throw new UnsupportedOperationException("Not supported by this test implementation.");
        }

        protected void internalClose() {
            this.closeOperations.offer(CloseOperations.HA_CLOSE);
        }

        protected void internalCleanup() throws Exception {
            this.internalCleanupRunnable.run();
        }

        protected void internalCleanupJobData(JobID jobID) throws Exception {
            this.internalJobCleanupConsumer.accept((Object)jobID);
        }

        protected String getLeaderPathForResourceManager() {
            throw new UnsupportedOperationException("Not supported by this test implementation.");
        }

        protected String getLeaderPathForDispatcher() {
            throw new UnsupportedOperationException("Not supported by this test implementation.");
        }

        protected String getLeaderPathForJobManager(JobID jobID) {
            throw new UnsupportedOperationException("Not supported by this test implementation.");
        }

        protected String getLeaderPathForRestServer() {
            throw new UnsupportedOperationException("Not supported by this test implementation.");
        }
    }

    private static final class TestingBlobStoreService
    implements BlobStoreService {
        private final Queue<CloseOperations> closeOperations;

        private TestingBlobStoreService(Queue<CloseOperations> closeOperations) {
            this.closeOperations = closeOperations;
        }

        public void cleanupAllData() {
            this.closeOperations.offer(CloseOperations.BLOB_CLEANUP);
        }

        public void close() throws IOException {
            this.closeOperations.offer(CloseOperations.BLOB_CLOSE);
        }

        public boolean put(File localFile, JobID jobId, BlobKey blobKey) throws IOException {
            return false;
        }

        public boolean delete(JobID jobId, BlobKey blobKey) {
            return false;
        }

        public boolean deleteAll(JobID jobId) {
            return false;
        }

        public boolean get(JobID jobId, BlobKey blobKey, File localFile) throws IOException {
            return false;
        }
    }

    private static enum CloseOperations {
        HA_CLEANUP,
        HA_CLOSE,
        BLOB_CLEANUP,
        BLOB_CLOSE;

    }
}

