/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.List;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.runtime.executiongraph.IndexRangeUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class IndexRangeUtilTest {
    IndexRangeUtilTest() {
    }

    @Test
    void testMergeIndexRanges() {
        List emptyList = List.of();
        List emptyResult = IndexRangeUtil.mergeIndexRanges(emptyList);
        Assertions.assertThat((List)emptyResult).isEmpty();
        List<IndexRange> singleRangeList = List.of(new IndexRange(5, 10));
        List singleRangeResult = IndexRangeUtil.mergeIndexRanges(singleRangeList);
        Assertions.assertThat((List)singleRangeResult).containsExactly((Object[])new IndexRange[]{new IndexRange(5, 10)});
        List<IndexRange> overlappingRangesList = List.of(new IndexRange(5, 10), new IndexRange(8, 12));
        List overlappingRangesResult = IndexRangeUtil.mergeIndexRanges(overlappingRangesList);
        Assertions.assertThat((List)overlappingRangesResult).containsExactly((Object[])new IndexRange[]{new IndexRange(5, 12)});
        List<IndexRange> nonOverlappingRangesList = List.of(new IndexRange(1, 5), new IndexRange(10, 15));
        List nonOverlappingRangesResult = IndexRangeUtil.mergeIndexRanges(nonOverlappingRangesList);
        Assertions.assertThat((List)nonOverlappingRangesResult).containsExactly((Object[])new IndexRange[]{new IndexRange(1, 5), new IndexRange(10, 15)});
        List<IndexRange> touchingRangesList = List.of(new IndexRange(1, 5), new IndexRange(6, 10));
        List touchingRangesResult = IndexRangeUtil.mergeIndexRanges(touchingRangesList);
        Assertions.assertThat((List)touchingRangesResult).containsExactly((Object[])new IndexRange[]{new IndexRange(1, 10)});
        List<IndexRange> mixedRangesList = List.of(new IndexRange(1, 3), new IndexRange(2, 6), new IndexRange(8, 10), new IndexRange(15, 18), new IndexRange(19, 20));
        List mixedRangesResult = IndexRangeUtil.mergeIndexRanges(mixedRangesList);
        Assertions.assertThat((List)mixedRangesResult).containsExactly((Object[])new IndexRange[]{new IndexRange(1, 6), new IndexRange(8, 10), new IndexRange(15, 20)});
    }
}

