/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateByteBuffer;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateSerializerImpl;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ChannelStateSerializerImplTest {
    ChannelStateSerializerImplTest() {
    }

    @Test
    void testReadWrite() throws IOException {
        byte[] data = ChannelStateSerializerImplTest.generateData(123);
        ChannelStateSerializerImpl serializer = new ChannelStateSerializerImpl();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(data.length);){
            this.write(data, serializer, baos);
            this.readAndCheck(data, serializer, new ByteArrayInputStream(baos.toByteArray()));
        }
    }

    @Test
    void testReadWriteWithMultipleBuffers() throws IOException {
        int bufSize = 10;
        int[] numBuffersToWriteAtOnce = new int[]{0, 1, 2, 3};
        byte[] data = ChannelStateSerializerImplTest.generateData(bufSize);
        ChannelStateSerializerImpl s = new ChannelStateSerializerImpl();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        s.writeHeader(out);
        for (int count : numBuffersToWriteAtOnce) {
            Object[] buffers = new Buffer[count];
            Arrays.fill(buffers, this.getBuffer(data));
            s.writeData(out, (Buffer[])buffers);
        }
        out.close();
        ChannelStateSerializerImpl d = new ChannelStateSerializerImpl();
        ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
        d.readHeader((InputStream)is);
        for (int count : numBuffersToWriteAtOnce) {
            int expected = bufSize * count;
            Assertions.assertThat((int)d.readLength((InputStream)is)).isEqualTo(expected);
            byte[] readBuf = new byte[expected];
            Assertions.assertThat((int)d.readData((InputStream)is, ChannelStateByteBuffer.wrap((byte[])readBuf), Integer.MAX_VALUE)).isEqualTo(expected);
            for (int i = 0; i < count; ++i) {
                Assertions.assertThat((byte[])Arrays.copyOfRange(readBuf, i * bufSize, (i + 1) * bufSize)).isEqualTo((Object)data);
            }
        }
    }

    @Test
    void testReadToBufferBuilder() throws IOException {
        byte[] data = ChannelStateSerializerImplTest.generateData(100);
        BufferBuilder bufferBuilder = new BufferBuilder(MemorySegmentFactory.allocateUnpooledSegment((int)data.length, null), FreeingBufferRecycler.INSTANCE);
        BufferConsumer bufferConsumer = bufferBuilder.createBufferConsumer();
        new ChannelStateSerializerImpl().readData((InputStream)new ByteArrayInputStream(data), ChannelStateByteBuffer.wrap((BufferBuilder)bufferBuilder), Integer.MAX_VALUE);
        Assertions.assertThat((boolean)bufferBuilder.isFinished()).isFalse();
        bufferBuilder.finish();
        Buffer buffer = bufferConsumer.build();
        Assertions.assertThat((int)buffer.readableBytes()).isEqualTo(data.length);
        byte[] actual = new byte[buffer.readableBytes()];
        buffer.asByteBuf().readBytes(actual);
        Assertions.assertThat((byte[])actual).isEqualTo((Object)data);
    }

    private NetworkBuffer getBuffer(byte[] data) {
        NetworkBuffer buffer = new NetworkBuffer(MemorySegmentFactory.allocateUnpooledSegment((int)data.length, null), FreeingBufferRecycler.INSTANCE);
        buffer.writeBytes(data);
        return buffer;
    }

    private byte[] readBytes(NetworkBuffer buffer) {
        byte[] tmp = new byte[buffer.readableBytes()];
        buffer.readBytes(tmp);
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(byte[] data, ChannelStateSerializerImpl serializer, OutputStream baos) throws IOException {
        DataOutputStream out = new DataOutputStream(baos);
        serializer.writeHeader(out);
        NetworkBuffer buffer = new NetworkBuffer(MemorySegmentFactory.allocateUnpooledSegment((int)data.length), FreeingBufferRecycler.INSTANCE);
        try {
            buffer.writeBytes(data);
            serializer.writeData(out, new Buffer[]{buffer});
            out.flush();
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndCheck(byte[] data, ChannelStateSerializerImpl serializer, ByteArrayInputStream is) throws IOException {
        serializer.readHeader((InputStream)is);
        int size = serializer.readLength((InputStream)is);
        Assertions.assertThat((byte[])data).hasSize(size);
        NetworkBuffer buffer = new NetworkBuffer(MemorySegmentFactory.allocateUnpooledSegment((int)data.length), FreeingBufferRecycler.INSTANCE);
        try {
            int read = serializer.readData((InputStream)is, ChannelStateByteBuffer.wrap((Buffer)buffer), size);
            Assertions.assertThat((int)read).isEqualTo(size);
            Assertions.assertThat((byte[])this.readBytes(buffer)).isEqualTo((Object)data);
        }
        finally {
            buffer.release();
        }
    }

    static byte[] generateData(int len) {
        byte[] bytes = new byte[len];
        new Random().nextBytes(bytes);
        return bytes;
    }
}

