/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.blob.BlobCachePutTest;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobKeyTest;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerDeleteTest;
import org.apache.flink.runtime.blob.BlobServerGetTest;
import org.apache.flink.runtime.blob.BlobServerPutTest;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.TestingBlobUtils;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.concurrent.FutureUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class BlobCacheDeleteTest {
    @TempDir
    private Path tempDir;
    private final Random rnd = new Random();

    BlobCacheDeleteTest() {
    }

    @Test
    void testDeleteTransient1() throws IOException {
        this.testDelete(null, new JobID());
    }

    @Test
    void testDeleteTransient2() throws IOException {
        this.testDelete(new JobID(), null);
    }

    @Test
    void testDeleteTransient3() throws IOException {
        this.testDelete(null, null);
    }

    @Test
    void testDeleteTransient4() throws IOException {
        this.testDelete(new JobID(), new JobID());
    }

    @Test
    void testDeleteTransient5() throws IOException {
        JobID jobId = new JobID();
        this.testDelete(jobId, jobId);
    }

    private void testDelete(@Nullable JobID jobId1, @Nullable JobID jobId2) throws IOException {
        Tuple2<BlobServer, BlobCacheService> serverAndCache = TestingBlobUtils.createServerAndCache(this.tempDir);
        try (BlobServer server = (BlobServer)serverAndCache.f0;
             BlobCacheService cache = (BlobCacheService)serverAndCache.f1;){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            byte[] data2 = Arrays.copyOf(data, data.length);
            data2[0] = (byte)(data2[0] ^ 1);
            TransientBlobKey key1 = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId1, data, BlobKey.BlobType.TRANSIENT_BLOB);
            Assertions.assertThat((Comparable)key1).isNotNull();
            TransientBlobKey key2a = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId2, data, BlobKey.BlobType.TRANSIENT_BLOB);
            Assertions.assertThat((Comparable)key2a).isNotNull();
            BlobKeyTest.verifyKeyDifferentHashEquals((BlobKey)key1, (BlobKey)key2a);
            TransientBlobKey key2b = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId2, data2, BlobKey.BlobType.TRANSIENT_BLOB);
            Assertions.assertThat((Comparable)key2b).isNotNull();
            BlobKeyTest.verifyKeyDifferentHashDifferent((BlobKey)key1, (BlobKey)key2b);
            Assertions.assertThat((boolean)BlobServerDeleteTest.delete((BlobService)cache, jobId1, key1)).isTrue();
            Assertions.assertThat((File)server.getStorageLocation(jobId1, (BlobKey)key1)).exists();
            Assertions.assertThat((boolean)server.deleteInternal(jobId1, key1)).isTrue();
            Assertions.assertThat((File)server.getStorageLocation(jobId1, (BlobKey)key1)).doesNotExist();
            BlobServerGetTest.verifyDeleted((BlobService)cache, jobId1, (BlobKey)key1);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, (BlobKey)key2a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, (BlobKey)key2b, data2);
            Assertions.assertThat((boolean)BlobServerDeleteTest.delete((BlobService)cache, jobId2, key2a)).isTrue();
            Assertions.assertThat((File)server.getStorageLocation(jobId2, (BlobKey)key2a)).exists();
            Assertions.assertThat((boolean)server.deleteInternal(jobId2, key2a)).isTrue();
            BlobServerGetTest.verifyDeleted((BlobService)cache, jobId2, (BlobKey)key2a);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, (BlobKey)key2b, data2);
            Assertions.assertThat((boolean)BlobServerDeleteTest.delete((BlobService)cache, jobId2, key2b)).isTrue();
            Assertions.assertThat((File)server.getStorageLocation(jobId2, (BlobKey)key2b)).exists();
            Assertions.assertThat((boolean)server.deleteInternal(jobId2, key2b)).isTrue();
            BlobServerGetTest.verifyDeleted((BlobService)cache, jobId2, (BlobKey)key2b);
        }
    }

    @Test
    void testDeleteTransientAlreadyDeletedNoJob() throws IOException {
        this.testDeleteTransientAlreadyDeleted(null);
    }

    @Test
    void testDeleteTransientAlreadyDeletedForJob() throws IOException {
        this.testDeleteTransientAlreadyDeleted(new JobID());
    }

    private void testDeleteTransientAlreadyDeleted(@Nullable JobID jobId) throws IOException {
        Tuple2<BlobServer, BlobCacheService> serverAndCache = TestingBlobUtils.createServerAndCache(this.tempDir);
        try (BlobServer server = (BlobServer)serverAndCache.f0;
             BlobCacheService cache = (BlobCacheService)serverAndCache.f1;){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            TransientBlobKey key = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId, data, BlobKey.BlobType.TRANSIENT_BLOB);
            Assertions.assertThat((Comparable)key).isNotNull();
            File blobFile = server.getStorageLocation(jobId, (BlobKey)key);
            Assertions.assertThat((boolean)blobFile.delete()).isTrue();
            Assertions.assertThat((boolean)BlobServerDeleteTest.delete((BlobService)cache, jobId, key)).isTrue();
            BlobServerGetTest.verifyDeleted((BlobService)cache, jobId, (BlobKey)key);
            Assertions.assertThat((boolean)BlobServerDeleteTest.delete((BlobService)cache, jobId, key)).isTrue();
            BlobServerGetTest.verifyDeleted((BlobService)cache, jobId, (BlobKey)key);
        }
    }

    @Tag(value="org.apache.flink.testutils.junit.FailsInGHAContainerWithRootUser")
    @Test
    void testDeleteTransientLocalFailsNoJob() throws IOException, InterruptedException {
        this.testDeleteTransientLocalFails(null);
    }

    @Tag(value="org.apache.flink.testutils.junit.FailsInGHAContainerWithRootUser")
    @Test
    void testDeleteTransientLocalFailsForJob() throws IOException, InterruptedException {
        this.testDeleteTransientLocalFails(new JobID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeleteTransientLocalFails(@Nullable JobID jobId) throws IOException, InterruptedException {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)OperatingSystem.isWindows()).as("setWritable doesn't work on Windows", new Object[0])).isFalse();
        Tuple2<BlobServer, BlobCacheService> serverAndCache = TestingBlobUtils.createServerAndCache(this.tempDir);
        File blobFile = null;
        File directory = null;
        try (BlobServer server = (BlobServer)serverAndCache.f0;
             BlobCacheService cache = (BlobCacheService)serverAndCache.f1;){
            server.start();
            try {
                byte[] data = new byte[2000000];
                this.rnd.nextBytes(data);
                TransientBlobKey key = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId, data, BlobKey.BlobType.TRANSIENT_BLOB);
                Assertions.assertThat((Comparable)key).isNotNull();
                BlobServerPutTest.verifyContents((BlobService)cache, jobId, (BlobKey)key, data);
                blobFile = cache.getTransientBlobService().getStorageLocation(jobId, (BlobKey)key);
                directory = blobFile.getParentFile();
                Assertions.assertThat((boolean)blobFile.setWritable(false, false)).isTrue();
                Assertions.assertThat((boolean)directory.setWritable(false, false)).isTrue();
                Assertions.assertThat((boolean)BlobServerDeleteTest.delete((BlobService)cache, jobId, key)).isFalse();
                BlobServerPutTest.verifyContents((BlobService)cache, jobId, (BlobKey)key, data);
                BlobCachePutTest.verifyDeletedEventually(server, jobId, new BlobKey[]{key});
            }
            finally {
                if (blobFile != null && directory != null) {
                    blobFile.setWritable(true, false);
                    directory.setWritable(true, false);
                }
            }
        }
    }

    @Test
    void testConcurrentDeleteOperationsNoJobTransient() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentDeleteOperations(null);
    }

    @Test
    void testConcurrentDeleteOperationsForJobTransient() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentDeleteOperations(new JobID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentDeleteOperations(@Nullable JobID jobId) throws IOException, InterruptedException, ExecutionException {
        int concurrentDeleteOperations = 3;
        ExecutorService executor = Executors.newFixedThreadPool(3);
        ArrayList<CompletableFuture<Void>> deleteFutures = new ArrayList<CompletableFuture<Void>>(3);
        byte[] data = new byte[]{1, 2, 3};
        Tuple2<BlobServer, BlobCacheService> serverAndCache = TestingBlobUtils.createServerAndCache(this.tempDir);
        try (BlobServer server = (BlobServer)serverAndCache.f0;
             BlobCacheService cache = (BlobCacheService)serverAndCache.f1;){
            server.start();
            TransientBlobKey blobKey = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId, data, BlobKey.BlobType.TRANSIENT_BLOB);
            Assertions.assertThat((File)server.getStorageLocation(jobId, (BlobKey)blobKey)).exists();
            for (int i = 0; i < 3; ++i) {
                CompletableFuture<Void> deleteFuture = CompletableFuture.supplyAsync(() -> {
                    try {
                        Assertions.assertThat((boolean)BlobServerDeleteTest.delete((BlobService)cache, jobId, blobKey)).isTrue();
                        Assertions.assertThat((File)cache.getTransientBlobService().getStorageLocation(jobId, (BlobKey)blobKey)).doesNotExist();
                        Assertions.assertThat((File)server.getStorageLocation(jobId, (BlobKey)blobKey)).exists();
                        return null;
                    }
                    catch (IOException e) {
                        throw new CompletionException((Throwable)new FlinkException("Could not upload blob.", (Throwable)e));
                    }
                }, executor);
                deleteFutures.add(deleteFuture);
            }
            FutureUtils.ConjunctFuture waitFuture = FutureUtils.waitForAll(deleteFutures);
            waitFuture.get();
            Assertions.assertThat((File)server.getStorageLocation(jobId, (BlobKey)blobKey)).exists();
        }
        finally {
            executor.shutdownNow();
        }
    }
}

