/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.lineage.LineageVertexProvider;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.TransformationWithLineage;
import org.apache.flink.streaming.api.transformations.WithBoundedness;
import org.apache.flink.util.Preconditions;

@Internal
public class SourceTransformation<OUT, SplitT extends SourceSplit, EnumChkT>
extends TransformationWithLineage<OUT>
implements WithBoundedness {
    private final Source<OUT, SplitT, EnumChkT> source;
    private final WatermarkStrategy<OUT> watermarkStrategy;
    private ChainingStrategy chainingStrategy = ChainingStrategy.DEFAULT_CHAINING_STRATEGY;
    @Nullable
    private String coordinatorListeningID;

    public SourceTransformation(String name, Source<OUT, SplitT, EnumChkT> source, WatermarkStrategy<OUT> watermarkStrategy, TypeInformation<OUT> outputType, int parallelism) {
        super(name, outputType, parallelism);
        this.source = source;
        this.watermarkStrategy = watermarkStrategy;
        this.extractLineageVertex();
    }

    public SourceTransformation(String name, Source<OUT, SplitT, EnumChkT> source, WatermarkStrategy<OUT> watermarkStrategy, TypeInformation<OUT> outputType, int parallelism, boolean parallelismConfigured) {
        super(name, outputType, parallelism, parallelismConfigured);
        this.source = source;
        this.watermarkStrategy = watermarkStrategy;
        this.extractLineageVertex();
    }

    public Source<OUT, SplitT, EnumChkT> getSource() {
        return this.source;
    }

    public WatermarkStrategy<OUT> getWatermarkStrategy() {
        return this.watermarkStrategy;
    }

    @Override
    public Boundedness getBoundedness() {
        return this.source.getBoundedness();
    }

    protected List<Transformation<?>> getTransitivePredecessorsInternal() {
        return Collections.singletonList(this);
    }

    public List<Transformation<?>> getInputs() {
        return Collections.emptyList();
    }

    @Override
    public void setChainingStrategy(ChainingStrategy chainingStrategy) {
        this.chainingStrategy = (ChainingStrategy)((Object)Preconditions.checkNotNull((Object)((Object)chainingStrategy)));
    }

    public ChainingStrategy getChainingStrategy() {
        return this.chainingStrategy;
    }

    public void setCoordinatorListeningID(@Nullable String coordinatorListeningID) {
        this.coordinatorListeningID = coordinatorListeningID;
    }

    @Nullable
    public String getCoordinatorListeningID() {
        return this.coordinatorListeningID;
    }

    private void extractLineageVertex() {
        if (this.source instanceof LineageVertexProvider) {
            this.setLineageVertex(((LineageVertexProvider)this.source).getLineageVertex());
        }
    }
}

