/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.stats;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.runtime.metrics.DescriptiveStatisticsHistogram;
import org.apache.flink.runtime.util.stats.StatsSummarySnapshot;

public class StatsSummary
implements Serializable {
    private static final long serialVersionUID = 1769601903483446707L;
    private long min;
    private long max;
    private long sum;
    private long count;
    @Nullable
    private final Histogram histogram;

    public StatsSummary() {
        this(0);
    }

    public StatsSummary(int histogramWindowSize) {
        this.histogram = histogramWindowSize > 0 ? new DescriptiveStatisticsHistogram(histogramWindowSize) : null;
    }

    public void add(long value) {
        if (value >= 0L) {
            if (this.count > 0L) {
                this.min = Math.min(this.min, value);
                this.max = Math.max(this.max, value);
            } else {
                this.min = value;
                this.max = value;
            }
            ++this.count;
            this.sum += value;
            if (this.histogram != null) {
                this.histogram.update(value);
            }
        }
    }

    public StatsSummarySnapshot createSnapshot() {
        return new StatsSummarySnapshot(this.min, this.max, this.sum, this.count, this.histogram == null ? null : this.histogram.getStatistics());
    }

    public long getMinimum() {
        return this.min;
    }

    public long getMaximum() {
        return this.max;
    }

    public long getSum() {
        return this.sum;
    }

    public long getCount() {
        return this.count;
    }

    public long getAverage() {
        if (this.count == 0L) {
            return 0L;
        }
        return this.sum / this.count;
    }
}

