/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.InternalKeyContext;
import org.apache.flink.runtime.state.IterableStateSnapshot;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.KeyGroupRangeOffsets;
import org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.StateEntry;
import org.apache.flink.runtime.state.StateSnapshotKeyGroupReader;
import org.apache.flink.runtime.state.StateSnapshotRestore;
import org.apache.flink.runtime.state.StateTransformationFunction;
import org.apache.flink.runtime.state.heap.StateMap;
import org.apache.flink.runtime.state.heap.StateTableByKeyGroupReaders;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.util.Preconditions;

public abstract class StateTable<K, N, S>
implements StateSnapshotRestore,
Iterable<StateEntry<K, N, S>> {
    protected final InternalKeyContext<K> keyContext;
    protected RegisteredKeyValueStateBackendMetaInfo<N, S> metaInfo;
    protected final TypeSerializer<K> keySerializer;
    protected final KeyGroupRange keyGroupRange;
    protected final StateMap<K, N, S>[] keyGroupedStateMaps;

    public StateTable(InternalKeyContext<K> keyContext, RegisteredKeyValueStateBackendMetaInfo<N, S> metaInfo, TypeSerializer<K> keySerializer) {
        this.keyContext = (InternalKeyContext)Preconditions.checkNotNull(keyContext);
        this.metaInfo = (RegisteredKeyValueStateBackendMetaInfo)Preconditions.checkNotNull(metaInfo);
        this.keySerializer = (TypeSerializer)Preconditions.checkNotNull(keySerializer);
        this.keyGroupRange = keyContext.getKeyGroupRange();
        StateMap[] state = new StateMap[keyContext.getKeyGroupRange().getNumberOfKeyGroups()];
        this.keyGroupedStateMaps = state;
        for (int i = 0; i < this.keyGroupedStateMaps.length; ++i) {
            this.keyGroupedStateMaps[i] = this.createStateMap();
        }
    }

    protected abstract StateMap<K, N, S> createStateMap();

    @Override
    @Nonnull
    public abstract IterableStateSnapshot<K, N, S> stateSnapshot();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int count = 0;
        for (StateMap<K, N, S> stateMap : this.keyGroupedStateMaps) {
            count += stateMap.size();
        }
        return count;
    }

    public S get(N namespace) {
        return this.get(this.keyContext.getCurrentKey(), this.keyContext.getCurrentKeyGroupIndex(), namespace);
    }

    public boolean containsKey(N namespace) {
        return this.containsKey(this.keyContext.getCurrentKey(), this.keyContext.getCurrentKeyGroupIndex(), namespace);
    }

    public void put(N namespace, S state) {
        this.put(this.keyContext.getCurrentKey(), this.keyContext.getCurrentKeyGroupIndex(), namespace, state);
    }

    public void remove(N namespace) {
        this.remove(this.keyContext.getCurrentKey(), this.keyContext.getCurrentKeyGroupIndex(), namespace);
    }

    public S removeAndGetOld(N namespace) {
        return this.removeAndGetOld(this.keyContext.getCurrentKey(), this.keyContext.getCurrentKeyGroupIndex(), namespace);
    }

    public <T> void transform(N namespace, T value, StateTransformationFunction<S, T> transformation) throws Exception {
        K key = this.keyContext.getCurrentKey();
        this.checkKeyNamespacePreconditions(key, namespace);
        int keyGroup = this.keyContext.getCurrentKeyGroupIndex();
        this.getMapForKeyGroup(keyGroup).transform(key, namespace, value, transformation);
    }

    public <T> void transformAll(T value, StateTransformationFunction<S, T> transformation) throws Exception {
        for (StateMap stateMap : this.keyGroupedStateMaps) {
            List entries = StreamSupport.stream(Spliterators.spliteratorUnknownSize(stateMap.iterator(), 0), false).collect(Collectors.toList());
            for (StateEntry entry : entries) {
                stateMap.transform(entry.getKey(), entry.getNamespace(), value, transformation);
            }
        }
    }

    public S get(K key, N namespace) {
        int keyGroup = KeyGroupRangeAssignment.assignToKeyGroup(key, this.keyContext.getNumberOfKeyGroups());
        return this.get(key, keyGroup, namespace);
    }

    public Stream<K> getKeys(N namespace) {
        return Arrays.stream(this.keyGroupedStateMaps).flatMap(stateMap -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(stateMap.iterator(), 0), false)).filter(entry -> entry.getNamespace().equals(namespace)).map(StateEntry::getKey);
    }

    public Stream<Tuple2<K, N>> getKeysAndNamespaces() {
        return Arrays.stream(this.keyGroupedStateMaps).flatMap(stateMap -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(stateMap.iterator(), 0), false)).map(entry -> Tuple2.of(entry.getKey(), entry.getNamespace()));
    }

    public InternalKvState.StateIncrementalVisitor<K, N, S> getStateIncrementalVisitor(int recommendedMaxNumberOfReturnedRecords) {
        return new StateEntryIterator(recommendedMaxNumberOfReturnedRecords);
    }

    private S get(K key, int keyGroupIndex, N namespace) {
        this.checkKeyNamespacePreconditions(key, namespace);
        return this.getMapForKeyGroup(keyGroupIndex).get(key, namespace);
    }

    private boolean containsKey(K key, int keyGroupIndex, N namespace) {
        this.checkKeyNamespacePreconditions(key, namespace);
        return this.getMapForKeyGroup(keyGroupIndex).containsKey(key, namespace);
    }

    private void checkKeyNamespacePreconditions(K key, N namespace) {
        Preconditions.checkNotNull(key, (String)"No key set. This method should not be called outside of a keyed context.");
        Preconditions.checkNotNull(namespace, (String)"Provided namespace is null.");
    }

    private void remove(K key, int keyGroupIndex, N namespace) {
        this.checkKeyNamespacePreconditions(key, namespace);
        this.getMapForKeyGroup(keyGroupIndex).remove(key, namespace);
    }

    private S removeAndGetOld(K key, int keyGroupIndex, N namespace) {
        this.checkKeyNamespacePreconditions(key, namespace);
        return this.getMapForKeyGroup(keyGroupIndex).removeAndGetOld(key, namespace);
    }

    @VisibleForTesting
    public StateMap<K, N, S>[] getState() {
        return this.keyGroupedStateMaps;
    }

    public int getKeyGroupOffset() {
        return this.keyGroupRange.getStartKeyGroup();
    }

    public StateMap<K, N, S> getMapForKeyGroup(int keyGroupIndex) {
        int pos = this.indexToOffset(keyGroupIndex);
        if (pos >= 0 && pos < this.keyGroupedStateMaps.length) {
            return this.keyGroupedStateMaps[pos];
        }
        throw KeyGroupRangeOffsets.newIllegalKeyGroupException(keyGroupIndex, this.keyGroupRange);
    }

    private int indexToOffset(int index) {
        return index - this.getKeyGroupOffset();
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializer<S> getStateSerializer() {
        return this.metaInfo.getStateSerializer();
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.metaInfo.getNamespaceSerializer();
    }

    public RegisteredKeyValueStateBackendMetaInfo<N, S> getMetaInfo() {
        return this.metaInfo;
    }

    public void setMetaInfo(RegisteredKeyValueStateBackendMetaInfo<N, S> metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void put(K key, int keyGroup, N namespace, S state) {
        this.checkKeyNamespacePreconditions(key, namespace);
        this.getMapForKeyGroup(keyGroup).put(key, namespace, state);
    }

    @Override
    public Iterator<StateEntry<K, N, S>> iterator() {
        return Arrays.stream(this.keyGroupedStateMaps).filter(Objects::nonNull).flatMap(stateMap -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(stateMap.iterator(), 0), false)).iterator();
    }

    @VisibleForTesting
    public int sizeOfNamespace(Object namespace) {
        int count = 0;
        for (StateMap<K, N, S> stateMap : this.keyGroupedStateMaps) {
            count += stateMap.sizeOfNamespace(namespace);
        }
        return count;
    }

    @Override
    @Nonnull
    public StateSnapshotKeyGroupReader keyGroupReader(int readVersion) {
        return StateTableByKeyGroupReaders.readerForVersion(this, readVersion);
    }

    class StateEntryIterator
    implements InternalKvState.StateIncrementalVisitor<K, N, S> {
        final int recommendedMaxNumberOfReturnedRecords;
        int keyGroupIndex;
        InternalKvState.StateIncrementalVisitor<K, N, S> stateIncrementalVisitor;

        StateEntryIterator(int recommendedMaxNumberOfReturnedRecords) {
            this.recommendedMaxNumberOfReturnedRecords = recommendedMaxNumberOfReturnedRecords;
            this.keyGroupIndex = 0;
            this.next();
        }

        private void next() {
            while (this.keyGroupIndex < StateTable.this.keyGroupedStateMaps.length) {
                StateMap stateMap;
                InternalKvState.StateIncrementalVisitor visitor;
                if (!(visitor = (stateMap = StateTable.this.keyGroupedStateMaps[this.keyGroupIndex++]).getStateIncrementalVisitor(this.recommendedMaxNumberOfReturnedRecords)).hasNext()) continue;
                this.stateIncrementalVisitor = visitor;
                return;
            }
        }

        @Override
        public boolean hasNext() {
            while (this.stateIncrementalVisitor == null || !this.stateIncrementalVisitor.hasNext()) {
                InternalKvState.StateIncrementalVisitor visitor;
                if (this.keyGroupIndex == StateTable.this.keyGroupedStateMaps.length) {
                    return false;
                }
                if (!(visitor = StateTable.this.keyGroupedStateMaps[this.keyGroupIndex++].getStateIncrementalVisitor(this.recommendedMaxNumberOfReturnedRecords)).hasNext()) continue;
                this.stateIncrementalVisitor = visitor;
                break;
            }
            return true;
        }

        @Override
        public Collection<StateEntry<K, N, S>> nextEntries() {
            if (!this.hasNext()) {
                return null;
            }
            return this.stateIncrementalVisitor.nextEntries();
        }

        @Override
        public void remove(StateEntry<K, N, S> stateEntry) {
            StateTable.this.keyGroupedStateMaps[this.keyGroupIndex - 1].remove(stateEntry.getKey(), stateEntry.getNamespace());
        }

        @Override
        public void update(StateEntry<K, N, S> stateEntry, S newValue) {
            StateTable.this.keyGroupedStateMaps[this.keyGroupIndex - 1].put(stateEntry.getKey(), stateEntry.getNamespace(), newValue);
        }
    }
}

