/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.adaptivebatch.ExecutionPlanSchedulingContext;
import org.apache.flink.util.Preconditions;

public final class NonAdaptiveExecutionPlanSchedulingContext
implements ExecutionPlanSchedulingContext {
    public static final NonAdaptiveExecutionPlanSchedulingContext INSTANCE = new NonAdaptiveExecutionPlanSchedulingContext();

    private NonAdaptiveExecutionPlanSchedulingContext() {
    }

    @Override
    public int getConsumersParallelism(Function<JobVertexID, Integer> executionJobVertexParallelismRetriever, IntermediateDataSet intermediateDataSet) {
        List<JobEdge> consumers = intermediateDataSet.getConsumers();
        List consumerVertices = consumers.stream().map(JobEdge::getTarget).map(JobVertex::getID).collect(Collectors.toList());
        Preconditions.checkState((!consumers.isEmpty() ? 1 : 0) != 0);
        int consumersParallelism = executionJobVertexParallelismRetriever.apply(consumers.get(0).getTarget().getID());
        if (consumers.size() == 1) {
            return consumersParallelism;
        }
        for (JobVertexID jobVertexId : consumerVertices) {
            Preconditions.checkState((consumersParallelism == executionJobVertexParallelismRetriever.apply(jobVertexId) ? 1 : 0) != 0, (Object)"Consumers must have the same parallelism.");
        }
        return consumersParallelism;
    }

    @Override
    public int getConsumersMaxParallelism(Function<JobVertexID, Integer> executionJobVertexMaxParallelismRetriever, IntermediateDataSet intermediateDataSet) {
        List<JobEdge> consumers = intermediateDataSet.getConsumers();
        List consumerVertices = consumers.stream().map(JobEdge::getTarget).map(JobVertex::getID).collect(Collectors.toList());
        Preconditions.checkState((!consumers.isEmpty() ? 1 : 0) != 0);
        int consumersMaxParallelism = executionJobVertexMaxParallelismRetriever.apply(consumers.get(0).getTarget().getID());
        if (consumers.size() == 1) {
            return consumersMaxParallelism;
        }
        for (JobVertexID jobVertexId : consumerVertices) {
            Preconditions.checkState((consumersMaxParallelism == executionJobVertexMaxParallelismRetriever.apply(jobVertexId) ? 1 : 0) != 0, (Object)"Consumers must have the same max parallelism.");
        }
        return consumersMaxParallelism;
    }

    @Override
    public int getPendingOperatorCount() {
        return 0;
    }

    @Override
    public String getStreamGraphJson() {
        return null;
    }
}

