/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.disk;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.disk.BatchShuffleReadBufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferCompressor;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFile;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFileIndex;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFileReader;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.TieredStorageNettyService;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageConsumerSpec;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemorySpec;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.NoOpMasterAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierConsumerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierMasterAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierProducerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleDescriptor;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.disk.DiskTierConsumerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.disk.DiskTierProducerAgent;
import org.apache.flink.runtime.util.ConfigurationParserUtils;
import org.apache.flink.util.Preconditions;

public class DiskTierFactory
implements TierFactory {
    private static final int DEFAULT_DISK_TIER_NUM_BYTES_PER_SEGMENT = 524288;
    private static final int DEFAULT_REGION_GROUP_SIZE_IN_BYTES = 1024;
    private static final int DEFAULT_MAX_CACHED_BYTES_BEFORE_FLUSH = 524288;
    private static final long DEFAULT_MAX_REGION_NUM_RETAINED_IN_MEMORY = 0x100000L;
    private static final float DEFAULT_MIN_RESERVE_DISK_SPACE_FRACTION = 0.05f;
    private static final int DEFAULT_DISK_TIER_EXCLUSIVE_BUFFERS = 1;
    private static final Duration DEFAULT_DISK_TIER_BUFFER_REQUEST_TIMEOUT = Duration.ofMinutes(5L);
    private int bufferSizeBytes = -1;

    @Override
    public void setup(Configuration configuration) {
        this.bufferSizeBytes = ConfigurationParserUtils.getPageSize(configuration);
    }

    @Override
    public TieredStorageMemorySpec getMasterAgentMemorySpec() {
        return new TieredStorageMemorySpec(TieredStorageUtils.getDiskTierName(), 0);
    }

    @Override
    public TieredStorageMemorySpec getProducerAgentMemorySpec() {
        return new TieredStorageMemorySpec(TieredStorageUtils.getDiskTierName(), 1);
    }

    @Override
    public TieredStorageMemorySpec getConsumerAgentMemorySpec() {
        return new TieredStorageMemorySpec(TieredStorageUtils.getDiskTierName(), 0);
    }

    @Override
    public TierMasterAgent createMasterAgent(TieredStorageResourceRegistry resourceRegistry) {
        return NoOpMasterAgent.INSTANCE;
    }

    @Override
    public TierProducerAgent createProducerAgent(int numPartitions, int numSubpartitions, TieredStoragePartitionId partitionId, String dataFileBasePath, boolean isBroadcastOnly, TieredStorageMemoryManager storageMemoryManager, TieredStorageNettyService nettyService, TieredStorageResourceRegistry resourceRegistry, BatchShuffleReadBufferPool bufferPool, ScheduledExecutorService ioExecutor, List<TierShuffleDescriptor> shuffleDescriptors, int maxRequestedBuffers, @Nullable BufferCompressor bufferCompressor) {
        Preconditions.checkState((this.bufferSizeBytes > 0 ? 1 : 0) != 0);
        ProducerMergedPartitionFileIndex partitionFileIndex = new ProducerMergedPartitionFileIndex(isBroadcastOnly ? 1 : numSubpartitions, Paths.get(dataFileBasePath + ".tier-storage.index", new String[0]), 1024, 0x100000L);
        Path dataFilePath = Paths.get(dataFileBasePath + ".tier-storage.data", new String[0]);
        ProducerMergedPartitionFileWriter partitionFileWriter = ProducerMergedPartitionFile.createPartitionFileWriter(dataFilePath, partitionFileIndex);
        ProducerMergedPartitionFileReader partitionFileReader = ProducerMergedPartitionFile.createPartitionFileReader(dataFilePath, partitionFileIndex);
        return new DiskTierProducerAgent(partitionId, numSubpartitions, 524288, this.bufferSizeBytes, 524288, dataFilePath, 0.05f, isBroadcastOnly, partitionFileWriter, partitionFileReader, storageMemoryManager, nettyService, resourceRegistry, bufferPool, ioExecutor, maxRequestedBuffers, DEFAULT_DISK_TIER_BUFFER_REQUEST_TIMEOUT, bufferCompressor);
    }

    @Override
    public TierConsumerAgent createConsumerAgent(List<TieredStorageConsumerSpec> tieredStorageConsumerSpecs, List<TierShuffleDescriptor> shuffleDescriptors, TieredStorageNettyService nettyService) {
        return new DiskTierConsumerAgent(tieredStorageConsumerSpecs, nettyService);
    }

    @Override
    public String identifier() {
        return "disk";
    }
}

