/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.handlers.JarListInfo;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;

public class JarListHandler
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, JarListInfo, EmptyMessageParameters> {
    private static final File[] EMPTY_FILES_ARRAY = new File[0];
    private final CompletableFuture<String> localAddressFuture;
    private final File jarDir;
    private final Configuration configuration;
    private final Executor executor;

    public JarListHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JarListInfo, EmptyMessageParameters> messageHeaders, CompletableFuture<String> localAddressFuture, File jarDir, Configuration configuration, Executor executor) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.localAddressFuture = localAddressFuture;
        this.jarDir = Objects.requireNonNull(jarDir);
        this.configuration = configuration;
        this.executor = Objects.requireNonNull(executor);
    }

    protected CompletableFuture<JarListInfo> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        String localAddress;
        Preconditions.checkState((boolean)this.localAddressFuture.isDone());
        try {
            localAddress = this.localAddressFuture.get();
        }
        catch (Exception e) {
            return FutureUtils.completedExceptionally((Throwable)e);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                File[] list = this.getJarFiles();
                ArrayList<JarListInfo.JarFileInfo> jarFileList = new ArrayList<JarListInfo.JarFileInfo>(list.length);
                for (File f : list) {
                    String name;
                    String id = f.getName();
                    int startIndex = id.indexOf("_");
                    if (startIndex < 0 || (name = id.substring(startIndex + 1)).length() < 5 || !name.endsWith(".jar")) continue;
                    ArrayList<JarListInfo.JarEntryInfo> jarEntryList = new ArrayList<JarListInfo.JarEntryInfo>();
                    String[] classes = new String[]{};
                    try (JarFile jar = new JarFile(f);){
                        Manifest manifest = jar.getManifest();
                        String assemblerClass = null;
                        if (manifest != null && (assemblerClass = manifest.getMainAttributes().getValue("program-class")) == null) {
                            assemblerClass = manifest.getMainAttributes().getValue("Main-Class");
                        }
                        if (assemblerClass != null) {
                            classes = assemblerClass.split(",");
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    for (String clazz : classes) {
                        clazz = clazz.trim();
                        try (PackagedProgram program = PackagedProgram.newBuilder().setJarFile(f).setEntryPointClassName(clazz).setConfiguration(this.configuration).build();){
                            JarListInfo.JarEntryInfo jarEntryInfo = new JarListInfo.JarEntryInfo(clazz, program.getDescription());
                            jarEntryList.add(jarEntryInfo);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    jarFileList.add(new JarListInfo.JarFileInfo(id, name, f.lastModified(), jarEntryList));
                }
                return new JarListInfo(localAddress, jarFileList);
            }
            catch (Exception e) {
                throw new CompletionException((Throwable)new FlinkException("Failed to fetch jar list.", (Throwable)e));
            }
        }, this.executor);
    }

    private File[] getJarFiles() {
        File[] list = this.jarDir.listFiles((dir, name) -> name.endsWith(".jar"));
        if (list == null) {
            this.log.warn("Jar upload dir {} does not exist, or had been deleted externally. Previously uploaded jars are no longer available.", (Object)this.jarDir);
            return EMPTY_FILES_ARRAY;
        }
        Arrays.sort(list, (f1, f2) -> Long.compare(f2.lastModified(), f1.lastModified()));
        return list;
    }
}

