/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.serialization;

import java.io.Serializable;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.ContainerFormats;
import org.apache.pekko.remote.serialization.ThrowableNotSerializableException;
import org.apache.pekko.remote.serialization.WrappedPayloadSupport;
import org.apache.pekko.serialization.DisabledJavaSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua!\u0002\b\u0010\u0001MI\u0002\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\t\u000b!\u0002A\u0011A\u0015\t\u0011A\u0001\u0001R1A\u0005\n5Bqa\r\u0001C\u0002\u0013%A\u0007\u0003\u00049\u0001\u0001\u0006I!\u000e\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019\t\u0005\u0001)A\u0005w!)!\t\u0001C\u0001\u0007\")\u0001\f\u0001C\u00013\")q\r\u0001C\u0005Q\")\u0011\u0010\u0001C\u0001u\")Q\u0010\u0001C\u0001}\"9\u0011q\u0001\u0001\u0005\n\u0005%!\u0001\u0005+ie><\u0018M\u00197f'V\u0004\bo\u001c:u\u0015\t\u0001\u0012#A\u0007tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0003%M\taA]3n_R,'B\u0001\u000b\u0016\u0003\u0015\u0001Xm[6p\u0015\t1r#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00021\u0005\u0019qN]4\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-\u0001\u0004tsN$X-\\\u0002\u0001!\t\u0019c%D\u0001%\u0015\t)3#A\u0003bGR|'/\u0003\u0002(I\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\u00061A(\u001b8jiz\"\"A\u000b\u0017\u0011\u0005-\u0002Q\"A\b\t\u000b\u0001\u0012\u0001\u0019\u0001\u0012\u0016\u00039\u0002\"aL\u0019\u000e\u0003AR!\u0001E\n\n\u0005I\u0002$!D*fe&\fG.\u001b>bi&|g.\u0001\bqCfdw.\u00193TkB\u0004xN\u001d;\u0016\u0003U\u0002\"a\u000b\u001c\n\u0005]z!!F,sCB\u0004X\r\u001a)bs2|\u0017\rZ*vaB|'\u000f^\u0001\u0010a\u0006LHn\\1e'V\u0004\bo\u001c:uA\u0005\u0019An\\4\u0016\u0003m\u0002\"\u0001P \u000e\u0003uR!AP\n\u0002\u000b\u00154XM\u001c;\n\u0005\u0001k$A\u0004'pO\u001eLgnZ!eCB$XM]\u0001\u0005Y><\u0007%\u0001\ntKJL\u0017\r\\5{KRC'o\\<bE2,GC\u0001#K!\rYRiR\u0005\u0003\rr\u0011Q!\u0011:sCf\u0004\"a\u0007%\n\u0005%c\"\u0001\u0002\"zi\u0016DQa\u0013\u0005A\u00021\u000b\u0011\u0001\u001e\t\u0003\u001bVs!AT*\u000f\u0005=\u0013V\"\u0001)\u000b\u0005E\u000b\u0013A\u0002\u001fs_>$h(C\u0001\u001e\u0013\t!F$A\u0004qC\u000e\\\u0017mZ3\n\u0005Y;&!\u0003+ie><\u0018M\u00197f\u0015\t!F$A\nu_B\u0013x\u000e^8ck\u001a$\u0006N]8xC\ndW\r\u0006\u0002[MB\u00111l\u0019\b\u00039\u0002t!!\u00180\u000e\u0003EI!aX\t\u0002!\r{g\u000e^1j]\u0016\u0014hi\u001c:nCR\u001c\u0018BA1c\u0003%!\u0006N]8xC\ndWM\u0003\u0002`#%\u0011A-\u001a\u0002\b\u0005VLG\u000eZ3s\u0015\t\t'\rC\u0003L\u0013\u0001\u0007A*\u0001\rti\u0006\u001c7\u000e\u0016:bG\u0016,E.Z7f]R\u0014U/\u001b7eKJ$\"![8\u0011\u0005)lgB\u0001/l\u0013\ta'-A\tTi\u0006\u001c7\u000e\u0016:bG\u0016,E.Z7f]RL!\u0001\u001a8\u000b\u00051\u0014\u0007\"\u00029\u000b\u0001\u0004\t\u0018\u0001B3mK6\u0004\"A]<\u000e\u0003MT!\u0001^;\u0002\t1\fgn\u001a\u0006\u0002m\u0006!!.\u0019<b\u0013\tA8OA\tTi\u0006\u001c7\u000e\u0016:bG\u0016,E.Z7f]R\fA\u0003Z3tKJL\u0017\r\\5{KRC'o\\<bE2,GC\u0001'|\u0011\u0015a8\u00021\u0001E\u0003\u0015\u0011\u0017\u0010^3t\u0003U1'o\\7Qe>$xNY;g)\"\u0014xn^1cY\u0016$\"\u0001T@\t\u000f\u0005\u0005A\u00021\u0001\u0002\u0004\u00051\u0001O]8u_R\u00032\u0001XA\u0003\u0013\t1&-\u0001\tgS2d\u0017J\\*uC\u000e\\GK]1dKR1\u00111BA\t\u0003'\u00012aGA\u0007\u0013\r\ty\u0001\b\u0002\u0005+:LG\u000fC\u0004\u0002\u00025\u0001\r!a\u0001\t\u000b-k\u0001\u0019\u0001'")
public class ThrowableSupport {
    private Serialization serialization;
    private final ExtendedActorSystem system;
    private final WrappedPayloadSupport payloadSupport;
    private final LoggingAdapter log;
    private volatile boolean bitmap$0;

    private Serialization serialization$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply(this.system);
                this.bitmap$0 = true;
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        if (!this.bitmap$0) {
            return this.serialization$lzycompute();
        }
        return this.serialization;
    }

    private WrappedPayloadSupport payloadSupport() {
        return this.payloadSupport;
    }

    private LoggingAdapter log() {
        return this.log;
    }

    public byte[] serializeThrowable(Throwable t) {
        return this.toProtobufThrowable(t).build().toByteArray();
    }

    public ContainerFormats.Throwable.Builder toProtobufThrowable(Throwable t) {
        StackTraceElement[] stackTrace;
        ContainerFormats.Throwable.Builder b = ContainerFormats.Throwable.newBuilder().setClassName(t.getClass().getName());
        if (t.getMessage() != null) {
            b.setMessage(t.getMessage());
        }
        if (t.getCause() != null) {
            b.setCause(this.payloadSupport().payloadBuilder(t.getCause()));
        }
        if ((stackTrace = t.getStackTrace()) != null) {
            for (int i = 0; i < stackTrace.length; ++i) {
                b.addStackTrace(this.stackTraceElementBuilder(stackTrace[i]));
            }
        }
        return b;
    }

    private ContainerFormats.StackTraceElement.Builder stackTraceElementBuilder(StackTraceElement elem) {
        ContainerFormats.StackTraceElement.Builder builder = ContainerFormats.StackTraceElement.newBuilder().setClassName(elem.getClassName()).setMethodName(elem.getMethodName()).setLineNumber(elem.getLineNumber());
        String fileName = elem.getFileName();
        if (fileName != null) {
            return builder.setFileName(fileName);
        }
        return builder.setFileName("");
    }

    public Throwable deserializeThrowable(byte[] bytes) {
        return this.fromProtobufThrowable(ContainerFormats.Throwable.parseFrom(bytes));
    }

    public Throwable fromProtobufThrowable(ContainerFormats.Throwable protoT) {
        Throwable throwable;
        block8: {
            String className = protoT.getClassName();
            try {
                Try try_;
                Try try_2;
                Class clazz = this.system.dynamicAccess().getClassFor(className, ClassTag$.MODULE$.apply(Throwable.class)).get();
                if (this.serialization().serializerFor(clazz) instanceof DisabledJavaSerializer) {
                    ThrowableNotSerializableException notSerializableException = new ThrowableNotSerializableException(protoT.getMessage(), "unknown");
                    this.log().debug("Couldn't deserialize [{}] because Java serialization is disabled. Fallback to ThrowableNotSerializableException. {}", notSerializableException.originalClassName(), notSerializableException.originalMessage());
                    throwable = notSerializableException;
                    break block8;
                }
                if (protoT.hasCause()) {
                    Throwable cause = (Throwable)this.payloadSupport().deserializePayload(protoT.getCause());
                    try_2 = this.system.dynamicAccess().createInstanceFor(className, new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(String.class), protoT.getMessage())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Throwable.class), cause)), Nil$.MODULE$)), ClassTag$.MODULE$.apply(Throwable.class));
                } else {
                    try_2 = try_ = this.system.dynamicAccess().createInstanceFor(clazz, new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(String.class), protoT.getMessage())), Nil$.MODULE$), ClassTag$.MODULE$.apply(Throwable.class));
                }
                if (try_ instanceof Success) {
                    Throwable t = (Throwable)((Success)try_).value();
                    this.fillInStackTrace(protoT, t);
                    throwable = t;
                    break block8;
                }
                if (try_ instanceof Failure) {
                    Throwable e = ((Failure)try_).exception();
                    throwable = new ThrowableNotSerializableException(protoT.getMessage(), className, e);
                    break block8;
                }
                throw new MatchError(try_);
            }
            catch (Throwable throwable2) {
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = option.get();
                    return new ThrowableNotSerializableException(protoT.getMessage(), className, e);
                }
                throw throwable2;
            }
        }
        return throwable;
    }

    private void fillInStackTrace(ContainerFormats.Throwable protoT, Throwable t) {
        StackTraceElement[] stackTrace = (StackTraceElement[])((TraversableOnce)((TraversableLike)package$JavaConverters$.MODULE$.asScalaBufferConverter(protoT.getStackTraceList()).asScala()).map((Function1<ContainerFormats.StackTraceElement, StackTraceElement> & Serializable & scala.Serializable)elem -> {
            String fileName = elem.getFileName();
            return new StackTraceElement(elem.getClassName(), elem.getMethodName(), fileName.length() > 0 ? fileName : null, elem.getLineNumber());
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StackTraceElement.class));
        t.setStackTrace(stackTrace);
    }

    public ThrowableSupport(ExtendedActorSystem system) {
        this.system = system;
        this.payloadSupport = new WrappedPayloadSupport(system);
        this.log = Logging$.MODULE$.apply(system, ThrowableSupport.class, LogSource$.MODULE$.fromAnyClass());
    }
}

