/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.tcp.ssl;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSession;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.remote.artery.tcp.ssl.SessionVerifier;
import org.apache.pekko.remote.artery.tcp.ssl.X509Readers$;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-4QAB\u0004\u0003\u000fUA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\u0006Y\u0001!\t!\f\u0005\u0006a\u0001!\t%\r\u0005\u0006-\u0002!\te\u0016\u0005\u00065\u0002!Ia\u0017\u0002\u0014!\u0016,'oU;cU\u0016\u001cGOV3sS\u001aLWM\u001d\u0006\u0003\u0011%\t1a]:m\u0015\tQ1\"A\u0002uGBT!\u0001D\u0007\u0002\r\u0005\u0014H/\u001a:z\u0015\tqq\"\u0001\u0004sK6|G/\u001a\u0006\u0003!E\tQ\u0001]3lW>T!AE\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0012aA8sON\u0019\u0001A\u0006\u000f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g!\tib$D\u0001\b\u0013\tyrAA\bTKN\u001c\u0018n\u001c8WKJLg-[3s\u0003=\u0001X-\u001a:DKJ$\u0018NZ5dCR,7\u0001\u0001\t\u0003G)j\u0011\u0001\n\u0006\u0003K\u0019\nAaY3si*\u0011q\u0005K\u0001\tg\u0016\u001cWO]5us*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016%\u0005=AV\u0007M\u001dDKJ$\u0018NZ5dCR,\u0017A\u0002\u001fj]&$h\b\u0006\u0002/_A\u0011Q\u0004\u0001\u0005\u0006A\t\u0001\rAI\u0001\u0014m\u0016\u0014\u0018NZ=DY&,g\u000e^*fgNLwN\u001c\u000b\u0004e\u0005[\u0005cA\f4k%\u0011A\u0007\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005YrdBA\u001c=\u001d\tA4(D\u0001:\u0015\tQ\u0014%\u0001\u0004=e>|GOP\u0005\u00023%\u0011Q\bG\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0004IA\u0005UQJ|w/\u00192mK*\u0011Q\b\u0007\u0005\u0006\u0005\u000e\u0001\raQ\u0001\tQ>\u001cHO\\1nKB\u0011A\t\u0013\b\u0003\u000b\u001a\u0003\"\u0001\u000f\r\n\u0005\u001dC\u0012A\u0002)sK\u0012,g-\u0003\u0002J\u0015\n11\u000b\u001e:j]\u001eT!a\u0012\r\t\u000b1\u001b\u0001\u0019A'\u0002\u000fM,7o]5p]B\u0011a\nV\u0007\u0002\u001f*\u0011\u0001\u0002\u0015\u0006\u0003#J\u000b1A\\3u\u0015\u0005\u0019\u0016!\u00026bm\u0006D\u0018BA+P\u0005)\u00196\u000bT*fgNLwN\\\u0001\u0014m\u0016\u0014\u0018NZ=TKJ4XM]*fgNLwN\u001c\u000b\u0004eaK\u0006\"\u0002\"\u0005\u0001\u0004\u0019\u0005\"\u0002'\u0005\u0001\u0004i\u0015A\u0006<fe&4\u0017\u0010U3fe\u000e+'\u000f^5gS\u000e\fG/Z:\u0015\u0005q\u001b\u0007cA\f4;B\u0011a,Y\u0007\u0002?*\u0011\u0001\rK\u0001\u0005Y\u0006tw-\u0003\u0002c?\nA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8\t\u000b1+\u0001\u0019A')\u0005\u0001)\u0007C\u00014j\u001b\u00059'B\u00015\u0010\u0003)\tgN\\8uCRLwN\\\u0005\u0003U\u001e\u00141\"\u00138uKJt\u0017\r\\!qS\u0002")
@InternalApi
public final class PeerSubjectVerifier
implements SessionVerifier {
    private final X509Certificate peerCertificate;

    @Override
    public Option<Throwable> verifyClientSession(String hostname, SSLSession session) {
        return this.verifyPeerCertificates(session);
    }

    @Override
    public Option<Throwable> verifyServerSession(String hostname, SSLSession session) {
        return this.verifyPeerCertificates(session);
    }

    private Option<IllegalArgumentException> verifyPeerCertificates(SSLSession session) {
        Certificate certificate;
        Set<String> mySubjectNames = X509Readers$.MODULE$.getAllSubjectNames(this.peerCertificate);
        if (session.getPeerCertificates().length == 0) {
            new Some<IllegalArgumentException>(new IllegalArgumentException("No peer certificates"));
        }
        if ((certificate = session.getPeerCertificates()[0]) instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            Set<String> peerSubjectNames = X509Readers$.MODULE$.getAllSubjectNames(x509Certificate);
            if (mySubjectNames.exists(peerSubjectNames)) {
                return None$.MODULE$;
            }
            return new Some<IllegalArgumentException>(new IllegalArgumentException(new StringBuilder(60).append("None of the peer subject names ").append(peerSubjectNames).append(" were in local subject names ").append(mySubjectNames).toString()));
        }
        return new Some<IllegalArgumentException>(new IllegalArgumentException(new StringBuilder(26).append("Unknown certificate type: ").append(certificate.getClass()).toString()));
    }

    public PeerSubjectVerifier(X509Certificate peerCertificate) {
        this.peerCertificate = peerCertificate;
    }
}

