/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.serialization;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.protobufv3.internal.ByteString;
import org.apache.pekko.remote.ByteStringUtils$;
import org.apache.pekko.remote.ContainerFormats;
import org.apache.pekko.remote.serialization.ThrowableNotSerializableException;
import org.apache.pekko.serialization.ByteBufferSerializer;
import org.apache.pekko.serialization.DisabledJavaSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.serialization.Serializers$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class WrappedPayloadSupport$ {
    public static WrappedPayloadSupport$ MODULE$;

    static {
        new WrappedPayloadSupport$();
    }

    /*
     * Enabled aggressive block sorting
     */
    public ContainerFormats.Payload.Builder payloadBuilder(Object input, Serialization serialization, LoggingAdapter log) {
        ContainerFormats.Payload.Builder builder = ContainerFormats.Payload.newBuilder();
        Serializer serializer = serialization.findSerializerFor(input);
        if (input instanceof Throwable) {
            Throwable throwable = (Throwable)input;
            if (serializer instanceof DisabledJavaSerializer) {
                ThrowableNotSerializableException notSerializableException = new ThrowableNotSerializableException(throwable.getMessage(), throwable.getClass().getName(), throwable.getCause());
                log.debug("Couldn't serialize [{}] because Java serialization is disabled. Fallback to ThrowableNotSerializableException. {}", notSerializableException.originalClassName(), notSerializableException.originalMessage());
                Serializer serializer2 = serialization.findSerializerFor(notSerializableException);
                builder.setEnclosedMessage(ByteStringUtils$.MODULE$.toProtoByteStringUnsafe(serializer2.toBinary(notSerializableException))).setSerializerId(serializer2.identifier());
                String manifest = Serializers$.MODULE$.manifestFor(serializer2, notSerializableException);
                if (!new StringOps(Predef$.MODULE$.augmentString(manifest)).nonEmpty()) return builder;
                builder.setMessageManifest(ByteString.copyFromUtf8(manifest));
                return builder;
            }
        }
        builder.setEnclosedMessage(ByteStringUtils$.MODULE$.toProtoByteStringUnsafe(serializer.toBinary(input))).setSerializerId(serializer.identifier());
        String manifest = Serializers$.MODULE$.manifestFor(serializer, input);
        if (!new StringOps(Predef$.MODULE$.augmentString(manifest)).nonEmpty()) return builder;
        builder.setMessageManifest(ByteString.copyFromUtf8(manifest));
        return builder;
    }

    public Object deserializePayload(ContainerFormats.Payload payload, Serialization serialization) {
        String manifest = payload.hasMessageManifest() ? payload.getMessageManifest().toStringUtf8() : "";
        Serializer serializer = (Serializer)serialization.serializerByIdentity().apply(BoxesRunTime.boxToInteger(payload.getSerializerId()));
        if (serializer instanceof ByteBufferSerializer) {
            ByteBuffer buffer = payload.getEnclosedMessage().asReadOnlyByteBuffer();
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            return ((ByteBufferSerializer)((Object)serializer)).fromBinary(buffer, manifest);
        }
        if (serializer instanceof SerializerWithStringManifest) {
            return ((SerializerWithStringManifest)serializer).fromBinary(payload.getEnclosedMessage().toByteArray(), manifest);
        }
        return serialization.deserialize(payload.getEnclosedMessage().toByteArray(), payload.getSerializerId(), manifest).get();
    }

    private WrappedPayloadSupport$() {
        MODULE$ = this;
    }
}

