/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.Cancellable$;
import org.apache.pekko.actor.LightArrayRevolverScheduler$;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.actor.Scheduler$;
import org.apache.pekko.actor.SchedulerException;
import org.apache.pekko.dispatch.AbstractNodeQueue;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$ConfigOps$;
import org.apache.pekko.util.Helpers$Requiring$;
import org.apache.pekko.util.Unsafe;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tmf\u0001\u0002\"D\u00011C\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tS\u0002\u0011\t\u0011)A\u0005U\"A\u0001\u000f\u0001B\u0001B\u0003%\u0011\u000fC\u0003z\u0001\u0011\u0005!\u0010\u0003\u0005\u0000\u0001\t\u0007I\u0011AA\u0001\u0011!\tI\u0001\u0001Q\u0001\n\u0005\r\u0001\"CA\u0006\u0001\t\u0007I\u0011AA\u0007\u0011!\ti\u0002\u0001Q\u0001\n\u0005=\u0001\"CA\u0010\u0001\t\u0007I\u0011AA\u0007\u0011!\t\t\u0003\u0001Q\u0001\n\u0005=\u0001bBA\u0012\u0001\u0011%\u0011Q\u0005\u0005\b\u0003W\u0001A\u0011CA\u0017\u0011\u001d\t)\u0004\u0001C\t\u0003\u0003Aq!a\u000e\u0001\t#\ti\u0001C\u0004\u0002:\u0001!\t\"a\u000f\t\u000f\u0005\u001d\u0003\u0001\"\u0011\u0002J!9\u0011\u0011\u0010\u0001\u0005B\u0005m\u0004bBAD\u0001\u0011\u0005\u0013\u0011\u0012\u0005\b\u0003'\u0003A\u0011IAK\u0011%\t9\n\u0001b\u0001\n\u0003\nI\n\u0003\u0005\u0002\"\u0002\u0001\u000b\u0011BAN\u0011%\t\u0019\u000b\u0001b\u0001\n\u0013\t)\u000b\u0003\u0005\u0002(\u0002\u0001\u000b\u0011BA\u0018\u0011%\tI\u000b\u0001b\u0001\n\u0013\t)\u000b\u0003\u0005\u0002,\u0002\u0001\u000b\u0011BA\u0018\u0011%\ti\u000b\u0001b\u0001\n\u0013\t\t\u0001\u0003\u0005\u00020\u0002\u0001\u000b\u0011BA\u0002\u0011%\t\t\f\u0001b\u0001\n\u0013\t\u0019\f\u0003\u0005\u0003X\u0001\u0001\u000b\u0011BA[\u0011\u001d\tI\b\u0001C\u0005\u00053BqAa\u001a\u0001\t\u0013\u0011I\u0007C\u0004\u0003n\u0001!IAa\u001c\t\u0013\tU\u0004A1A\u0005\n\t]\u0004\u0002\u0003BN\u0001\u0001\u0006IA!\u001f\t\u000f\tu\u0005\u0001\"\u0003\u0003 \"I!q\u0015\u0001A\u0002\u0013%!\u0011\u0016\u0005\n\u0005c\u0003\u0001\u0019!C\u0005\u0005gC\u0001Ba.\u0001A\u0003&!1V\u0004\b\u0003s\u001b\u0005\u0012AA^\r\u0019\u00115\t#\u0001\u0002>\"1\u0011\u0010\u000bC\u0001\u0003\u007fC\u0001\"!1)A\u0003%\u0011q\u0006\u0004\u0007\u0003\u0007DC!!2\t\re\\C\u0011\u0001B\u001d\r)\t\u0019\u000f\u000bI\u0001$#\u0019\u0015Q\u001d\u0004\b\u0003/D\u0003bQAm\u0011)\t9O\fBA\u0002\u0013\u0005\u0011\u0011\u001e\u0005\u000b\u0003Wt#\u00111A\u0005\u0002\u00055\bBCAz]\t\u0005\t\u0015)\u0003\u0002f!Q\u0011Q \u0018\u0003\u0002\u0004%\t!!\u0001\t\u0015\u0005}hF!a\u0001\n\u0003\u0011\t\u0001\u0003\u0006\u0003\u00069\u0012\t\u0011)Q\u0005\u0003\u0007A!Ba\u0002/\u0005\u0003\u0005\u000b\u0011BA-\u0011\u0019Ih\u0006\"\u0001\u0003\n!9!\u0011\u0003\u0018\u0005\u000e\tM\u0001\u0002\u0003B\u0014]\u0011\u0015QI!\u000b\t\u000f\tEb\u0006\"\u0011\u0002\u0016\"9!1\u0007\u0018\u0005B\t%\u0002b\u0002B\u001b]\u0011\u0005#q\u0007\u0005\t\u0005{A\u0003\u0015!\u0003\u0003@!A!Q\t\u0015!\u0002\u0013\u00119\u0005C\u0005\u0003L!\u0012\r\u0011\"\u0003\u0003N!A!q\n\u0015!\u0002\u0013\t\t\u000fC\u0005\u0003R!\u0012\r\u0011\"\u0003\u0003T!A!Q\u000b\u0015!\u0002\u0013\tyEA\u000eMS\u001eDG/\u0011:sCf\u0014VM^8mm\u0016\u00148k\u00195fIVdWM\u001d\u0006\u0003\t\u0016\u000bQ!Y2u_JT!AR$\u0002\u000bA,7n[8\u000b\u0005!K\u0015AB1qC\u000eDWMC\u0001K\u0003\ry'oZ\u0002\u0001'\u0011\u0001QjU,\u0011\u00059\u000bV\"A(\u000b\u0003A\u000bQa]2bY\u0006L!AU(\u0003\r\u0005s\u0017PU3g!\t!V+D\u0001D\u0013\t16IA\u0005TG\",G-\u001e7feB\u0011\u0001,X\u0007\u00023*\u0011!lW\u0001\u0003S>T\u0011\u0001X\u0001\u0005U\u00064\u0018-\u0003\u0002_3\nI1\t\\8tK\u0006\u0014G.Z\u0001\u0007G>tg-[4\u0011\u0005\u0005<W\"\u00012\u000b\u0005}\u001b'B\u00013f\u0003!!\u0018\u0010]3tC\u001a,'\"\u00014\u0002\u0007\r|W.\u0003\u0002iE\n11i\u001c8gS\u001e\f1\u0001\\8h!\tYg.D\u0001m\u0015\tiW)A\u0003fm\u0016tG/\u0003\u0002pY\nqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018!\u0004;ie\u0016\fGMR1di>\u0014\u0018\u0010\u0005\u0002so6\t1O\u0003\u0002uk\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005Y\\\u0016\u0001B;uS2L!\u0001_:\u0003\u001bQC'/Z1e\r\u0006\u001cGo\u001c:z\u0003\u0019a\u0014N\\5u}Q!1\u0010`?\u007f!\t!\u0006\u0001C\u0003`\t\u0001\u0007\u0001\rC\u0003j\t\u0001\u0007!\u000eC\u0003q\t\u0001\u0007\u0011/A\u0005XQ\u0016,GnU5{KV\u0011\u00111\u0001\t\u0004\u001d\u0006\u0015\u0011bAA\u0004\u001f\n\u0019\u0011J\u001c;\u0002\u0015]CW-\u001a7TSj,\u0007%\u0001\u0007US\u000e\\G)\u001e:bi&|g.\u0006\u0002\u0002\u0010A!\u0011\u0011CA\r\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005Q|\u0015\u0002BA\u000e\u0003'\u0011aBR5oSR,G)\u001e:bi&|g.A\u0007US\u000e\\G)\u001e:bi&|g\u000eI\u0001\u0010'\",H\u000fZ8x]RKW.Z8vi\u0006\u00012\u000b[;uI><h\u000eV5nK>,H\u000fI\u0001\be>,h\u000eZ+q)\u0011\ty!a\n\t\u000f\u0005%2\u00021\u0001\u0002\u0010\u0005\tA-A\u0003dY>\u001c7\u000e\u0006\u0002\u00020A\u0019a*!\r\n\u0007\u0005MrJ\u0001\u0003M_:<\u0017!C:uCJ$H+[2l\u0003I9W\r^*ikR$wn\u001e8US6,w.\u001e;\u0002\u0013]\f\u0017\u000e\u001e(b]>\u001cH\u0003BA\u001f\u0003\u0007\u00022ATA \u0013\r\t\te\u0014\u0002\u0005+:LG\u000fC\u0004\u0002F=\u0001\r!a\f\u0002\u000b9\fgn\\:\u0002-M\u001c\u0007.\u001a3vY\u0016<\u0016\u000e\u001e5GSb,G\rR3mCf$b!a\u0013\u0002r\u0005UD\u0003BA'\u0003C\"B!a\u0014\u0002VA\u0019A+!\u0015\n\u0007\u0005M3IA\u0006DC:\u001cW\r\u001c7bE2,\u0007bBA,!\u0001\u000f\u0011\u0011L\u0001\tKb,7-\u001e;peB!\u00111LA/\u001b\t\t9\"\u0003\u0003\u0002`\u0005]!\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u001d\t\u0019\u0007\u0005a\u0001\u0003K\n\u0001B];o]\u0006\u0014G.\u001a\t\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019\u00111N.\u0002\t1\fgnZ\u0005\u0005\u0003_\nIG\u0001\u0005Sk:t\u0017M\u00197f\u0011\u001d\t\u0019\b\u0005a\u0001\u0003\u001f\tA\"\u001b8ji&\fG\u000eR3mCfDq!a\u001e\u0011\u0001\u0004\ty!A\u0003eK2\f\u00170\u0001\u0005tG\",G-\u001e7f)!\ti(!!\u0002\u0004\u0006\u0015E\u0003BA(\u0003\u007fBq!a\u0016\u0012\u0001\b\tI\u0006C\u0004\u0002tE\u0001\r!a\u0004\t\u000f\u0005]\u0014\u00031\u0001\u0002\u0010!9\u00111M\tA\u0002\u0005\u0015\u0014\u0001D:dQ\u0016$W\u000f\\3P]\u000e,GCBAF\u0003\u001f\u000b\t\n\u0006\u0003\u0002P\u00055\u0005bBA,%\u0001\u000f\u0011\u0011\f\u0005\b\u0003o\u0012\u0002\u0019AA\b\u0011\u001d\t\u0019G\u0005a\u0001\u0003K\nQa\u00197pg\u0016$\"!!\u0010\u0002\u00195\f\u0007P\u0012:fcV,gnY=\u0016\u0005\u0005m\u0005c\u0001(\u0002\u001e&\u0019\u0011qT(\u0003\r\u0011{WO\u00197f\u00035i\u0017\r\u001f$sKF,XM\\2zA\u0005)1\u000f^1siV\u0011\u0011qF\u0001\u0007gR\f'\u000f\u001e\u0011\u0002\u0013QL7m\u001b(b]>\u001c\u0018A\u0003;jG.t\u0015M\\8tA\u0005Iq\u000f[3fY6\u000b7o[\u0001\u000bo\",W\r\\'bg.\u0004\u0013!B9vKV,WCAA[!\r\t9l\u000b\b\u0003)\u001e\n1\u0004T5hQR\f%O]1z%\u00164x\u000e\u001c<feN\u001b\u0007.\u001a3vY\u0016\u0014\bC\u0001+)'\tAS\n\u0006\u0002\u0002<\u0006QA/Y:l\u001f\u001a47/\u001a;\u0003\u0013Q\u000b7o[)vKV,7cA\u0016\u0002HB1\u0011\u0011ZAh\u0003'l!!a3\u000b\u0007\u00055W)\u0001\u0005eSN\u0004\u0018\r^2i\u0013\u0011\t\t.a3\u0003#\u0005\u00137\u000f\u001e:bGRtu\u000eZ3Rk\u0016,X\rE\u0002\u0002V:j\u0011\u0001\u000b\u0002\u000b)\u0006\u001c8\u000eS8mI\u0016\u00148#\u0002\u0018\u0002\\\u0006\u0005\b\u0003BA4\u0003;LA!a8\u0002j\t1qJ\u00196fGR\u00042!!6.\u0005%!\u0016.\\3s)\u0006\u001c8nE\u0004.\u00037\f)'a\u0014\u0002\tQ\f7o[\u000b\u0003\u0003K\n\u0001\u0002^1tW~#S-\u001d\u000b\u0005\u0003{\ty\u000fC\u0005\u0002rB\n\t\u00111\u0001\u0002f\u0005\u0019\u0001\u0010J\u0019\u0002\u000bQ\f7o\u001b\u0011)\u0007E\n9\u0010E\u0002O\u0003sL1!a?P\u0005!1x\u000e\\1uS2,\u0017!\u0002;jG.\u001c\u0018!\u0003;jG.\u001cx\fJ3r)\u0011\tiDa\u0001\t\u0013\u0005E8'!AA\u0002\u0005\r\u0011A\u0002;jG.\u001c\b%\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiRA\u00111\u001bB\u0006\u0005\u001b\u0011y\u0001C\u0004\u0002hZ\u0002\r!!\u001a\t\u000f\u0005uh\u00071\u0001\u0002\u0004!9!q\u0001\u001cA\u0002\u0005e\u0013aC3yiJ\f7\r\u001e+bg.$B!!\u001a\u0003\u0016!9!qC\u001cA\u0002\u0005\u0015\u0014a\u0003:fa2\f7-Z,ji\"D3a\u000eB\u000e!\u0011\u0011iBa\t\u000e\u0005\t}!b\u0001B\u0011\u001f\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015\"q\u0004\u0002\bi\u0006LGN]3d\u0003-)\u00070Z2vi\u0016$\u0016m]6\u0015\u0005\t-\u0002c\u0001(\u0003.%\u0019!qF(\u0003\u000f\t{w\u000e\\3b]\u0006\u0019!/\u001e8\u0002\r\r\fgnY3m\u0003-I7oQ1oG\u0016dG.\u001a3\u0016\u0005\t-BC\u0001B\u001e!\r\t)nK\u0001\u000e\u0007\u0006t7-\u001a7mK\u0012$\u0016m]6\u0013\r\t\u0005\u00131\\A3\r\u0019\u0011\u0019\u0005\u0010\u0001\u0003@\taAH]3gS:,W.\u001a8u}\u0005aQ\t_3dkR,G\rV1tWJ1!\u0011JAn\u0003K2aAa\u0011>\u0001\t\u001d\u0013A\u0004(pi\u000e\u000bgnY3mY\u0006\u0014G.Z\u000b\u0003\u0003C\fqBT8u\u0007\u0006t7-\u001a7mC\ndW\rI\u0001\u0014\u0013:LG/[1m%\u0016\u0004X-\u0019;NCJ\\WM]\u000b\u0003\u0003\u001f\nA#\u00138ji&\fGNU3qK\u0006$X*\u0019:lKJ\u0004\u0013AB9vKV,\u0007\u0005\u0006\u0005\u0003\\\tu#\u0011\rB3!\r\t9,\f\u0005\b\u0005?r\u0002\u0019AA-\u0003\t)7\rC\u0004\u0003dy\u0001\r!!\u001a\u0002\u0003IDq!a\u001e\u001f\u0001\u0004\ty!A\u0006dQ\u0016\u001c7\u000eU3sS>$G\u0003BA\u001f\u0005WBq!a\u001e \u0001\u0004\ty!A\u0007dQ\u0016\u001c7.T1y\t\u0016d\u0017-\u001f\u000b\u0005\u0003{\u0011\t\bC\u0004\u0003t\u0001\u0002\r!a\f\u0002\u0015\u0011,G.Y=OC:|7/A\u0004ti>\u0004\b/\u001a3\u0016\u0005\te\u0004C\u0002B>\u0005\u0003\u0013))\u0004\u0002\u0003~)\u0019!qP:\u0002\r\u0005$x.\\5d\u0013\u0011\u0011\u0019I! \u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004b!a\u0017\u0003\b\n-\u0015\u0002\u0002BE\u0003/\u0011q\u0001\u0015:p[&\u001cX\r\u0005\u0004\u0003\u000e\n]%1L\u0007\u0003\u0005\u001fSAA!%\u0003\u0014\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0005+{\u0015AC2pY2,7\r^5p]&!!\u0011\u0014BH\u0005\r\u0019V-]\u0001\tgR|\u0007\u000f]3eA\u0005!1\u000f^8q)\t\u0011\t\u000b\u0005\u0004\u0002\\\t\r&1R\u0005\u0005\u0005K\u000b9B\u0001\u0004GkR,(/Z\u0001\fi&lWM\u001d+ie\u0016\fG-\u0006\u0002\u0003,B!\u0011q\rBW\u0013\u0011\u0011y+!\u001b\u0003\rQC'/Z1e\u0003=!\u0018.\\3s)\"\u0014X-\u00193`I\u0015\fH\u0003BA\u001f\u0005kC\u0011\"!=&\u0003\u0003\u0005\rAa+\u0002\u0019QLW.\u001a:UQJ,\u0017\r\u001a\u0011)\u0007\u0019\n9\u0010")
public class LightArrayRevolverScheduler
implements Scheduler,
Closeable {
    public final LoggingAdapter org$apache$pekko$actor$LightArrayRevolverScheduler$$log;
    public final ThreadFactory org$apache$pekko$actor$LightArrayRevolverScheduler$$threadFactory;
    private final int WheelSize;
    private final FiniteDuration TickDuration;
    private final FiniteDuration ShutdownTimeout;
    private final double maxFrequency;
    private final long org$apache$pekko$actor$LightArrayRevolverScheduler$$start;
    private final long org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos;
    private final int org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask;
    private final TaskQueue org$apache$pekko$actor$LightArrayRevolverScheduler$$queue;
    private final AtomicReference<Promise<Seq<TimerTask>>> org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped;
    private volatile Thread org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread;

    @Override
    public final Cancellable scheduleWithFixedDelay(Duration initialDelay, Duration delay, Runnable runnable, ExecutionContext executor) {
        return Scheduler.scheduleWithFixedDelay$((Scheduler)this, initialDelay, delay, runnable, executor);
    }

    @Override
    public final Cancellable scheduleWithFixedDelay(FiniteDuration initialDelay, FiniteDuration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.scheduleWithFixedDelay$((Scheduler)this, initialDelay, delay, receiver, message, executor, sender);
    }

    @Override
    public final ActorRef scheduleWithFixedDelay$default$6(FiniteDuration initialDelay, FiniteDuration delay, ActorRef receiver, Object message) {
        return Scheduler.scheduleWithFixedDelay$default$6$(this, initialDelay, delay, receiver, message);
    }

    @Override
    public final Cancellable scheduleWithFixedDelay(Duration initialDelay, Duration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.scheduleWithFixedDelay$((Scheduler)this, initialDelay, delay, receiver, message, executor, sender);
    }

    @Override
    public final Cancellable scheduleAtFixedRate(FiniteDuration initialDelay, FiniteDuration interval, Runnable runnable, ExecutionContext executor) {
        return Scheduler.scheduleAtFixedRate$((Scheduler)this, initialDelay, interval, runnable, executor);
    }

    @Override
    public final Cancellable scheduleAtFixedRate(Duration initialDelay, Duration interval, Runnable runnable, ExecutionContext executor) {
        return Scheduler.scheduleAtFixedRate$((Scheduler)this, initialDelay, interval, runnable, executor);
    }

    @Override
    public final Cancellable scheduleAtFixedRate(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.scheduleAtFixedRate$((Scheduler)this, initialDelay, interval, receiver, message, executor, sender);
    }

    @Override
    public final ActorRef scheduleAtFixedRate$default$6(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message) {
        return Scheduler.scheduleAtFixedRate$default$6$(this, initialDelay, interval, receiver, message);
    }

    @Override
    public final Cancellable scheduleAtFixedRate(Duration initialDelay, Duration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.scheduleAtFixedRate$((Scheduler)this, initialDelay, interval, receiver, message, executor, sender);
    }

    @Override
    public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.schedule$((Scheduler)this, initialDelay, interval, receiver, message, executor, sender);
    }

    @Override
    public final ActorRef schedule$default$6(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message) {
        return Scheduler.schedule$default$6$(this, initialDelay, interval, receiver, message);
    }

    @Override
    public final Cancellable schedule(Duration initialDelay, Duration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.schedule$((Scheduler)this, initialDelay, interval, receiver, message, executor, sender);
    }

    @Override
    public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Function0<BoxedUnit> f, ExecutionContext executor) {
        return Scheduler.schedule$((Scheduler)this, initialDelay, interval, f, executor);
    }

    @Override
    public Cancellable schedule(Duration initialDelay, Duration interval, Runnable runnable, ExecutionContext executor) {
        return Scheduler.schedule$((Scheduler)this, initialDelay, interval, runnable, executor);
    }

    @Override
    public final Cancellable scheduleOnce(FiniteDuration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.scheduleOnce$((Scheduler)this, delay, receiver, message, executor, sender);
    }

    @Override
    public final ActorRef scheduleOnce$default$5(FiniteDuration delay, ActorRef receiver, Object message) {
        return Scheduler.scheduleOnce$default$5$(this, delay, receiver, message);
    }

    @Override
    public final Cancellable scheduleOnce(Duration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.scheduleOnce$((Scheduler)this, delay, receiver, message, executor, sender);
    }

    @Override
    public final Cancellable scheduleOnce(FiniteDuration delay, Function0<BoxedUnit> f, ExecutionContext executor) {
        return Scheduler.scheduleOnce$((Scheduler)this, delay, f, executor);
    }

    @Override
    public Cancellable scheduleOnce(Duration delay, Runnable runnable, ExecutionContext executor) {
        return Scheduler.scheduleOnce$((Scheduler)this, delay, runnable, executor);
    }

    public int WheelSize() {
        return this.WheelSize;
    }

    public FiniteDuration TickDuration() {
        return this.TickDuration;
    }

    public FiniteDuration ShutdownTimeout() {
        return this.ShutdownTimeout;
    }

    public FiniteDuration org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(FiniteDuration d) {
        long dn = d.toNanos();
        long r = ((dn - 1L) / this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() + 1L) * this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos();
        if (r != dn && r > 0L && dn > 0L) {
            return new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(r)).nanos();
        }
        return d;
    }

    public long clock() {
        return System.nanoTime();
    }

    public int startTick() {
        return 0;
    }

    public FiniteDuration getShutdownTimeout() {
        return this.ShutdownTimeout();
    }

    public void waitNanos(long nanos) {
        try {
            Thread.sleep(Helpers$.MODULE$.isWindows() ? (nanos + 4999999L) / 10000000L * 10L : (nanos + 999999L) / 1000000L);
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    @Override
    public Cancellable scheduleWithFixedDelay(FiniteDuration initialDelay, FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
        this.checkPeriod(delay);
        this.checkMaxDelay(this.org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(delay).toNanos());
        return new Scheduler.AtomicCancellable(this, initialDelay, runnable, delay, executor){
            private final /* synthetic */ Scheduler $outer;
            private final FiniteDuration initialDelay$1;
            public final Runnable runnable$1;
            public final FiniteDuration delay$1;
            public final ExecutionContext executor$1;

            public final Cancellable scheduledFirst() {
                return this.$outer.scheduleOnce(this.initialDelay$1, new Runnable(this){
                    private final /* synthetic */ Scheduler$.anon.1 $outer;

                    public void run() {
                        try {
                            this.$outer.runnable$1.run();
                            if (this.$outer.get() != null) {
                                this.$outer.swap(this.$outer.org$apache$pekko$actor$Scheduler$$anon$$$outer().scheduleOnce(this.$outer.delay$1, (Runnable)this, this.$outer.executor$1));
                            }
                        }
                        catch (Throwable throwable) {
                            IllegalStateException illegalStateException;
                            if (throwable instanceof SchedulerException) {
                                return;
                            }
                            if (throwable instanceof IllegalStateException && (illegalStateException = (IllegalStateException)throwable).getCause() != null && illegalStateException.getCause() instanceof SchedulerException) {
                                return;
                            }
                            throw throwable;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.executor$1);
            }

            public /* synthetic */ Scheduler org$apache$pekko$actor$Scheduler$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.initialDelay$1 = initialDelay$1;
                this.runnable$1 = runnable$1;
                this.delay$1 = delay$1;
                this.executor$1 = executor$1;
                super(Cancellable$.MODULE$.initialNotCancelled());
            }
        };
    }

    @Override
    public Cancellable schedule(FiniteDuration initialDelay, FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
        this.checkPeriod(delay);
        this.checkMaxDelay(this.org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(delay).toNanos());
        return new Scheduler.AtomicCancellable(this, executor, initialDelay, runnable, delay){
            private final /* synthetic */ LightArrayRevolverScheduler $outer;
            public final ExecutionContext executor$1;
            public final FiniteDuration initialDelay$1;
            public final Runnable runnable$1;
            public final FiniteDuration delay$1;

            public final Cancellable scheduledFirst() {
                return this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$schedule(this.executor$1, new Runnable(this){
                    private final /* synthetic */ $anon$1 $outer;

                    public void run() {
                        try {
                            this.$outer.runnable$1.run();
                            long driftNanos = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$$$outer().clock() - this.getAndAdd(this.$outer.delay$1.toNanos());
                            if (this.$outer.get() != null) {
                                this.$outer.swap(this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$$$outer().org$apache$pekko$actor$LightArrayRevolverScheduler$$schedule(this.$outer.executor$1, this, Duration$.MODULE$.fromNanos(Math.max(this.$outer.delay$1.toNanos() - driftNanos, 1L))));
                            }
                        }
                        catch (SchedulerException schedulerException) {}
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super($outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$$$outer().clock() + $outer.initialDelay$1.toNanos());
                    }
                }, this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(this.initialDelay$1));
            }

            public /* synthetic */ LightArrayRevolverScheduler org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executor$1 = executor$1;
                this.initialDelay$1 = initialDelay$1;
                this.runnable$1 = runnable$1;
                this.delay$1 = delay$1;
                super(LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$InitialRepeatMarker());
            }
        };
    }

    @Override
    public Cancellable scheduleOnce(FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
        try {
            return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$schedule(executor, runnable, this.org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(delay));
        }
        catch (Throwable throwable) {
            if (throwable instanceof SchedulerException) {
                SchedulerException schedulerException = (SchedulerException)throwable;
                String msg = schedulerException.msg();
                throw new IllegalStateException(msg, schedulerException);
            }
            throw throwable;
        }
    }

    @Override
    public void close() {
        ((IterableLike)Await$.MODULE$.result(this.stop(), this.getShutdownTimeout())).foreach((Function1<TimerTask, Object> & Serializable & scala.Serializable)x0$1 -> {
            LightArrayRevolverScheduler.$anonfun$close$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public double maxFrequency() {
        return this.maxFrequency;
    }

    public long org$apache$pekko$actor$LightArrayRevolverScheduler$$start() {
        return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$start;
    }

    public long org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() {
        return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos;
    }

    public int org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask() {
        return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask;
    }

    public TaskQueue org$apache$pekko$actor$LightArrayRevolverScheduler$$queue() {
        return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue;
    }

    public TimerTask org$apache$pekko$actor$LightArrayRevolverScheduler$$schedule(ExecutionContext ec, Runnable r, FiniteDuration delay) {
        if (delay.length() <= 0L) {
            if (this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().get() != null) {
                throw new SchedulerException("cannot enqueue after timer shutdown");
            }
            ec.execute(r);
            return LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$NotCancellable();
        }
        if (this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().get() != null) {
            throw new SchedulerException("cannot enqueue after timer shutdown");
        }
        long delayNanos = delay.toNanos();
        this.checkMaxDelay(delayNanos);
        int ticks = (int)(delayNanos / this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos());
        TaskHolder task = new TaskHolder(r, ticks, ec);
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue().add(task);
        if (this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().get() != null && task.cancel()) {
            throw new SchedulerException("cannot enqueue after timer shutdown");
        }
        return task;
    }

    private void checkPeriod(FiniteDuration delay) {
        if (delay.length() <= 0L) {
            throw new IllegalArgumentException(new StringBuilder(119).append("Task scheduled with [").append(delay.toSeconds()).append("] seconds delay, which means creating an infinite loop. ").append("The expected delay must be greater than 0.").toString());
        }
    }

    private void checkMaxDelay(long delayNanos) {
        if (delayNanos / this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(new StringBuilder(93).append("Task scheduled with [").append(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(delayNanos)).nanos().toSeconds()).append("] seconds delay, ").append("which is too far in future, maximum delay is [").append(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() * Integer.MAX_VALUE)).nanos().toSeconds() - 1L).append("] seconds").toString());
        }
    }

    public AtomicReference<Promise<Seq<TimerTask>>> org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped() {
        return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped;
    }

    private Future<Seq<TimerTask>> stop() {
        Promise p = Promise$.MODULE$.apply();
        if (this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().compareAndSet(null, p)) {
            return p.future();
        }
        return Future$.MODULE$.successful(Nil$.MODULE$);
    }

    private Thread org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread() {
        return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread;
    }

    public void org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread_$eq(Thread x$1) {
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$WheelSize$1(int ticks) {
        return (ticks & ticks - 1) == 0;
    }

    private final void runTask$1(Runnable task) {
        try {
            task.run();
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof InterruptedException) {
                throw (InterruptedException)throwable;
            }
            if (throwable instanceof SchedulerException) {
                return;
            }
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable);
            if (!option.isEmpty()) {
                Throwable e = option.get();
                this.org$apache$pekko$actor$LightArrayRevolverScheduler$$log.error(e, "exception while executing timer task");
                return;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$close$1(LightArrayRevolverScheduler $this, TimerTask x0$1) {
        if (x0$1 instanceof Scheduler.TaskRunOnClose) {
            try {
                x0$1.run();
                return;
            }
            catch (Throwable throwable) {
                if (throwable instanceof InterruptedException) {
                    throw (InterruptedException)throwable;
                }
                if (throwable instanceof SchedulerException) {
                    return;
                }
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable);
                if (!option.isEmpty()) {
                    Throwable runTask$1_e = option.get();
                    $this.org$apache$pekko$actor$LightArrayRevolverScheduler$$log.error(runTask$1_e, "exception while executing timer task");
                    return;
                }
                throw throwable;
            }
        }
        if (x0$1 instanceof TaskHolder) {
            Runnable runnable = ((TaskHolder)x0$1).task();
            if (runnable instanceof Scheduler.TaskRunOnClose) {
                Scheduler.TaskRunOnClose taskRunOnClose = (Scheduler.TaskRunOnClose)runnable;
                $this.runTask$1(taskRunOnClose);
                return;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public LightArrayRevolverScheduler(Config config, LoggingAdapter log, ThreadFactory threadFactory) {
        FiniteDuration finiteDuration;
        void requiring$extension1_msg;
        void requiring$extension1_$this;
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$log = log;
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$threadFactory = threadFactory;
        Scheduler.$init$(this);
        Function0<String> & Serializable & scala.Serializable intersect = (Function0<String> & Serializable & scala.Serializable)() -> "ticks-per-wheel must be a power of 2";
        Integer n = Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger(config.getInt("pekko.scheduler.ticks-per-wheel")));
        if (Helpers$Requiring$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.require(LightArrayRevolverScheduler.$anonfun$WheelSize$1(BoxesRunTime.unboxToInt(requiring$extension1_$this)), (Function0<Object>)requiring$extension1_msg);
        this.WheelSize = BoxesRunTime.unboxToInt(requiring$extension1_$this);
        FiniteDuration durationFromConfig = Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.scheduler.tick-duration");
        boolean errorOnVerificationFailed = config.getBoolean("pekko.scheduler.error-on-tick-duration-verification-failed");
        if (durationFromConfig.$less(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).millis())) {
            if (Helpers$.MODULE$.isWindows()) {
                if (errorOnVerificationFailed) {
                    throw new IllegalArgumentException("requirement failed: minimum supported pekko.scheduler.tick-duration on Windows is 10ms");
                }
                log.warning("requirement failed: minimum supported pekko.scheduler.tick-duration on Windows is 10ms, adjusted to 10ms now.");
                finiteDuration = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).millis();
            } else if (durationFromConfig.$less(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).millis())) {
                if (errorOnVerificationFailed) {
                    throw new IllegalArgumentException("requirement failed: minimum supported pekko.scheduler.tick-duration is 1ms");
                }
                log.warning("requirement failed: minimum supported pekko.scheduler.tick-duration is 1ms, adjusted to 1ms now.");
                finiteDuration = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).millis();
            } else {
                finiteDuration = durationFromConfig;
            }
        } else {
            finiteDuration = durationFromConfig;
        }
        this.TickDuration = finiteDuration;
        this.ShutdownTimeout = Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.scheduler.shutdown-timeout");
        this.maxFrequency = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second().$div(this.TickDuration());
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$start = this.clock();
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos = this.TickDuration().toNanos();
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask = this.WheelSize() - 1;
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue = new TaskQueue();
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped = new AtomicReference();
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread = threadFactory.newThread(new Runnable(this){
            private int tick;
            private long totalTick;
            private final TaskQueue[] wheel;
            private TaskQueue spareTaskQueue;
            private final /* synthetic */ LightArrayRevolverScheduler $outer;

            private int tick() {
                return this.tick;
            }

            private void tick_$eq(int x$1) {
                this.tick = x$1;
            }

            private long totalTick() {
                return this.totalTick;
            }

            private void totalTick_$eq(long x$1) {
                this.totalTick = x$1;
            }

            private TaskQueue[] wheel() {
                return this.wheel;
            }

            private TaskQueue spareTaskQueue() {
                return this.spareTaskQueue;
            }

            private void spareTaskQueue_$eq(TaskQueue x$1) {
                this.spareTaskQueue = x$1;
            }

            private Seq<TimerTask> clearAll() {
                return ((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.WheelSize()).flatMap((Function1<Object, Vector> & Serializable & scala.Serializable)i -> $anon$3.$anonfun$clearAll$1(this, BoxesRunTime.unboxToInt(i)), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus(this.collect$1(this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue(), (Vector)package$.MODULE$.Vector().empty()), IndexedSeq$.MODULE$.canBuildFrom());
            }

            private void checkQueue(long time) {
                AbstractNodeQueue.Node<T> node;
                while ((node = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue().pollNode()) != null) {
                    int n = ((TaskHolder)node.value).ticks();
                    switch (n) {
                        case 0: {
                            ((TaskHolder)node.value).executeTask();
                            break;
                        }
                        default: {
                            int futureTick = (int)((time - this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$start() + (long)n * this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() + this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() - 1L) / this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos());
                            int offset = futureTick - this.tick();
                            int bucket = futureTick & this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask();
                            ((TaskHolder)node.value).ticks_$eq(offset);
                            this.wheel()[bucket].addNode(node);
                        }
                    }
                }
                return;
            }

            public final void run() {
                try {
                    this.nextTick();
                    return;
                }
                catch (Throwable t) {
                    this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$log.error(t, "exception on LARS\u2019 timer thread");
                    Promise<Seq<TimerTask>> promise = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().get();
                    if (promise == null) {
                        Thread thread = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$threadFactory.newThread(this);
                        this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$log.info("starting new LARS thread");
                        try {
                            thread.start();
                        }
                        catch (Throwable e) {
                            this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$log.error(e, "LARS cannot start new thread, ship\u2019s going down!");
                            this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().set(Promise$.MODULE$.successful(Nil$.MODULE$));
                            this.clearAll();
                        }
                        this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread_$eq(thread);
                    } else {
                        Predef$.MODULE$.assert(this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().compareAndSet(promise, Promise$.MODULE$.successful(Nil$.MODULE$)), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Stop signal violated in LARS");
                        promise.success(this.clearAll());
                    }
                    throw t;
                }
            }

            private final void nextTick() {
                Promise<Seq<TimerTask>> promise;
                do {
                    long time = this.$outer.clock();
                    long sleepTime = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$start() + this.totalTick() * this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() - time;
                    if (sleepTime > 0L) {
                        this.checkQueue(time);
                        this.$outer.waitNanos(sleepTime);
                        continue;
                    }
                    int bucket = this.tick() & this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask();
                    TaskQueue tasks2 = this.wheel()[bucket];
                    TaskQueue putBack = this.spareTaskQueue();
                    this.executeBucket$1(tasks2, putBack);
                    this.wheel()[bucket] = putBack;
                    this.spareTaskQueue_$eq(tasks2);
                    this.tick_$eq(this.tick() + 1);
                    this.totalTick_$eq(this.totalTick() + 1L);
                } while ((promise = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().get()) == null);
                Predef$.MODULE$.assert(this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().compareAndSet(promise, Promise$.MODULE$.successful(Nil$.MODULE$)), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Stop signal violated in LARS");
                promise.success(this.clearAll());
            }

            private final Vector collect$1(TaskQueue q, Vector acc2) {
                TaskHolder taskHolder;
                while ((taskHolder = (TaskHolder)q.poll()) != null) {
                    acc2 = acc2.$colon$plus(taskHolder, Vector$.MODULE$.canBuildFrom());
                }
                return acc2;
            }

            public static final /* synthetic */ Vector $anonfun$clearAll$1($anon$3 $this, int i) {
                return $this.collect$1($this.wheel()[i], (Vector)package$.MODULE$.Vector().empty());
            }

            private final void executeBucket$1(TaskQueue tasks$1, TaskQueue putBack$1) {
                AbstractNodeQueue.Node<T> node;
                while ((node = tasks$1.pollNode()) != null) {
                    TaskHolder task = (TaskHolder)node.value;
                    if (task.isCancelled()) continue;
                    if (task.ticks() >= this.$outer.WheelSize()) {
                        task.ticks_$eq(task.ticks() - this.$outer.WheelSize());
                        putBack$1.addNode(node);
                        continue;
                    }
                    task.executeTask();
                }
                return;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tick = $outer.startTick();
                this.totalTick = this.tick();
                this.wheel = (TaskQueue[])Array$.MODULE$.fill($outer.WheelSize(), (Function0<TaskQueue> & Serializable & scala.Serializable)() -> new TaskQueue(), ClassTag$.MODULE$.apply(TaskQueue.class));
                this.spareTaskQueue = new TaskQueue();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$clearAll$1$adapted(org.apache.pekko.actor.LightArrayRevolverScheduler$$anon$3 java.lang.Object ), $anonfun$run$1(), $anonfun$nextTick$1(), $anonfun$wheel$1()}, serializedLambda);
            }
        });
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread().start();
    }

    public static class TaskHolder
    implements TimerTask {
        private volatile Runnable task;
        private int ticks;
        private final ExecutionContext executionContext;

        public Runnable task() {
            return this.task;
        }

        public void task_$eq(Runnable x$1) {
            this.task = x$1;
        }

        public int ticks() {
            return this.ticks;
        }

        public void ticks_$eq(int x$1) {
            this.ticks = x$1;
        }

        private final Runnable extractTask(Runnable replaceWith) {
            while (true) {
                boolean bl;
                Runnable runnable = this.task();
                Runnable runnable2 = LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$ExecutedTask;
                if (!(runnable2 != null ? !runnable2.equals(runnable) : runnable != null)) {
                    bl = true;
                } else {
                    Runnable runnable3 = LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$CancelledTask;
                    bl = !(runnable3 != null ? !runnable3.equals(runnable) : runnable != null);
                }
                if (bl) {
                    return runnable;
                }
                if (!Unsafe.instance.compareAndSwapObject(this, LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$taskOffset, runnable, replaceWith)) continue;
                return runnable;
            }
        }

        public final boolean executeTask() {
            boolean bl;
            Runnable runnable = this.extractTask(LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$ExecutedTask);
            Runnable runnable2 = LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$ExecutedTask;
            if (!(runnable2 != null ? !runnable2.equals(runnable) : runnable != null)) {
                bl = true;
            } else {
                Runnable runnable3 = LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$CancelledTask;
                bl = !(runnable3 != null ? !runnable3.equals(runnable) : runnable != null);
            }
            if (bl) {
                return false;
            }
            try {
                this.executionContext.execute(runnable);
                return true;
            }
            catch (Throwable throwable) {
                if (throwable instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    return false;
                }
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable);
                if (!option.isEmpty()) {
                    Throwable e = option.get();
                    this.executionContext.reportFailure(e);
                    return false;
                }
                throw throwable;
            }
        }

        @Override
        public void run() {
            this.extractTask(LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$ExecutedTask).run();
        }

        @Override
        public boolean cancel() {
            boolean bl;
            Runnable runnable = this.extractTask(LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$CancelledTask);
            Runnable runnable2 = LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$ExecutedTask;
            if (!(runnable2 != null ? !runnable2.equals(runnable) : runnable != null)) {
                bl = true;
            } else {
                Runnable runnable3 = LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$CancelledTask;
                bl = !(runnable3 != null ? !runnable3.equals(runnable) : runnable != null);
            }
            return !bl;
        }

        @Override
        public boolean isCancelled() {
            return this.task() == LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$CancelledTask;
        }

        public TaskHolder(Runnable task, int ticks, ExecutionContext executionContext) {
            this.task = task;
            this.ticks = ticks;
            this.executionContext = executionContext;
        }
    }

    private static class TaskQueue
    extends AbstractNodeQueue<TaskHolder> {
    }

    public static interface TimerTask
    extends Runnable,
    Cancellable {
    }
}

