/*
 * Decompiled with CFR 0.152.
 */
package com.openai.models.audio.translations;

import com.openai.core.Check;
import com.openai.core.Enum;
import com.openai.core.ExcludeMissing;
import com.openai.core.JsonField;
import com.openai.core.MultipartField;
import com.openai.core.Params;
import com.openai.core.Utils;
import com.openai.core.http.Headers;
import com.openai.core.http.QueryParams;
import com.openai.errors.OpenAIInvalidDataException;
import com.openai.models.audio.AudioModel;
import com.openai.models.audio.translations.TranslationCreateParams;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.flink.model.openai.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.model.openai.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.model.openai.com.fasterxml.jackson.annotation.JsonValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 +2\u00020\u0001:\u0004)*+,B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010\n\u001a\u00020\u0007J\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\fJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eJ\b\u0010\u0011\u001a\u00020\u0005H\u0016J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u000eJ\b\u0010\u0015\u001a\u00020\u0007H\u0016J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000eJ\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000eJ\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\u0006\u0010\u001e\u001a\u00020\u0010J\b\u0010\u001f\u001a\u00020 H\u0016J\u0006\u0010!\u001a\u00020\u0013J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0#J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00170#J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190#J\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/openai/models/audio/translations/TranslationCreateParams;", "Lcom/openai/core/Params;", "body", "Lcom/openai/models/audio/translations/TranslationCreateParams$Body;", "additionalHeaders", "Lcom/openai/core/http/Headers;", "additionalQueryParams", "Lcom/openai/core/http/QueryParams;", "(Lcom/openai/models/audio/translations/TranslationCreateParams$Body;Lcom/openai/core/http/Headers;Lcom/openai/core/http/QueryParams;)V", "_additionalHeaders", "_additionalQueryParams", "_body", "", "", "Lcom/openai/core/MultipartField;", "_file", "Ljava/io/InputStream;", "_headers", "_model", "Lcom/openai/models/audio/AudioModel;", "_prompt", "_queryParams", "_responseFormat", "Lcom/openai/models/audio/translations/TranslationCreateParams$ResponseFormat;", "_temperature", "", "equals", "", "other", "", "file", "hashCode", "", "model", "prompt", "Ljava/util/Optional;", "responseFormat", "temperature", "toBuilder", "Lcom/openai/models/audio/translations/TranslationCreateParams$Builder;", "toString", "Body", "Builder", "Companion", "ResponseFormat", "openai-java-core"})
public final class TranslationCreateParams
implements Params {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Body body;
    @NotNull
    private final Headers additionalHeaders;
    @NotNull
    private final QueryParams additionalQueryParams;

    private TranslationCreateParams(Body body, Headers additionalHeaders, QueryParams additionalQueryParams) {
        this.body = body;
        this.additionalHeaders = additionalHeaders;
        this.additionalQueryParams = additionalQueryParams;
    }

    @NotNull
    public final InputStream file() {
        return this.body.file();
    }

    @NotNull
    public final AudioModel model() {
        return this.body.model();
    }

    @NotNull
    public final Optional<String> prompt() {
        return this.body.prompt();
    }

    @NotNull
    public final Optional<ResponseFormat> responseFormat() {
        return this.body.responseFormat();
    }

    @NotNull
    public final Optional<Double> temperature() {
        return this.body.temperature();
    }

    @NotNull
    public final MultipartField<InputStream> _file() {
        return this.body._file();
    }

    @NotNull
    public final MultipartField<AudioModel> _model() {
        return this.body._model();
    }

    @NotNull
    public final MultipartField<String> _prompt() {
        return this.body._prompt();
    }

    @NotNull
    public final MultipartField<ResponseFormat> _responseFormat() {
        return this.body._responseFormat();
    }

    @NotNull
    public final MultipartField<Double> _temperature() {
        return this.body._temperature();
    }

    @NotNull
    public final Headers _additionalHeaders() {
        return this.additionalHeaders;
    }

    @NotNull
    public final QueryParams _additionalQueryParams() {
        return this.additionalQueryParams;
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder().from$openai_java_core(this);
    }

    @NotNull
    public final Map<String, MultipartField<?>> _body() {
        Pair[] pairArray = new Pair[]{TuplesKt.to("file", this._file()), TuplesKt.to("model", this._model()), TuplesKt.to("prompt", this._prompt()), TuplesKt.to("response_format", this._responseFormat()), TuplesKt.to("temperature", this._temperature())};
        return Utils.toImmutable(MapsKt.mapOf(pairArray));
    }

    @Override
    @NotNull
    public Headers _headers() {
        return this.additionalHeaders;
    }

    @Override
    @NotNull
    public QueryParams _queryParams() {
        return this.additionalQueryParams;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TranslationCreateParams && Intrinsics.areEqual(this.body, ((TranslationCreateParams)other).body) && Intrinsics.areEqual(this.additionalHeaders, ((TranslationCreateParams)other).additionalHeaders) && Intrinsics.areEqual(this.additionalQueryParams, ((TranslationCreateParams)other).additionalQueryParams);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.body, this.additionalHeaders, this.additionalQueryParams};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return "TranslationCreateParams{body=" + this.body + ", additionalHeaders=" + this.additionalHeaders + ", additionalQueryParams=" + this.additionalQueryParams + '}';
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public /* synthetic */ TranslationCreateParams(Body body, Headers additionalHeaders, QueryParams additionalQueryParams, DefaultConstructorMarker $constructor_marker) {
        this(body, additionalHeaders, additionalQueryParams);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0002#$BM\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0007J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0007J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u0007J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u0007J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u0007J\u0013\u0010\u001b\u001a\u00020\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010\u0002\u001a\u00020\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u001d\u001a\u00020\u0015J\u0006\u0010\u0005\u001a\u00020\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u001eJ\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u001eJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u001eJ\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\bH\u0016J\u0006\u0010\"\u001a\u00020\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/openai/models/audio/translations/TranslationCreateParams$Body;", "", "file", "Lcom/openai/core/MultipartField;", "Ljava/io/InputStream;", "model", "Lcom/openai/models/audio/AudioModel;", "prompt", "", "responseFormat", "Lcom/openai/models/audio/translations/TranslationCreateParams$ResponseFormat;", "temperature", "", "(Lcom/openai/core/MultipartField;Lcom/openai/core/MultipartField;Lcom/openai/core/MultipartField;Lcom/openai/core/MultipartField;Lcom/openai/core/MultipartField;)V", "hashCode", "", "getHashCode", "()I", "hashCode$delegate", "Lkotlin/Lazy;", "validated", "", "_file", "_model", "_prompt", "_responseFormat", "_temperature", "equals", "other", "isValid", "Ljava/util/Optional;", "toBuilder", "Lcom/openai/models/audio/translations/TranslationCreateParams$Body$Builder;", "toString", "validate", "Builder", "Companion", "openai-java-core"})
    public static final class Body {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final MultipartField<InputStream> file;
        @NotNull
        private final MultipartField<AudioModel> model;
        @NotNull
        private final MultipartField<String> prompt;
        @NotNull
        private final MultipartField<ResponseFormat> responseFormat;
        @NotNull
        private final MultipartField<Double> temperature;
        private boolean validated;
        @NotNull
        private final Lazy hashCode$delegate;

        private Body(MultipartField<InputStream> file, MultipartField<AudioModel> model, MultipartField<String> prompt, MultipartField<ResponseFormat> responseFormat, MultipartField<Double> temperature) {
            this.file = file;
            this.model = model;
            this.prompt = prompt;
            this.responseFormat = responseFormat;
            this.temperature = temperature;
            this.hashCode$delegate = LazyKt.lazy((Function0)new Function0<Integer>(this){
                final /* synthetic */ Body this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Integer invoke() {
                    Object[] objectArray = new Object[]{Body.access$getFile$p(this.this$0), Body.access$getModel$p(this.this$0), Body.access$getPrompt$p(this.this$0), Body.access$getResponseFormat$p(this.this$0), Body.access$getTemperature$p(this.this$0)};
                    return Objects.hash(objectArray);
                }
            });
        }

        @NotNull
        public final InputStream file() {
            return (InputStream)this.file.value().getRequired$openai_java_core("file");
        }

        @NotNull
        public final AudioModel model() {
            return (AudioModel)this.model.value().getRequired$openai_java_core("model");
        }

        @NotNull
        public final Optional<String> prompt() {
            return this.prompt.value().getOptional$openai_java_core("prompt");
        }

        @NotNull
        public final Optional<ResponseFormat> responseFormat() {
            return this.responseFormat.value().getOptional$openai_java_core("response_format");
        }

        @NotNull
        public final Optional<Double> temperature() {
            return this.temperature.value().getOptional$openai_java_core("temperature");
        }

        @JsonProperty(value="file")
        @ExcludeMissing
        @NotNull
        public final MultipartField<InputStream> _file() {
            return this.file;
        }

        @JsonProperty(value="model")
        @ExcludeMissing
        @NotNull
        public final MultipartField<AudioModel> _model() {
            return this.model;
        }

        @JsonProperty(value="prompt")
        @ExcludeMissing
        @NotNull
        public final MultipartField<String> _prompt() {
            return this.prompt;
        }

        @JsonProperty(value="response_format")
        @ExcludeMissing
        @NotNull
        public final MultipartField<ResponseFormat> _responseFormat() {
            return this.responseFormat;
        }

        @JsonProperty(value="temperature")
        @ExcludeMissing
        @NotNull
        public final MultipartField<Double> _temperature() {
            return this.temperature;
        }

        @NotNull
        public final Builder toBuilder() {
            return new Builder().from$openai_java_core(this);
        }

        @NotNull
        public final Body validate() {
            Body body;
            Body $this$validate_u24lambda_u241 = body = this;
            boolean bl = false;
            if (!$this$validate_u24lambda_u241.validated) {
                $this$validate_u24lambda_u241.file();
                $this$validate_u24lambda_u241.model().validate();
                $this$validate_u24lambda_u241.prompt();
                $this$validate_u24lambda_u241.responseFormat().ifPresent(arg_0 -> Body.validate$lambda$1$lambda$0(validate.1.1.INSTANCE, arg_0));
                $this$validate_u24lambda_u241.temperature();
                $this$validate_u24lambda_u241.validated = true;
            }
            return body;
        }

        public final boolean isValid() {
            boolean bl;
            try {
                this.validate();
                bl = true;
            }
            catch (OpenAIInvalidDataException e) {
                bl = false;
            }
            return bl;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Body && Intrinsics.areEqual(this.file, ((Body)other).file) && Intrinsics.areEqual(this.model, ((Body)other).model) && Intrinsics.areEqual(this.prompt, ((Body)other).prompt) && Intrinsics.areEqual(this.responseFormat, ((Body)other).responseFormat) && Intrinsics.areEqual(this.temperature, ((Body)other).temperature);
        }

        private final int getHashCode() {
            Lazy lazy = this.hashCode$delegate;
            return ((Number)lazy.getValue()).intValue();
        }

        public int hashCode() {
            return this.getHashCode();
        }

        @NotNull
        public String toString() {
            return "Body{file=" + this.file + ", model=" + this.model + ", prompt=" + this.prompt + ", responseFormat=" + this.responseFormat + ", temperature=" + this.temperature + '}';
        }

        private static final void validate$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            $tmp0.invoke(p0);
        }

        @JvmStatic
        @NotNull
        public static final Builder builder() {
            return Companion.builder();
        }

        public /* synthetic */ Body(MultipartField file, MultipartField model, MultipartField prompt, MultipartField responseFormat, MultipartField temperature, DefaultConstructorMarker $constructor_marker) {
            this(file, model, prompt, responseFormat, temperature);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0003\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0005J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0010J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0011J\u0015\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0014J\u0014\u0010\u0006\u001a\u00020\u00002\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\tJ\u0014\u0010\b\u001a\u00020\u00002\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rR\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/openai/models/audio/translations/TranslationCreateParams$Body$Builder;", "", "()V", "file", "Lcom/openai/core/MultipartField;", "Ljava/io/InputStream;", "model", "Lcom/openai/models/audio/AudioModel;", "prompt", "", "responseFormat", "Lcom/openai/models/audio/translations/TranslationCreateParams$ResponseFormat;", "temperature", "", "build", "Lcom/openai/models/audio/translations/TranslationCreateParams$Body;", "Ljava/nio/file/Path;", "", "from", "body", "from$openai_java_core", "value", "openai-java-core"})
        @SourceDebugExtension(value={"SMAP\nTranslationCreateParams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranslationCreateParams.kt\ncom/openai/models/audio/translations/TranslationCreateParams$Body$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,876:1\n1#2:877\n*E\n"})
        public static final class Builder {
            @Nullable
            private MultipartField<InputStream> file;
            @Nullable
            private MultipartField<AudioModel> model;
            @NotNull
            private MultipartField<String> prompt = MultipartField.Companion.of(null);
            @NotNull
            private MultipartField<ResponseFormat> responseFormat = MultipartField.Companion.of(null);
            @NotNull
            private MultipartField<Double> temperature = MultipartField.Companion.of(null);

            public final /* synthetic */ Builder from$openai_java_core(Body body) {
                Builder builder;
                Intrinsics.checkNotNullParameter(body, "body");
                Builder $this$from_u24lambda_u240 = builder = this;
                boolean bl = false;
                $this$from_u24lambda_u240.file = body.file;
                $this$from_u24lambda_u240.model = body.model;
                $this$from_u24lambda_u240.prompt = body.prompt;
                $this$from_u24lambda_u240.responseFormat = body.responseFormat;
                $this$from_u24lambda_u240.temperature = body.temperature;
                return builder;
            }

            @NotNull
            public final Builder file(@NotNull InputStream file) {
                Intrinsics.checkNotNullParameter(file, "file");
                return this.file(MultipartField.Companion.of(file));
            }

            @NotNull
            public final Builder file(@NotNull MultipartField<InputStream> file) {
                Builder builder;
                Intrinsics.checkNotNullParameter(file, "file");
                Builder $this$file_u24lambda_u241 = builder = this;
                boolean bl = false;
                $this$file_u24lambda_u241.file = file;
                return builder;
            }

            @NotNull
            public final Builder file(@NotNull byte[] file) {
                Intrinsics.checkNotNullParameter(file, "file");
                return this.file(new ByteArrayInputStream(file));
            }

            @NotNull
            public final Builder file(@NotNull Path file) {
                Intrinsics.checkNotNullParameter(file, "file");
                MultipartField.Builder<InputStream> builder = MultipartField.Companion.builder();
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream2 = Files.newInputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue(inputStream2, "newInputStream(this, *options)");
                return this.file(builder.value(inputStream2).filename(PathsKt.getName(file)).build());
            }

            @NotNull
            public final Builder model(@NotNull AudioModel model) {
                Intrinsics.checkNotNullParameter(model, "model");
                return this.model(MultipartField.Companion.of(model));
            }

            @NotNull
            public final Builder model(@NotNull MultipartField<AudioModel> model) {
                Builder builder;
                Intrinsics.checkNotNullParameter(model, "model");
                Builder $this$model_u24lambda_u242 = builder = this;
                boolean bl = false;
                $this$model_u24lambda_u242.model = model;
                return builder;
            }

            @NotNull
            public final Builder model(@NotNull String value) {
                Intrinsics.checkNotNullParameter(value, "value");
                return this.model(AudioModel.Companion.of(value));
            }

            @NotNull
            public final Builder prompt(@NotNull String prompt) {
                Intrinsics.checkNotNullParameter(prompt, "prompt");
                return this.prompt(MultipartField.Companion.of(prompt));
            }

            @NotNull
            public final Builder prompt(@NotNull MultipartField<String> prompt) {
                Builder builder;
                Intrinsics.checkNotNullParameter(prompt, "prompt");
                Builder $this$prompt_u24lambda_u243 = builder = this;
                boolean bl = false;
                $this$prompt_u24lambda_u243.prompt = prompt;
                return builder;
            }

            @NotNull
            public final Builder responseFormat(@NotNull ResponseFormat responseFormat) {
                Intrinsics.checkNotNullParameter(responseFormat, "responseFormat");
                return this.responseFormat(MultipartField.Companion.of(responseFormat));
            }

            @NotNull
            public final Builder responseFormat(@NotNull MultipartField<ResponseFormat> responseFormat) {
                Builder builder;
                Intrinsics.checkNotNullParameter(responseFormat, "responseFormat");
                Builder $this$responseFormat_u24lambda_u244 = builder = this;
                boolean bl = false;
                $this$responseFormat_u24lambda_u244.responseFormat = responseFormat;
                return builder;
            }

            @NotNull
            public final Builder temperature(double temperature) {
                return this.temperature(MultipartField.Companion.of(temperature));
            }

            @NotNull
            public final Builder temperature(@NotNull MultipartField<Double> temperature) {
                Builder builder;
                Intrinsics.checkNotNullParameter(temperature, "temperature");
                Builder $this$temperature_u24lambda_u245 = builder = this;
                boolean bl = false;
                $this$temperature_u24lambda_u245.temperature = temperature;
                return builder;
            }

            @NotNull
            public final Body build() {
                return new Body(Check.checkRequired("file", this.file), Check.checkRequired("model", this.model), this.prompt, this.responseFormat, this.temperature, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/openai/models/audio/translations/TranslationCreateParams$Body$Companion;", "", "()V", "builder", "Lcom/openai/models/audio/translations/TranslationCreateParams$Body$Builder;", "openai-java-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Builder builder() {
                return new Builder();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\tJ \u0010\u0003\u001a\u00020\u00002\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\nJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\rJ \u0010\u0005\u001a\u00020\u00002\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\nJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\u00020\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0013J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0014J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0015J\u0015\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0018J\u0014\u0010\u0019\u001a\u00020\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u000bJ\u0014\u0010\u001c\u001a\u00020\u00002\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u000bJ\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bJ\u001c\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\fJ\u0016\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bJ\u001c\u0010#\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\fJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\tJ \u0010$\u001a\u00020\u00002\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\nJ\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\rJ \u0010%\u001a\u00020\u00002\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\nJ\u000e\u0010&\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u000bJ\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u000bJ\u0014\u0010(\u001a\u00020\u00002\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0*J\u0014\u0010+\u001a\u00020\u00002\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0*J\u0016\u0010-\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bJ\u001c\u0010-\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\fJ\u0016\u0010.\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bJ\u001c\u0010.\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\fJ\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\tJ \u0010/\u001a\u00020\u00002\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\nJ\u000e\u00100\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\rJ \u00100\u001a\u00020\u00002\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\nJ\u0014\u00101\u001a\u00020\u00002\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u0012J\u000e\u00101\u001a\u00020\u00002\u0006\u00101\u001a\u000202J\u0014\u00103\u001a\u00020\u00002\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u0012J\u000e\u00103\u001a\u00020\u00002\u0006\u00103\u001a\u000204R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/openai/models/audio/translations/TranslationCreateParams$Builder;", "", "()V", "additionalHeaders", "Lcom/openai/core/http/Headers$Builder;", "additionalQueryParams", "Lcom/openai/core/http/QueryParams$Builder;", "body", "Lcom/openai/models/audio/translations/TranslationCreateParams$Body$Builder;", "Lcom/openai/core/http/Headers;", "", "", "", "Lcom/openai/core/http/QueryParams;", "Lcom/openai/models/audio/translations/TranslationCreateParams$Body;", "build", "Lcom/openai/models/audio/translations/TranslationCreateParams;", "file", "Lcom/openai/core/MultipartField;", "Ljava/io/InputStream;", "Ljava/nio/file/Path;", "", "from", "translationCreateParams", "from$openai_java_core", "model", "Lcom/openai/models/audio/AudioModel;", "value", "prompt", "putAdditionalHeader", "name", "putAdditionalHeaders", "values", "putAdditionalQueryParam", "key", "putAdditionalQueryParams", "putAllAdditionalHeaders", "putAllAdditionalQueryParams", "removeAdditionalHeaders", "removeAdditionalQueryParams", "removeAllAdditionalHeaders", "names", "", "removeAllAdditionalQueryParams", "keys", "replaceAdditionalHeaders", "replaceAdditionalQueryParams", "replaceAllAdditionalHeaders", "replaceAllAdditionalQueryParams", "responseFormat", "Lcom/openai/models/audio/translations/TranslationCreateParams$ResponseFormat;", "temperature", "", "openai-java-core"})
    @SourceDebugExtension(value={"SMAP\nTranslationCreateParams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranslationCreateParams.kt\ncom/openai/models/audio/translations/TranslationCreateParams$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,876:1\n1#2:877\n*E\n"})
    public static final class Builder {
        @NotNull
        private Body.Builder body = Body.Companion.builder();
        @NotNull
        private Headers.Builder additionalHeaders = Headers.Companion.builder();
        @NotNull
        private QueryParams.Builder additionalQueryParams = QueryParams.Companion.builder();

        public final /* synthetic */ Builder from$openai_java_core(TranslationCreateParams translationCreateParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(translationCreateParams, "translationCreateParams");
            Builder $this$from_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$from_u24lambda_u240.body = translationCreateParams.body.toBuilder();
            $this$from_u24lambda_u240.additionalHeaders = translationCreateParams.additionalHeaders.toBuilder();
            $this$from_u24lambda_u240.additionalQueryParams = translationCreateParams.additionalQueryParams.toBuilder();
            return builder;
        }

        @NotNull
        public final Builder body(@NotNull Body body) {
            Builder builder;
            Intrinsics.checkNotNullParameter(body, "body");
            Builder $this$body_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$body_u24lambda_u241.body = body.toBuilder();
            return builder;
        }

        @NotNull
        public final Builder file(@NotNull InputStream file) {
            Builder builder;
            Intrinsics.checkNotNullParameter(file, "file");
            Builder $this$file_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$file_u24lambda_u242.body.file(file);
            return builder;
        }

        @NotNull
        public final Builder file(@NotNull MultipartField<InputStream> file) {
            Builder builder;
            Intrinsics.checkNotNullParameter(file, "file");
            Builder $this$file_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$file_u24lambda_u243.body.file(file);
            return builder;
        }

        @NotNull
        public final Builder file(@NotNull byte[] file) {
            Builder builder;
            Intrinsics.checkNotNullParameter(file, "file");
            Builder $this$file_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$file_u24lambda_u244.body.file(file);
            return builder;
        }

        @NotNull
        public final Builder file(@NotNull Path file) {
            Builder builder;
            Intrinsics.checkNotNullParameter(file, "file");
            Builder $this$file_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$file_u24lambda_u245.body.file(file);
            return builder;
        }

        @NotNull
        public final Builder model(@NotNull AudioModel model) {
            Builder builder;
            Intrinsics.checkNotNullParameter(model, "model");
            Builder $this$model_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$model_u24lambda_u246.body.model(model);
            return builder;
        }

        @NotNull
        public final Builder model(@NotNull MultipartField<AudioModel> model) {
            Builder builder;
            Intrinsics.checkNotNullParameter(model, "model");
            Builder $this$model_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$model_u24lambda_u247.body.model(model);
            return builder;
        }

        @NotNull
        public final Builder model(@NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter(value, "value");
            Builder $this$model_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$model_u24lambda_u248.body.model(value);
            return builder;
        }

        @NotNull
        public final Builder prompt(@NotNull String prompt) {
            Builder builder;
            Intrinsics.checkNotNullParameter(prompt, "prompt");
            Builder $this$prompt_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$prompt_u24lambda_u249.body.prompt(prompt);
            return builder;
        }

        @NotNull
        public final Builder prompt(@NotNull MultipartField<String> prompt) {
            Builder builder;
            Intrinsics.checkNotNullParameter(prompt, "prompt");
            Builder $this$prompt_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$prompt_u24lambda_u2410.body.prompt(prompt);
            return builder;
        }

        @NotNull
        public final Builder responseFormat(@NotNull ResponseFormat responseFormat) {
            Builder builder;
            Intrinsics.checkNotNullParameter(responseFormat, "responseFormat");
            Builder $this$responseFormat_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$responseFormat_u24lambda_u2411.body.responseFormat(responseFormat);
            return builder;
        }

        @NotNull
        public final Builder responseFormat(@NotNull MultipartField<ResponseFormat> responseFormat) {
            Builder builder;
            Intrinsics.checkNotNullParameter(responseFormat, "responseFormat");
            Builder $this$responseFormat_u24lambda_u2412 = builder = this;
            boolean bl = false;
            $this$responseFormat_u24lambda_u2412.body.responseFormat(responseFormat);
            return builder;
        }

        @NotNull
        public final Builder temperature(double temperature) {
            Builder builder;
            Builder $this$temperature_u24lambda_u2413 = builder = this;
            boolean bl = false;
            $this$temperature_u24lambda_u2413.body.temperature(temperature);
            return builder;
        }

        @NotNull
        public final Builder temperature(@NotNull MultipartField<Double> temperature) {
            Builder builder;
            Intrinsics.checkNotNullParameter(temperature, "temperature");
            Builder $this$temperature_u24lambda_u2414 = builder = this;
            boolean bl = false;
            $this$temperature_u24lambda_u2414.body.temperature(temperature);
            return builder;
        }

        @NotNull
        public final Builder additionalHeaders(@NotNull Headers additionalHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalHeaders, "additionalHeaders");
            Builder $this$additionalHeaders_u24lambda_u2415 = builder = this;
            boolean bl = false;
            $this$additionalHeaders_u24lambda_u2415.additionalHeaders.clear();
            $this$additionalHeaders_u24lambda_u2415.putAllAdditionalHeaders(additionalHeaders);
            return builder;
        }

        @NotNull
        public final Builder additionalHeaders(@NotNull Map<String, ? extends Iterable<String>> additionalHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalHeaders, "additionalHeaders");
            Builder $this$additionalHeaders_u24lambda_u2416 = builder = this;
            boolean bl = false;
            $this$additionalHeaders_u24lambda_u2416.additionalHeaders.clear();
            $this$additionalHeaders_u24lambda_u2416.putAllAdditionalHeaders(additionalHeaders);
            return builder;
        }

        @NotNull
        public final Builder putAdditionalHeader(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(value, "value");
            Builder $this$putAdditionalHeader_u24lambda_u2417 = builder = this;
            boolean bl = false;
            $this$putAdditionalHeader_u24lambda_u2417.additionalHeaders.put(name, value);
            return builder;
        }

        @NotNull
        public final Builder putAdditionalHeaders(@NotNull String name, @NotNull Iterable<String> values2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(values2, "values");
            Builder $this$putAdditionalHeaders_u24lambda_u2418 = builder = this;
            boolean bl = false;
            $this$putAdditionalHeaders_u24lambda_u2418.additionalHeaders.put(name, values2);
            return builder;
        }

        @NotNull
        public final Builder putAllAdditionalHeaders(@NotNull Headers additionalHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalHeaders, "additionalHeaders");
            Builder $this$putAllAdditionalHeaders_u24lambda_u2419 = builder = this;
            boolean bl = false;
            $this$putAllAdditionalHeaders_u24lambda_u2419.additionalHeaders.putAll(additionalHeaders);
            return builder;
        }

        @NotNull
        public final Builder putAllAdditionalHeaders(@NotNull Map<String, ? extends Iterable<String>> additionalHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalHeaders, "additionalHeaders");
            Builder $this$putAllAdditionalHeaders_u24lambda_u2420 = builder = this;
            boolean bl = false;
            $this$putAllAdditionalHeaders_u24lambda_u2420.additionalHeaders.putAll(additionalHeaders);
            return builder;
        }

        @NotNull
        public final Builder replaceAdditionalHeaders(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(value, "value");
            Builder $this$replaceAdditionalHeaders_u24lambda_u2421 = builder = this;
            boolean bl = false;
            $this$replaceAdditionalHeaders_u24lambda_u2421.additionalHeaders.replace(name, value);
            return builder;
        }

        @NotNull
        public final Builder replaceAdditionalHeaders(@NotNull String name, @NotNull Iterable<String> values2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(values2, "values");
            Builder $this$replaceAdditionalHeaders_u24lambda_u2422 = builder = this;
            boolean bl = false;
            $this$replaceAdditionalHeaders_u24lambda_u2422.additionalHeaders.replace(name, values2);
            return builder;
        }

        @NotNull
        public final Builder replaceAllAdditionalHeaders(@NotNull Headers additionalHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalHeaders, "additionalHeaders");
            Builder $this$replaceAllAdditionalHeaders_u24lambda_u2423 = builder = this;
            boolean bl = false;
            $this$replaceAllAdditionalHeaders_u24lambda_u2423.additionalHeaders.replaceAll(additionalHeaders);
            return builder;
        }

        @NotNull
        public final Builder replaceAllAdditionalHeaders(@NotNull Map<String, ? extends Iterable<String>> additionalHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalHeaders, "additionalHeaders");
            Builder $this$replaceAllAdditionalHeaders_u24lambda_u2424 = builder = this;
            boolean bl = false;
            $this$replaceAllAdditionalHeaders_u24lambda_u2424.additionalHeaders.replaceAll(additionalHeaders);
            return builder;
        }

        @NotNull
        public final Builder removeAdditionalHeaders(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Builder $this$removeAdditionalHeaders_u24lambda_u2425 = builder = this;
            boolean bl = false;
            $this$removeAdditionalHeaders_u24lambda_u2425.additionalHeaders.remove(name);
            return builder;
        }

        @NotNull
        public final Builder removeAllAdditionalHeaders(@NotNull Set<String> names) {
            Builder builder;
            Intrinsics.checkNotNullParameter(names, "names");
            Builder $this$removeAllAdditionalHeaders_u24lambda_u2426 = builder = this;
            boolean bl = false;
            $this$removeAllAdditionalHeaders_u24lambda_u2426.additionalHeaders.removeAll(names);
            return builder;
        }

        @NotNull
        public final Builder additionalQueryParams(@NotNull QueryParams additionalQueryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalQueryParams, "additionalQueryParams");
            Builder $this$additionalQueryParams_u24lambda_u2427 = builder = this;
            boolean bl = false;
            $this$additionalQueryParams_u24lambda_u2427.additionalQueryParams.clear();
            $this$additionalQueryParams_u24lambda_u2427.putAllAdditionalQueryParams(additionalQueryParams);
            return builder;
        }

        @NotNull
        public final Builder additionalQueryParams(@NotNull Map<String, ? extends Iterable<String>> additionalQueryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalQueryParams, "additionalQueryParams");
            Builder $this$additionalQueryParams_u24lambda_u2428 = builder = this;
            boolean bl = false;
            $this$additionalQueryParams_u24lambda_u2428.additionalQueryParams.clear();
            $this$additionalQueryParams_u24lambda_u2428.putAllAdditionalQueryParams(additionalQueryParams);
            return builder;
        }

        @NotNull
        public final Builder putAdditionalQueryParam(@NotNull String key, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter(key, "key");
            Intrinsics.checkNotNullParameter(value, "value");
            Builder $this$putAdditionalQueryParam_u24lambda_u2429 = builder = this;
            boolean bl = false;
            $this$putAdditionalQueryParam_u24lambda_u2429.additionalQueryParams.put(key, value);
            return builder;
        }

        @NotNull
        public final Builder putAdditionalQueryParams(@NotNull String key, @NotNull Iterable<String> values2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(key, "key");
            Intrinsics.checkNotNullParameter(values2, "values");
            Builder $this$putAdditionalQueryParams_u24lambda_u2430 = builder = this;
            boolean bl = false;
            $this$putAdditionalQueryParams_u24lambda_u2430.additionalQueryParams.put(key, values2);
            return builder;
        }

        @NotNull
        public final Builder putAllAdditionalQueryParams(@NotNull QueryParams additionalQueryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalQueryParams, "additionalQueryParams");
            Builder $this$putAllAdditionalQueryParams_u24lambda_u2431 = builder = this;
            boolean bl = false;
            $this$putAllAdditionalQueryParams_u24lambda_u2431.additionalQueryParams.putAll(additionalQueryParams);
            return builder;
        }

        @NotNull
        public final Builder putAllAdditionalQueryParams(@NotNull Map<String, ? extends Iterable<String>> additionalQueryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalQueryParams, "additionalQueryParams");
            Builder $this$putAllAdditionalQueryParams_u24lambda_u2432 = builder = this;
            boolean bl = false;
            $this$putAllAdditionalQueryParams_u24lambda_u2432.additionalQueryParams.putAll(additionalQueryParams);
            return builder;
        }

        @NotNull
        public final Builder replaceAdditionalQueryParams(@NotNull String key, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter(key, "key");
            Intrinsics.checkNotNullParameter(value, "value");
            Builder $this$replaceAdditionalQueryParams_u24lambda_u2433 = builder = this;
            boolean bl = false;
            $this$replaceAdditionalQueryParams_u24lambda_u2433.additionalQueryParams.replace(key, value);
            return builder;
        }

        @NotNull
        public final Builder replaceAdditionalQueryParams(@NotNull String key, @NotNull Iterable<String> values2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(key, "key");
            Intrinsics.checkNotNullParameter(values2, "values");
            Builder $this$replaceAdditionalQueryParams_u24lambda_u2434 = builder = this;
            boolean bl = false;
            $this$replaceAdditionalQueryParams_u24lambda_u2434.additionalQueryParams.replace(key, values2);
            return builder;
        }

        @NotNull
        public final Builder replaceAllAdditionalQueryParams(@NotNull QueryParams additionalQueryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalQueryParams, "additionalQueryParams");
            Builder $this$replaceAllAdditionalQueryParams_u24lambda_u2435 = builder = this;
            boolean bl = false;
            $this$replaceAllAdditionalQueryParams_u24lambda_u2435.additionalQueryParams.replaceAll(additionalQueryParams);
            return builder;
        }

        @NotNull
        public final Builder replaceAllAdditionalQueryParams(@NotNull Map<String, ? extends Iterable<String>> additionalQueryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalQueryParams, "additionalQueryParams");
            Builder $this$replaceAllAdditionalQueryParams_u24lambda_u2436 = builder = this;
            boolean bl = false;
            $this$replaceAllAdditionalQueryParams_u24lambda_u2436.additionalQueryParams.replaceAll(additionalQueryParams);
            return builder;
        }

        @NotNull
        public final Builder removeAdditionalQueryParams(@NotNull String key) {
            Builder builder;
            Intrinsics.checkNotNullParameter(key, "key");
            Builder $this$removeAdditionalQueryParams_u24lambda_u2437 = builder = this;
            boolean bl = false;
            $this$removeAdditionalQueryParams_u24lambda_u2437.additionalQueryParams.remove(key);
            return builder;
        }

        @NotNull
        public final Builder removeAllAdditionalQueryParams(@NotNull Set<String> keys2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(keys2, "keys");
            Builder $this$removeAllAdditionalQueryParams_u24lambda_u2438 = builder = this;
            boolean bl = false;
            $this$removeAllAdditionalQueryParams_u24lambda_u2438.additionalQueryParams.removeAll(keys2);
            return builder;
        }

        @NotNull
        public final TranslationCreateParams build() {
            return new TranslationCreateParams(this.body.build(), this.additionalHeaders.build(), this.additionalQueryParams.build(), null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/openai/models/audio/translations/TranslationCreateParams$Companion;", "", "()V", "builder", "Lcom/openai/models/audio/translations/TranslationCreateParams$Builder;", "openai-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0003\u0017\u0018\u0019B\u0015\b\u0003\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0007J\u0006\u0010\t\u001a\u00020\u0004J\u0013\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\u0006\u0010\u0013\u001a\u00020\u0000J\r\u0010\u0014\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0015J\u0006\u0010\u0002\u001a\u00020\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/openai/models/audio/translations/TranslationCreateParams$ResponseFormat;", "Lcom/openai/core/Enum;", "value", "Lcom/openai/core/JsonField;", "", "(Lcom/openai/core/JsonField;)V", "validated", "", "_value", "asString", "equals", "other", "", "hashCode", "", "isValid", "known", "Lcom/openai/models/audio/translations/TranslationCreateParams$ResponseFormat$Known;", "toString", "validate", "validity", "validity$openai_java_core", "Lcom/openai/models/audio/translations/TranslationCreateParams$ResponseFormat$Value;", "Companion", "Known", "Value", "openai-java-core"})
    public static final class ResponseFormat
    implements Enum {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final JsonField<String> value;
        private boolean validated;
        @JvmField
        @NotNull
        public static final ResponseFormat JSON = Companion.of("json");
        @JvmField
        @NotNull
        public static final ResponseFormat TEXT = Companion.of("text");
        @JvmField
        @NotNull
        public static final ResponseFormat SRT = Companion.of("srt");
        @JvmField
        @NotNull
        public static final ResponseFormat VERBOSE_JSON = Companion.of("verbose_json");
        @JvmField
        @NotNull
        public static final ResponseFormat VTT = Companion.of("vtt");

        @JsonCreator
        private ResponseFormat(JsonField<String> value) {
            this.value = value;
        }

        @JsonValue
        @NotNull
        public final JsonField<String> _value() {
            return this.value;
        }

        @NotNull
        public final Value value() {
            ResponseFormat responseFormat = this;
            return Intrinsics.areEqual(responseFormat, JSON) ? Value.JSON : (Intrinsics.areEqual(responseFormat, TEXT) ? Value.TEXT : (Intrinsics.areEqual(responseFormat, SRT) ? Value.SRT : (Intrinsics.areEqual(responseFormat, VERBOSE_JSON) ? Value.VERBOSE_JSON : (Intrinsics.areEqual(responseFormat, VTT) ? Value.VTT : Value._UNKNOWN))));
        }

        @NotNull
        public final Known known() {
            Known known;
            ResponseFormat responseFormat = this;
            if (Intrinsics.areEqual(responseFormat, JSON)) {
                known = Known.JSON;
            } else if (Intrinsics.areEqual(responseFormat, TEXT)) {
                known = Known.TEXT;
            } else if (Intrinsics.areEqual(responseFormat, SRT)) {
                known = Known.SRT;
            } else if (Intrinsics.areEqual(responseFormat, VERBOSE_JSON)) {
                known = Known.VERBOSE_JSON;
            } else if (Intrinsics.areEqual(responseFormat, VTT)) {
                known = Known.VTT;
            } else {
                throw new OpenAIInvalidDataException("Unknown ResponseFormat: " + this.value, null, 2, null);
            }
            return known;
        }

        @NotNull
        public final String asString() {
            String string = this._value().asString().orElseThrow(ResponseFormat::asString$lambda$0);
            Intrinsics.checkNotNullExpressionValue(string, "_value().asString().orEl\u2026Value is not a String\") }");
            return string;
        }

        @NotNull
        public final ResponseFormat validate() {
            ResponseFormat responseFormat;
            ResponseFormat $this$validate_u24lambda_u241 = responseFormat = this;
            boolean bl = false;
            if (!$this$validate_u24lambda_u241.validated) {
                $this$validate_u24lambda_u241.known();
                $this$validate_u24lambda_u241.validated = true;
            }
            return responseFormat;
        }

        public final boolean isValid() {
            boolean bl;
            try {
                this.validate();
                bl = true;
            }
            catch (OpenAIInvalidDataException e) {
                bl = false;
            }
            return bl;
        }

        public final /* synthetic */ int validity$openai_java_core() {
            return this.value() == Value._UNKNOWN ? 0 : 1;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ResponseFormat && Intrinsics.areEqual(this.value, ((ResponseFormat)other).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @NotNull
        public String toString() {
            return this.value.toString();
        }

        private static final OpenAIInvalidDataException asString$lambda$0() {
            return new OpenAIInvalidDataException("Value is not a String", null, 2, null);
        }

        @JvmStatic
        @NotNull
        public static final ResponseFormat of(@NotNull String value) {
            return Companion.of(value);
        }

        public /* synthetic */ ResponseFormat(JsonField value, DefaultConstructorMarker $constructor_marker) {
            this(value);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/openai/models/audio/translations/TranslationCreateParams$ResponseFormat$Companion;", "", "()V", "JSON", "Lcom/openai/models/audio/translations/TranslationCreateParams$ResponseFormat;", "SRT", "TEXT", "VERBOSE_JSON", "VTT", "of", "value", "", "openai-java-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final ResponseFormat of(@NotNull String value) {
                Intrinsics.checkNotNullParameter(value, "value");
                return new ResponseFormat(JsonField.Companion.of(value), null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/openai/models/audio/translations/TranslationCreateParams$ResponseFormat$Known;", "", "(Ljava/lang/String;I)V", "JSON", "TEXT", "SRT", "VERBOSE_JSON", "VTT", "openai-java-core"})
        public static final class Known
        extends java.lang.Enum<Known> {
            public static final /* enum */ Known JSON = new Known();
            public static final /* enum */ Known TEXT = new Known();
            public static final /* enum */ Known SRT = new Known();
            public static final /* enum */ Known VERBOSE_JSON = new Known();
            public static final /* enum */ Known VTT = new Known();
            private static final /* synthetic */ Known[] $VALUES;

            public static Known[] values() {
                return (Known[])$VALUES.clone();
            }

            public static Known valueOf(String value) {
                return java.lang.Enum.valueOf(Known.class, value);
            }

            static {
                $VALUES = knownArray = new Known[]{Known.JSON, Known.TEXT, Known.SRT, Known.VERBOSE_JSON, Known.VTT};
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/openai/models/audio/translations/TranslationCreateParams$ResponseFormat$Value;", "", "(Ljava/lang/String;I)V", "JSON", "TEXT", "SRT", "VERBOSE_JSON", "VTT", "_UNKNOWN", "openai-java-core"})
        public static final class Value
        extends java.lang.Enum<Value> {
            public static final /* enum */ Value JSON = new Value();
            public static final /* enum */ Value TEXT = new Value();
            public static final /* enum */ Value SRT = new Value();
            public static final /* enum */ Value VERBOSE_JSON = new Value();
            public static final /* enum */ Value VTT = new Value();
            public static final /* enum */ Value _UNKNOWN = new Value();
            private static final /* synthetic */ Value[] $VALUES;

            public static Value[] values() {
                return (Value[])$VALUES.clone();
            }

            public static Value valueOf(String value) {
                return java.lang.Enum.valueOf(Value.class, value);
            }

            static {
                $VALUES = valueArray = new Value[]{Value.JSON, Value.TEXT, Value.SRT, Value.VERBOSE_JSON, Value.VTT, Value._UNKNOWN};
            }
        }
    }
}

