/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.io.IOException;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request2, EntityDetails entity2, HttpContext context) throws HttpException, IOException {
        Args.notNull(request2, "HTTP request");
        if (!request2.containsHeader("Expect")) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion version;
            ProtocolVersion protocolVersion = version = request2.getVersion() != null ? request2.getVersion() : HttpVersion.HTTP_1_1;
            if (entity2 != null && entity2.getContentLength() != 0L && !version.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request2.addHeader("Expect", "100-continue");
            }
        }
    }
}

