/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.model.openai;

import com.openai.client.OpenAIClientAsync;
import com.openai.client.okhttp.OpenAIOkHttpClientAsync;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAIUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OpenAIUtils.class);
    private static final Object LOCK = new Object();
    private static final Map<ReferenceKey, ReferenceValue> cache = new HashMap<ReferenceKey, ReferenceValue>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenAIClientAsync createAsyncClient(String baseUrl, String apiKey, int numRetry) {
        Object object = LOCK;
        synchronized (object) {
            ReferenceKey key = new ReferenceKey(baseUrl, apiKey);
            ReferenceValue value = cache.get(key);
            if (value != null) {
                LOG.debug("Returning an existing OpenAI client.");
                value.referenceCount.incrementAndGet();
                return value.client;
            }
            LOG.debug("Building a new OpenAI client.");
            OpenAIClientAsync client = OpenAIOkHttpClientAsync.builder().apiKey(apiKey).baseUrl(baseUrl).maxRetries(numRetry).build();
            cache.put(key, new ReferenceValue(client));
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAsyncClient(String baseUrl, String apiKey) {
        Object object = LOCK;
        synchronized (object) {
            ReferenceKey key = new ReferenceKey(baseUrl, apiKey);
            ReferenceValue value = cache.get(key);
            Preconditions.checkNotNull((Object)value, (String)"The creation and release of OpenAI client does not match.");
            int count = value.referenceCount.decrementAndGet();
            if (count == 0) {
                LOG.debug("Closing the OpenAI client.");
                cache.remove(key);
                value.client.close();
            }
        }
    }

    @VisibleForTesting
    static Map<ReferenceKey, ReferenceValue> getCache() {
        return cache;
    }

    private static class ReferenceKey {
        private final String baseUrl;
        private final String apiKey;

        private ReferenceKey(String baseUrl, String apiKey) {
            this.baseUrl = baseUrl;
            this.apiKey = apiKey;
        }

        public int hashCode() {
            return Objects.hash(this.baseUrl, this.apiKey);
        }

        public boolean equals(Object obj) {
            return obj instanceof ReferenceKey && Objects.equals(this.baseUrl, ((ReferenceKey)obj).baseUrl) && Objects.equals(this.apiKey, ((ReferenceKey)obj).apiKey);
        }
    }

    private static class ReferenceValue {
        private final OpenAIClientAsync client;
        private final AtomicInteger referenceCount;

        private ReferenceValue(OpenAIClientAsync client) {
            this.client = client;
            this.referenceCount = new AtomicInteger(1);
        }
    }
}

